/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactChooser
extends ElementsChooser<ArtifactPointer> {
    private static final Comparator<ArtifactPointer> ARTIFACT_COMPARATOR = (o1, o2) -> o1.getArtifactName().compareToIgnoreCase(o2.getArtifactName());
    private static final MultiStateElementsChooser.ElementProperties INVALID_ARTIFACT_PROPERTIES = new MultiStateElementsChooser.ElementProperties(){

        public Icon getIcon() {
            return AllIcons.Nodes.Artifact;
        }

        public Color getColor() {
            return JBColor.RED;
        }
    };

    public ArtifactChooser(List<ArtifactPointer> pointers) {
        super(pointers, false);
        for (ArtifactPointer pointer : pointers) {
            if (pointer.getArtifact() != null) continue;
            this.setElementProperties(pointer, INVALID_ARTIFACT_PROPERTIES);
        }
        this.sort(ARTIFACT_COMPARATOR);
    }

    protected String getItemText(@NotNull ArtifactPointer value2) {
        if (value2 == null) {
            ArtifactChooser.$$$reportNull$$$0(0);
        }
        return value2.getArtifactName();
    }

    protected Icon getItemIcon(@NotNull ArtifactPointer value2) {
        Artifact artifact;
        if (value2 == null) {
            ArtifactChooser.$$$reportNull$$$0(1);
        }
        return (artifact = value2.getArtifact()) != null ? artifact.getArtifactType().getIcon() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "value";
        objectArray2[1] = "com/intellij/packaging/impl/run/ArtifactChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

