/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.run.ArtifactChooser;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskBase;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public abstract class BuildArtifactsBeforeRunTaskProviderBase<T extends BuildArtifactsBeforeRunTaskBase<?>>
extends BeforeRunTaskProvider<T> {
    private final Project myProject;
    @NotNull
    private final Class<T> myTaskClass;

    public BuildArtifactsBeforeRunTaskProviderBase(@NotNull Class<T> taskClass, Project project) {
        if (taskClass == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myTaskClass = taskClass;
        project.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactAdapter(){

            public void artifactRemoved(@NotNull Artifact artifact) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)BuildArtifactsBeforeRunTaskProviderBase.this.myProject);
                for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
                    List tasks = runManager.getBeforeRunTasks(configuration, BuildArtifactsBeforeRunTaskProviderBase.this.getId());
                    for (BuildArtifactsBeforeRunTaskBase task : tasks) {
                        ArtifactPointer[] pointers;
                        String artifactName = artifact.getName();
                        List<ArtifactPointer> pointersList = task.getArtifactPointers();
                        for (ArtifactPointer pointer : pointers = pointersList.toArray(new ArtifactPointer[0])) {
                            if (!pointer.getArtifactName().equals(artifactName) || ArtifactManager.getInstance((Project)BuildArtifactsBeforeRunTaskProviderBase.this.myProject).findArtifact(artifactName) != null) continue;
                            task.removeArtifact(pointer);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProviderBase$1", "artifactRemoved"));
            }
        });
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull T task) {
        if (runConfiguration == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(1);
        }
        if (task == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(2);
        }
        Artifact[] artifacts = ArtifactManager.getInstance((Project)this.myProject).getArtifacts();
        THashSet pointers = new THashSet();
        for (Artifact artifact : artifacts) {
            pointers.add(ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact));
        }
        pointers.addAll(((BuildArtifactsBeforeRunTaskBase)((Object)task)).getArtifactPointers());
        ArtifactChooser chooser = new ArtifactChooser(new ArrayList<ArtifactPointer>((Collection<ArtifactPointer>)pointers));
        chooser.markElements(((BuildArtifactsBeforeRunTaskBase)((Object)task)).getArtifactPointers());
        chooser.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(JavaCompilerBundle.message((String)"build.artifacts.before.run.selector.title", (Object[])new Object[0]));
        builder.setDimensionServiceKey("#BuildArtifactsBeforeRunChooser");
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)((Object)chooser));
        builder.setPreferredFocusComponent((JComponent)((Object)chooser));
        if (builder.show() == 0) {
            ((BuildArtifactsBeforeRunTaskBase)((Object)task)).setArtifactPointers(chooser.getMarkedElements());
            return true;
        }
        return false;
    }

    public T createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.doCreateTask(this.myProject);
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull T task) {
        if (configuration == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(4);
        }
        if (task == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(5);
        }
        for (ArtifactPointer pointer : ((BuildArtifactsBeforeRunTaskBase)((Object)task)).getArtifactPointers()) {
            if (pointer.getArtifact() == null) continue;
            return true;
        }
        return false;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull T task) {
        if (context == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(7);
        }
        if (env == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(8);
        }
        if (task == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(9);
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ReadAction.run(() -> {
            List<ArtifactPointer> pointers = task.getArtifactPointers();
            for (ArtifactPointer pointer : pointers) {
                ContainerUtil.addIfNotNull((Collection)artifacts, (Object)pointer.getArtifact());
            }
        });
        if (this.myProject.isDisposed()) {
            return false;
        }
        ProjectTask artifactsBuildProjectTask = this.createProjectTask(this.myProject, artifacts);
        Object sessionId = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)env);
        ProjectTaskContext projectTaskContext = new ProjectTaskContext(sessionId);
        env.copyUserDataTo((UserDataHolderBase)projectTaskContext);
        Promise resultPromise = ProjectTaskManager.getInstance((Project)this.myProject).run(projectTaskContext, artifactsBuildProjectTask);
        ProjectTaskManager.Result taskResult = (ProjectTaskManager.Result)ProjectTaskManagerImpl.waitForPromise((Promise)resultPromise);
        return taskResult != null && !taskResult.isAborted() && !taskResult.hasErrors();
    }

    protected void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, @NotNull Artifact artifact, boolean enable) {
        DataContext dataContext;
        ConfigurationSettingsEditorWrapper editor;
        if (runConfigurationEditorComponent == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(10);
        }
        if (artifact == null) {
            BuildArtifactsBeforeRunTaskProviderBase.$$$reportNull$$$0(11);
        }
        if ((editor = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext = DataManager.getInstance().getDataContext((Component)runConfigurationEditorComponent))) != null) {
            List tasks = ContainerUtil.findAll((Collection)editor.getStepsBeforeLaunch(), this.myTaskClass);
            if (enable && tasks.isEmpty()) {
                T task = this.doCreateTask(this.myProject);
                ((BuildArtifactsBeforeRunTaskBase)((Object)task)).addArtifact(artifact);
                task.setEnabled(true);
                editor.addBeforeLaunchStep(task);
            } else {
                for (BuildArtifactsBeforeRunTaskBase task : tasks) {
                    if (enable) {
                        task.addArtifact(artifact);
                        task.setEnabled(true);
                        continue;
                    }
                    task.removeArtifact(artifact);
                    if (!task.getArtifactPointers().isEmpty()) continue;
                    task.setEnabled(false);
                }
            }
        }
    }

    protected abstract T doCreateTask(Project var1);

    protected abstract ProjectTask createProjectTask(Project var1, List<Artifact> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationEditorComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProviderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setBuildArtifactBeforeRunOption";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

