/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.packaging.impl.elements.ModuleElementTypeBase;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleElementPresentation
extends TreeNodePresentation {
    private final ModulePointer myModulePointer;
    private final ArtifactEditorContext myContext;
    private final ModuleElementTypeBase myElementType;

    public ModuleElementPresentation(@Nullable ModulePointer modulePointer, @NotNull ArtifactEditorContext context, @NotNull ModuleElementTypeBase elementType) {
        if (context == null) {
            ModuleElementPresentation.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            ModuleElementPresentation.$$$reportNull$$$0(1);
        }
        this.myModulePointer = modulePointer;
        this.myContext = context;
        this.myElementType = elementType;
    }

    public String getPresentableName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : "<unknown>";
    }

    public boolean canNavigateToSource() {
        return this.findModule() != null;
    }

    @Nullable
    private Module findModule() {
        return this.myModulePointer != null ? this.myModulePointer.getModule() : null;
    }

    public void navigateToSource() {
        Module module = this.findModule();
        if (module != null) {
            this.myContext.selectModule(module);
        }
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        ModifiableModuleModel moduleModel;
        if (presentationData == null) {
            ModuleElementPresentation.$$$reportNull$$$0(2);
        }
        Module module = this.findModule();
        presentationData.setIcon(this.myElementType.getElementIcon(module));
        String moduleName = module != null ? ((moduleModel = this.myContext.getModifiableModuleModel()) != null ? moduleModel.getActualName(module) : module.getName()) : (this.myModulePointer != null ? this.myModulePointer.getModuleName() : "<unknown>");
        String text2 = this.myElementType.getElementText(moduleName);
        presentationData.addText(text2, module != null ? mainAttributes : SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public int getWeight() {
        return 20;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/ui/ModuleElementPresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

