/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectImportedProjectsStep<T>
extends ProjectImportWizardStep {
    private final JPanel panel;
    protected final ElementsChooser<T> fileChooser = new ElementsChooser<T>(true){

        protected String getItemText(@NotNull T item) {
            if (item == null) {
                1.$$$reportNull$$$0(0);
            }
            return SelectImportedProjectsStep.this.getElementText(item);
        }

        protected Icon getItemIcon(@NotNull T item) {
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            return SelectImportedProjectsStep.this.getElementIcon(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "item";
            objectArray2[1] = "com/intellij/projectImport/SelectImportedProjectsStep$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getItemText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getItemIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final JCheckBox openModuleSettingsCheckBox;

    public SelectImportedProjectsStep(WizardContext context) {
        super(context);
        this.panel = new JPanel((LayoutManager)new GridLayoutManager(3, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        this.panel.add((Component)this.fileChooser, new GridConstraints(0, 0, 1, 1, 1, 3, 5, 5, null, null, null));
        AnAction selectAllAction = new AnAction(RefactoringBundle.message((String)"select.all.button")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SelectImportedProjectsStep.this.fileChooser.setAllElementsMarked(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/projectImport/SelectImportedProjectsStep$2", "actionPerformed"));
            }
        };
        AnAction unselectAllAction = new AnAction(RefactoringBundle.message((String)"unselect.all.button")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                SelectImportedProjectsStep.this.fileChooser.setAllElementsMarked(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/projectImport/SelectImportedProjectsStep$3", "actionPerformed"));
            }
        };
        JComponent actionToolbar = ActionManager.getInstance().createButtonToolbar("unknown", (ActionGroup)new DefaultActionGroup(new AnAction[]{selectAllAction, unselectAllAction}));
        this.panel.add((Component)actionToolbar, new GridConstraints(1, 0, 1, 1, 1, 1, 5, 1, null, null, null));
        this.openModuleSettingsCheckBox = new JCheckBox(JavaUiBundle.message("project.import.show.settings.after", new Object[0]));
        this.panel.add((Component)this.openModuleSettingsCheckBox, new GridConstraints(2, 0, 1, 1, 2, 1, 5, 0, null, null, null));
    }

    @Nullable
    protected Icon getElementIcon(T item) {
        return null;
    }

    protected abstract String getElementText(T var1);

    public JComponent getComponent() {
        return this.panel;
    }

    protected boolean isElementEnabled(T element) {
        return true;
    }

    public void updateStep() {
        this.fileChooser.clear();
        Iterator<T> iterator = this.getContext().getList().iterator();
        while (iterator.hasNext()) {
            T element;
            boolean isEnabled = this.isElementEnabled(element = iterator.next());
            this.fileChooser.addElement(element, isEnabled && this.getContext().isMarked(element));
            if (isEnabled) continue;
            this.fileChooser.disableElement(element);
        }
        this.fileChooser.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaUiBundle.message("project.import.select.title", this.getContext().getName()), (boolean)false));
        this.openModuleSettingsCheckBox.setSelected(this.getBuilder().isOpenProjectSettingsAfter());
    }

    public boolean validate() throws ConfigurationException {
        this.getContext().setList(this.fileChooser.getMarkedElements());
        if (this.fileChooser.getMarkedElements().size() == 0) {
            throw new ConfigurationException("Nothing found to import", "Unable to proceed");
        }
        return true;
    }

    public void updateDataModel() {
    }

    public void onStepLeaving() {
        super.onStepLeaving();
        this.getContext().setOpenProjectSettingsAfter(this.openModuleSettingsCheckBox.isSelected());
    }

    public ProjectImportBuilder<T> getContext() {
        return this.getBuilder();
    }
}

