/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.classes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.PsiUtil;

public class AnyInnerFilter
implements ElementFilter {
    private final ElementFilter myFilter;

    public AnyInnerFilter(ElementFilter filter) {
        this.myFilter = filter;
    }

    public ElementFilter getFilter() {
        return this.myFilter;
    }

    public boolean isAcceptable(Object classElement, PsiElement place) {
        if (classElement instanceof PsiClass) {
            PsiClass[] inners;
            Project project = ((PsiClass)classElement).getProject();
            for (PsiClass inner : inners = ((PsiClass)classElement).getInnerClasses()) {
                if (!inner.hasModifierProperty("static") || !PsiUtil.isAccessible((Project)project, (PsiMember)inner, (PsiElement)place, null) || !this.myFilter.isAcceptable((Object)inner, place)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public String toString() {
        return "any-inner(" + this.getFilter().toString() + ")";
    }
}

