/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.classes;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionUtil;

public class AssignableFromContextFilter
implements ElementFilter {
    private SoftReference myCurrentContext = new SoftReference(null);
    private SoftReference myCachedClass = new SoftReference(null);

    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionUtil.isAssignable(PsiClass.class, (Class)hintClass);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (this.myCurrentContext.get() != context) {
            PsiElement cachedClass;
            this.myCurrentContext = new SoftReference((Object)context);
            for (cachedClass = context; cachedClass != null && !(cachedClass instanceof PsiClass); cachedClass = cachedClass.getContext()) {
            }
            this.myCachedClass = new SoftReference((Object)cachedClass);
        }
        if (this.myCachedClass.get() instanceof PsiClass && element instanceof PsiClass) {
            String qualifiedName = ((PsiClass)this.myCachedClass.get()).getQualifiedName();
            return qualifiedName != null && (qualifiedName.equals(((PsiClass)element).getQualifiedName()) || ((PsiClass)element).isInheritor((PsiClass)this.myCachedClass.get(), true));
        }
        return false;
    }

    public String toString() {
        return "assignable-from-context";
    }
}

