/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.Interner;
import gnu.trove.THashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConstantExpressionVisitor
extends JavaElementVisitor
implements PsiConstantEvaluationHelper.AuxEvaluator {
    private final Interner<String> myInterner = Interner.createStringInterner();
    private Set<PsiVariable> myVisitedVars;
    private final Map<PsiElement, Object> myCachedValues = new HashMap<PsiElement, Object>();
    private final boolean myThrowExceptionOnOverflow;
    private Object myResult;
    private final PsiConstantEvaluationHelper.AuxEvaluator myAuxEvaluator;

    ConstantExpressionVisitor(Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        this.myVisitedVars = visitedVars;
        this.myThrowExceptionOnOverflow = throwExceptionOnOverflow;
        this.myAuxEvaluator = auxEvaluator;
    }

    Object handle(PsiElement element) {
        this.myResult = null;
        element.accept((PsiElementVisitor)this);
        this.store(element, this.myResult);
        return this.myResult;
    }

    private Object getStoredValue(PsiElement element) {
        return this.myCachedValues.remove(element);
    }

    void store(PsiElement element, Object value2) {
        this.myCachedValues.put(element, value2);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        Object value2 = expression2.getValue();
        this.myResult = value2 instanceof String ? this.myInterner.intern((Object)((String)value2)) : value2;
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        PsiTypeElement castTypeElement = expression2.getCastType();
        PsiExpression operand2 = expression2.getOperand();
        Object opValue = this.getStoredValue((PsiElement)operand2);
        if (castTypeElement == null || opValue == null) {
            this.myResult = null;
            return;
        }
        PsiType castType = castTypeElement.getType();
        if (!(castType instanceof PsiPrimitiveType) && !castType.equalsToText("java.lang.String")) {
            this.myResult = null;
            return;
        }
        this.myResult = ConstantExpressionUtil.computeCastTo((Object)opValue, (PsiType)castType);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        Object then = this.getStoredValue((PsiElement)expression2.getThenExpression());
        Object els = this.getStoredValue((PsiElement)expression2.getElseExpression());
        Object condition2 = this.getStoredValue((PsiElement)expression2.getCondition());
        if (then == null || els == null) {
            this.myResult = null;
            return;
        }
        Object value2 = null;
        if (condition2 instanceof Boolean) {
            value2 = (Boolean)condition2 != false ? then : els;
        }
        this.myResult = value2;
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        PsiExpression[] operands2 = expression2.getOperands();
        Object lValue = this.getStoredValue((PsiElement)operands2[0]);
        if (lValue == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression2.getOperationTokenType();
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            Object rValue = this.getStoredValue((PsiElement)operand2);
            if (rValue == null) {
                this.myResult = null;
                break;
            }
            this.myResult = this.compute(lValue, rValue, tokenType, expression2);
            if (this.myResult == null) break;
            lValue = this.myResult;
        }
        if (this.myResult instanceof String) {
            this.myResult = this.myInterner.intern((Object)((String)this.myResult));
        }
    }

    private Object compute(Object lOperandValue, Object rOperandValue, IElementType tokenType, PsiPolyadicExpression expression2) {
        Object value2 = null;
        if (tokenType == JavaTokenType.PLUS) {
            if (lOperandValue instanceof String || rOperandValue instanceof String) {
                String l = ConstantExpressionVisitor.computeValueToString(lOperandValue);
                String r = ConstantExpressionVisitor.computeValueToString(rOperandValue);
                value2 = l + r;
            } else {
                if (lOperandValue instanceof Character) {
                    lOperandValue = (int)((Character)lOperandValue).charValue();
                }
                if (rOperandValue instanceof Character) {
                    rOperandValue = (int)((Character)rOperandValue).charValue();
                }
                if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                    if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                        value2 = new Double(((Number)lOperandValue).doubleValue() + ((Number)rOperandValue).doubleValue());
                        this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                    } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                        value2 = new Float(((Number)lOperandValue).floatValue() + ((Number)rOperandValue).floatValue());
                        this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                    } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                        long r;
                        long l = ((Number)lOperandValue).longValue();
                        value2 = l + (r = ((Number)rOperandValue).longValue());
                        this.checkAdditionOverflow((Long)value2 >= 0L, l >= 0L, r >= 0L, (PsiElement)expression2);
                    } else {
                        int r;
                        int l = ((Number)lOperandValue).intValue();
                        value2 = l + (r = ((Number)rOperandValue).intValue());
                        this.checkAdditionOverflow((Integer)value2 >= 0, l >= 0, r >= 0, (PsiElement)expression2);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.MINUS) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() - ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() - ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r;
                    long l = ((Number)lOperandValue).longValue();
                    value2 = l - (r = ((Number)rOperandValue).longValue());
                    this.checkAdditionOverflow((Long)value2 >= 0L, l >= 0L, r < 0L, (PsiElement)expression2);
                } else {
                    int r;
                    int l = ((Number)lOperandValue).intValue();
                    value2 = l - (r = ((Number)rOperandValue).intValue());
                    this.checkAdditionOverflow((Integer)value2 >= 0, l >= 0, r < 0, (PsiElement)expression2);
                }
            }
        } else if (tokenType == JavaTokenType.ANDAND) {
            if (lOperandValue instanceof Boolean && !((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && !((Boolean)rOperandValue).booleanValue()) {
                value2 = Boolean.FALSE;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OROR) {
            if (lOperandValue instanceof Boolean && ((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && ((Boolean)rOperandValue).booleanValue()) {
                value2 = Boolean.TRUE;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            value2 = ConstantExpressionVisitor.compareNumbers(lOperandValue, rOperandValue, tokenType);
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            value2 = ConstantExpressionVisitor.handleEqualityComparison(lOperandValue, rOperandValue, tokenType);
        } else if (tokenType == JavaTokenType.ASTERISK) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() * ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() * ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value2 = l * r;
                    this.checkMultiplicationOverflow((Long)value2, l, r, (PsiElement)expression2);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value2 = l * r;
                    this.checkMultiplicationOverflow(((Integer)value2).intValue(), l, r, (PsiElement)expression2);
                }
            }
        } else if (tokenType == JavaTokenType.DIV) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() / ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() / ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r = ((Number)rOperandValue).longValue();
                    long l = ((Number)lOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, (PsiElement)expression2);
                    value2 = r == 0L ? null : Long.valueOf(l / r);
                } else {
                    int r = ((Number)rOperandValue).intValue();
                    int l = ((Number)lOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, (PsiElement)expression2);
                    value2 = r == 0 ? null : Integer.valueOf(l / r);
                }
            }
        } else if (tokenType == JavaTokenType.PERC) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                double rVal = ((Number)rOperandValue).doubleValue();
                if (this.myThrowExceptionOnOverflow && rVal == 0.0) {
                    throw new ConstantEvaluationOverflowException((PsiElement)expression2);
                }
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() % ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() % ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, (PsiElement)expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, (PsiElement)expression2);
                    value2 = r == 0L ? null : Long.valueOf(l % r);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, (PsiElement)expression2);
                    value2 = r == 0 ? null : Integer.valueOf(l % r);
                }
            }
        } else if (tokenType == JavaTokenType.LTLT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                if (lOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value2 = l << (int)r;
                    this.checkMultiplicationOverflow((Long)value2, l, (long)Math.pow(2.0, r & 0x3FL), (PsiElement)expression2);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value2 = l << r;
                    this.checkMultiplicationOverflow(((Integer)value2).intValue(), l, (long)Math.pow(2.0, r & 0x1F), (PsiElement)expression2);
                }
            }
        } else if (tokenType == JavaTokenType.GTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.GTGTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >>> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >>> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.AND) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() & ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() & ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() | ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() | ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.XOR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() ^ ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() ^ ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue ^ (Boolean)rOperandValue;
            }
        }
        return value2;
    }

    private static String computeValueToString(Object value2) {
        if (value2 instanceof PsiType) {
            if (value2 instanceof PsiArrayType) {
                return "class " + ClassUtil.getClassObjectPresentation((PsiType)((PsiType)value2));
            }
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)((PsiType)value2));
            String prefix = psiClass == null ? "" : (psiClass.isInterface() ? "interface " : "class ");
            return prefix + ((PsiType)value2).getCanonicalText();
        }
        return value2.toString();
    }

    @Nullable
    private static Boolean handleEqualityComparison(Object lOperandValue, Object rOperandValue, IElementType tokenType) {
        if (lOperandValue instanceof String && rOperandValue instanceof String || lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
            return lOperandValue.equals(rOperandValue) == (tokenType == JavaTokenType.EQEQ);
        }
        return ConstantExpressionVisitor.compareNumbers(lOperandValue, rOperandValue, tokenType);
    }

    private static Boolean compareNumbers(Object o1, Object o2, IElementType op) {
        int result;
        if (o1 instanceof Character) {
            o1 = (int)((Character)o1).charValue();
        }
        if (o2 instanceof Character) {
            o2 = (int)((Character)o2).charValue();
        }
        if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
            return null;
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (n1 instanceof Double || n2 instanceof Double) {
            double v1 = n1.doubleValue();
            double v2 = n2.doubleValue();
            if (Double.isNaN(v1) || Double.isNaN(v2)) {
                return op == JavaTokenType.NE;
            }
            result = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
        } else if (n1 instanceof Float || n2 instanceof Float) {
            float v1 = n1.floatValue();
            float v2 = n2.floatValue();
            if (Float.isNaN(v1) || Float.isNaN(v2)) {
                return op == JavaTokenType.NE;
            }
            result = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
        } else {
            result = n1 instanceof Long || n2 instanceof Long ? Long.compare(n1.longValue(), n2.longValue()) : Integer.compare(n1.intValue(), n2.intValue());
        }
        if (op == JavaTokenType.EQEQ) {
            return result == 0;
        }
        if (op == JavaTokenType.LT) {
            return result < 0;
        }
        if (op == JavaTokenType.LE) {
            return result <= 0;
        }
        if (op == JavaTokenType.GT) {
            return result > 0;
        }
        if (op == JavaTokenType.GE) {
            return result >= 0;
        }
        if (op == JavaTokenType.NE) {
            return result != 0;
        }
        throw new IllegalArgumentException("Unexpected operator: " + op);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        PsiExpression operand2 = expression2.getOperand();
        Object operandValue = this.getStoredValue((PsiElement)operand2);
        if (operandValue == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression2.getOperationTokenType();
        Object value2 = null;
        if (tokenType == JavaTokenType.MINUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                if (operandValue instanceof Double) {
                    value2 = new Double(-((Number)operandValue).doubleValue());
                } else if (operandValue instanceof Float) {
                    value2 = new Float(-((Number)operandValue).floatValue());
                } else if (operandValue instanceof Long) {
                    value2 = -((Number)operandValue).longValue();
                    if (this.myThrowExceptionOnOverflow && !(operand2 instanceof PsiLiteralExpression) && ((Number)operandValue).longValue() == Long.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException((PsiElement)expression2);
                    }
                } else {
                    value2 = -((Number)operandValue).intValue();
                    if (this.myThrowExceptionOnOverflow && !(operand2 instanceof PsiLiteralExpression) && ((Number)operandValue).intValue() == Integer.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException((PsiElement)expression2);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                value2 = operandValue;
            }
        } else if (tokenType == JavaTokenType.TILDE) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(operandValue)) {
                value2 = operandValue instanceof Long ? (Number)(((Number)operandValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL) : (Number)(~((Number)operandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.EXCL && operandValue instanceof Boolean) {
            value2 = (Boolean)operandValue == false;
        }
        this.myResult = value2;
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.myResult = this.getStoredValue((PsiElement)expression2.getExpression());
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        this.myResult = this.myAuxEvaluator != null ? this.myAuxEvaluator.computeExpression((PsiExpression)expression2, (PsiConstantEvaluationHelper.AuxEvaluator)this) : null;
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        PsiClass aClass;
        PsiType type2 = expression2.getOperand().getType();
        if (type2 instanceof PsiClassReferenceType && (aClass = ((PsiClassReferenceType)type2).resolve()) != null) {
            type2 = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createType(aClass, ((PsiClassReferenceType)type2).getParameters());
        }
        this.myResult = type2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiElement resolvedExpression;
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        while (qualifierExpression2 != null) {
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                this.myResult = null;
                return;
            }
            PsiReferenceExpression qualifier = (PsiReferenceExpression)qualifierExpression2;
            PsiElement resolved = qualifier.resolve();
            if (resolved instanceof PsiPackage) break;
            if (!(resolved instanceof PsiClass)) {
                this.myResult = null;
                return;
            }
            qualifierExpression2 = ((PsiReferenceExpression)qualifierExpression2).getQualifierExpression();
        }
        if ((resolvedExpression = expression2.resolve()) instanceof PsiEnumConstant) {
            String constant = ((PsiEnumConstant)resolvedExpression).getName();
            PsiReferenceExpression qualifier = (PsiReferenceExpression)expression2.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement element = qualifier.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            String name2 = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element));
            try {
                Class<?> aClass = Class.forName(name2);
                this.myResult = Enum.valueOf(aClass, constant);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (resolvedExpression instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolvedExpression;
            if (this.myVisitedVars != null && this.myVisitedVars.contains(variable)) {
                this.myResult = null;
                return;
            }
            Set<PsiVariable> oldVisitedVars = this.myVisitedVars;
            if (this.myVisitedVars == null) {
                this.myVisitedVars = new THashSet();
            }
            this.myVisitedVars.add(variable);
            try {
                Object object = this.myResult = variable instanceof PsiVariableEx ? ((PsiVariableEx)variable).computeConstantValue(this.myVisitedVars) : null;
                if (this.myResult == null && this.myAuxEvaluator != null) {
                    this.myResult = this.myAuxEvaluator.computeExpression((PsiExpression)expression2, (PsiConstantEvaluationHelper.AuxEvaluator)this);
                }
                return;
            }
            finally {
                this.myVisitedVars.remove(variable);
                this.myVisitedVars = oldVisitedVars;
            }
        }
        this.myResult = null;
    }

    private static boolean isIntegral(Object o) {
        return o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte || o instanceof Character;
    }

    private void checkDivisionOverflow(long l, long r, long minValue, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
        if (r == -1L && l == minValue) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkMultiplicationOverflow(long result, long l, long r, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L || l == 0L) {
            return;
        }
        if (result / r != l || l < 0L ^ r < 0L != result < 0L) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkAdditionOverflow(boolean resultPositive, boolean lPositive, boolean rPositive, PsiElement expression2) {
        boolean overflow;
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        boolean bl = overflow = lPositive == rPositive && lPositive != resultPositive;
        if (overflow) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkRealNumberOverflow(Object result, Object lOperandValue, Object rOperandValue, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (lOperandValue instanceof Float && ((Float)lOperandValue).isInfinite()) {
            return;
        }
        if (lOperandValue instanceof Double && ((Double)lOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Float && ((Float)rOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Double && ((Double)rOperandValue).isInfinite()) {
            return;
        }
        if (result instanceof Float && ((Float)result).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
        if (result instanceof Double && ((Double)result).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    public Object computeExpression(@NotNull PsiExpression expression2, @NotNull PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(0);
        }
        if (auxEvaluator == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(1);
        }
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, this.myVisitedVars, this.myThrowExceptionOnOverflow, auxEvaluator);
    }

    @NotNull
    public ConcurrentMap<PsiElement, Object> getCacheMap(boolean overflow) {
        throw new AssertionError((Object)"should not be called");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "auxEvaluator";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/ConstantExpressionVisitor";
        objectArray[2] = "computeExpression";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

