/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClsParameterImpl
extends ClsRepositoryPsiElement<PsiParameterStub>
implements PsiParameter {
    private final NotNullLazyValue<PsiTypeElement> myType;
    private volatile String myMirrorName;

    public ClsParameterImpl(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            ClsParameterImpl.$$$reportNull$$$0(0);
        }
        super(stub);
        this.myType = new AtomicNotNullLazyValue<PsiTypeElement>(){

            @NotNull
            protected PsiTypeElement compute() {
                PsiParameterStub stub = (PsiParameterStub)ClsParameterImpl.this.getStub();
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                return new ClsTypeElementImpl((PsiElement)ClsParameterImpl.this, typeText, '\u0000');
            }
        };
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcName(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (string == null) {
            ClsParameterImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private String calcName() {
        PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
        if (!parameterStub.isAutoGeneratedName()) {
            String string = parameterStub.getName();
            if (string == null) {
                ClsParameterImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        ClsMethodImpl method = (ClsMethodImpl)this.getDeclarationScope();
        PsiMethod sourceMethod = method.getSourceMirrorMethod();
        if (sourceMethod != null) {
            assert (sourceMethod != method) : method;
            String string = sourceMethod.getParameterList().getParameters()[this.getIndex()].getName();
            if (string == null) {
                ClsParameterImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        return this.getMirrorName();
    }

    public boolean isAutoGeneratedName() {
        return ((PsiParameterStubImpl)this.getStub()).isAutoGeneratedName() && ((ClsMethodImpl)this.getDeclarationScope()).getSourceMirrorMethod() == null;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            ClsParameterImpl.$$$reportNull$$$0(4);
        }
        throw ClsParameterImpl.cannotModifyException(this);
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement psiTypeElement = (PsiTypeElement)this.myType.getValue();
        if (psiTypeElement == null) {
            ClsParameterImpl.$$$reportNull$$$0(5);
        }
        return psiTypeElement;
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeElement().getType();
        if (psiType == null) {
            ClsParameterImpl.$$$reportNull$$$0(6);
        }
        return psiType;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        StubElement child = ((PsiParameterStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        assert (child != null);
        PsiModifierList psiModifierList = (PsiModifierList)child.getPsi();
        if (psiModifierList == null) {
            ClsParameterImpl.$$$reportNull$$$0(7);
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            ClsParameterImpl.$$$reportNull$$$0(8);
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiAnnotation[] annotations;
        if (buffer == null) {
            ClsParameterImpl.$$$reportNull$$$0(9);
        }
        for (PsiAnnotation annotation : annotations = this.getModifierList().getAnnotations()) {
            ClsParameterImpl.appendText((PsiElement)annotation, indentLevel, buffer);
            buffer.append(' ');
        }
        ClsParameterImpl.appendText((PsiElement)this.getTypeElement(), indentLevel, buffer, " ");
        buffer.append(this.getMirrorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String getMirrorName() {
        String mirrorName = this.myMirrorName;
        if (mirrorName == null) {
            PsiElement psiElement = this.getParent();
            synchronized (psiElement) {
                mirrorName = this.myMirrorName;
                if (mirrorName == null) {
                    this.myMirrorName = mirrorName = this.calcNiceParameterName();
                }
            }
        }
        String string = mirrorName;
        if (string == null) {
            ClsParameterImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private String calcNiceParameterName() {
        String name2 = null;
        PsiParameterStubImpl stub = (PsiParameterStubImpl)this.getStub();
        if (!stub.isAutoGeneratedName()) {
            name2 = stub.getName();
        }
        if (name2 == null) {
            String base = name2 = StringUtil.notNullize((String)JavaCodeStyleManager.getInstance((Project)this.getProject()).suggestCompiledParameterName(this.getType()), (String)"p");
            int n = 0;
            block0: while (true) {
                PsiParameter[] psiParameterArray = ((PsiParameterList)this.getParent()).getParameters();
                int n2 = psiParameterArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block0;
                    PsiParameter parameter2 = psiParameterArray[n3];
                    if (parameter2 == this) break block0;
                    String prevName = ((ClsParameterImpl)parameter2).getMirrorName();
                    if (name2.equals(prevName)) {
                        name2 = base + ++n;
                        continue block0;
                    }
                    ++n3;
                }
                break;
            }
        }
        String string = name2;
        if (string == null) {
            ClsParameterImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsParameterImpl.$$$reportNull$$$0(12);
        }
        this.setMirrorCheckingType(element, null);
        PsiParameter mirror = (PsiParameter)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        ClsParameterImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsParameterImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsParameterImpl.$$$reportNull$$$0(13);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameter((PsiParameter)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.getParent().getParent();
        if (psiElement == null) {
            ClsParameterImpl.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    private int getIndex() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        return stub.getParentStub().getChildrenStubs().indexOf(stub);
    }

    public boolean isVarArgs() {
        PsiParameterList paramList = (PsiParameterList)this.getParent();
        PsiMethod method = (PsiMethod)paramList.getParent();
        return method.isVarArgs() && this.getIndex() == paramList.getParametersCount() - 1;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope(this.getDeclarationScope());
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiParameter[] psiParameters;
        PsiMethod psiMethod;
        int index;
        PsiMethod clsMethod;
        PsiParameterList list = (PsiParameterList)ObjectUtils.tryCast((Object)this.getParent(), PsiParameterList.class);
        if (list != null && (clsMethod = (PsiMethod)ObjectUtils.tryCast((Object)list.getParent(), PsiMethod.class)) != null && (index = ArrayUtil.indexOf((Object[])list.getParameters(), (Object)((Object)this))) >= 0 && (psiMethod = (PsiMethod)ObjectUtils.tryCast((Object)clsMethod.getNavigationElement(), PsiMethod.class)) != null && psiMethod != clsMethod && (psiParameters = psiMethod.getParameterList().getParameters()).length > index) {
            PsiParameter psiParameter = psiParameters[index];
            if (psiParameter == null) {
                ClsParameterImpl.$$$reportNull$$$0(15);
            }
            return psiParameter;
        }
        ClsParameterImpl clsParameterImpl = this;
        if (clsParameterImpl == null) {
            ClsParameterImpl.$$$reportNull$$$0(16);
        }
        return clsParameterImpl;
    }

    public String toString() {
        return "PsiParameter";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsParameterImpl";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsParameterImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirrorName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNiceParameterName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

