/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class JavaSourceModuleNameIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> NAME = ID.create((String)"java.source.module.name");
    private final FileType myManifestFileType = FileTypeRegistry.getInstance().getFileTypeByExtension("MF");
    private final FileBasedIndex.InputFilter myFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{this.myManifestFileType}){

        public boolean acceptInput(@NotNull VirtualFile f) {
            if (f == null) {
                1.$$$reportNull$$$0(0);
            }
            return f.isInLocalFileSystem();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/psi/impl/java/stubs/index/JavaSourceModuleNameIndex$1", "acceptInput"));
        }
    };
    private final DataIndexer<String, Void, FileContent> myIndexer = data -> {
        try {
            String name2 = new Manifest(new ByteArrayInputStream(data.getContent())).getMainAttributes().getValue("Automatic-Module-Name");
            if (name2 != null) {
                return Collections.singletonMap(name2, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyMap();
    };

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myFilter;
        if (inputFilter == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(3);
        }
        return dataIndexer;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        Set<FileType> set = Collections.singleton(JavaClassFileType.INSTANCE);
        if (set == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public static Collection<VirtualFile> getFilesByKey(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(6);
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)moduleName, (GlobalSearchScope)new JavaAutoModuleFilterScope(scope));
        if (collection == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getAllKeys(@NotNull Project project) {
        if (project == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(8);
        }
        Collection collection = FileBasedIndex.getInstance().getAllKeys(NAME, project);
        if (collection == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/index/JavaSourceModuleNameIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesWithSizeLimitNotApplicable";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/index/JavaSourceModuleNameIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

