/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports;

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile root, @NotNull String name2) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(0);
        }
        if (root == null) {
            LightJavaModule.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(2);
        }
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myExports = AtomicNotNullLazyValue.createValue(() -> this.findExports());
        this.myRoot = root;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, name2);
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            LightJavaModule.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        List<PsiRequiresStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        Iterable iterable = (Iterable)this.myExports.getValue();
        if (iterable == null) {
            LightJavaModule.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList<PsiPackageAccessibilityStatement> exports = new ArrayList<PsiPackageAccessibilityStatement>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private final JavaDirectoryService service;
            {
                super(arg0);
                this.service = JavaDirectoryService.getInstance();
            }

            public boolean visitFile(@NotNull VirtualFile file) {
                String packageName;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.isDirectory() && !LightJavaModule.this.myRoot.equals(file) && (directory = LightJavaModule.this.getManager().findDirectory(file)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty((PsiDirectory[])new PsiDirectory[]{directory}, (String)packageName)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.getManager(), packageName));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/light/LightJavaModule$1", "visitFile"));
            }
        });
        return exports;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        List<PsiPackageAccessibilityStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        List<PsiUsesStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        List<PsiProvidesStatement> list = Collections.emptyList();
        if (list == null) {
            LightJavaModule.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        LightJavaModuleReferenceElement lightJavaModuleReferenceElement = this.myRefElement;
        if (lightJavaModuleReferenceElement == null) {
            LightJavaModule.$$$reportNull$$$0(9);
        }
        return lightJavaModuleReferenceElement;
    }

    @NotNull
    public String getName() {
        String string = this.myRefElement.getReferenceText();
        if (string == null) {
            LightJavaModule.$$$reportNull$$$0(10);
        }
        return string;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException("Cannot modify an automatic module '" + this.getName() + "'");
    }

    public PsiModifierList getModifierList() {
        return null;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(12);
        }
        return false;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)this.myManager.findDirectory(this.myRoot), (Object)super.getNavigationElement());
        if (psiElement == null) {
            LightJavaModule.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myRoot.equals(((LightJavaModule)((Object)obj)).myRoot) && this.getManager() == ((LightJavaModule)((Object)obj)).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    @NotNull
    public static LightJavaModule getModule(@NotNull PsiManager manager, @NotNull VirtualFile root) {
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(14);
        }
        if (root == null) {
            LightJavaModule.$$$reportNull$$$0(15);
        }
        LightJavaModule module = LightJavaModule.findModule(manager, root);
        assert (module != null) : root;
        LightJavaModule lightJavaModule = module;
        if (lightJavaModule == null) {
            LightJavaModule.$$$reportNull$$$0(16);
        }
        return lightJavaModule;
    }

    @Nullable
    public static LightJavaModule findModule(@NotNull PsiManager manager, @NotNull VirtualFile root) {
        PsiDirectory directory;
        if (manager == null) {
            LightJavaModule.$$$reportNull$$$0(17);
        }
        if (root == null) {
            LightJavaModule.$$$reportNull$$$0(18);
        }
        if ((directory = manager.findDirectory(root)) == null) {
            return null;
        }
        if (root.isInLocalFileSystem()) {
            return (LightJavaModule)((Object)CachedValuesManager.getCachedValue((PsiElement)directory, () -> {
                PsiFile file;
                VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
                if (manifest != null && (file = manager.findFile(manifest)) != null) {
                    String name2 = LightJavaModule.claimedModuleName(manifest);
                    LightJavaModule module = name2 != null ? new LightJavaModule(manager, root, name2) : null;
                    return CachedValueProvider.Result.create((Object)((Object)module), (Object[])new Object[]{file});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }));
        }
        return (LightJavaModule)((Object)CachedValuesManager.getCachedValue((PsiElement)directory, () -> LightJavaModule.lambda$findModule$2(manager, root, (PsiElement)directory)));
    }

    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        String claimed;
        VirtualFile manifest;
        if (jarRoot == null) {
            LightJavaModule.$$$reportNull$$$0(19);
        }
        if ((manifest = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) != null && (claimed = LightJavaModule.claimedModuleName(manifest)) != null) {
            String string = claimed;
            if (string == null) {
                LightJavaModule.$$$reportNull$$$0(20);
            }
            return string;
        }
        return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
    }

    @Nullable
    public static String claimedModuleName(@NotNull VirtualFile manifest) {
        String string;
        block9: {
            if (manifest == null) {
                LightJavaModule.$$$reportNull$$$0(21);
            }
            InputStream stream = manifest.getInputStream();
            try {
                string = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.getInstance(LightJavaModule.class).warn(manifest.getPath(), (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }

    @NotNull
    public static String moduleName(@NotNull String name2) {
        Matcher m;
        if (name2 == null) {
            LightJavaModule.$$$reportNull$$$0(22);
        }
        if ((m = Patterns.VERSION.matcher(name2)).find()) {
            name2 = name2.substring(0, m.start());
        }
        name2 = Patterns.NON_NAME.matcher(name2).replaceAll(".");
        name2 = Patterns.DOT_SEQUENCE.matcher(name2).replaceAll(".");
        String string = name2 = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)name2, (char)'.'), (char)'.');
        if (string == null) {
            LightJavaModule.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$findModule$2(PsiManager manager, VirtualFile root, PsiElement directory) {
        LightJavaModule module = new LightJavaModule(manager, root, LightJavaModule.moduleName(root));
        return CachedValueProvider.Result.create((Object)((Object)module), (Object[])new Object[]{directory});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarRoot";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightJavaModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequires";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpens";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvides";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moduleName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "claimedModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName) {
            if (manager == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(1);
            }
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myPackageName = packageName;
        }

        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(2);
            }
            return role;
        }

        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            List<PsiJavaModuleReferenceElement> list = Collections.emptyList();
            if (list == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public List<String> getModuleNames() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                LightPackageAccessibilityStatement.$$$reportNull$$$0(4);
            }
            return list;
        }

        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/light/LightJavaModule$LightPackageAccessibilityStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRole";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        private LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text2) {
            if (manager == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(1);
            }
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myText = text2;
        }

        @NotNull
        public String getReferenceText() {
            String string = this.myText;
            if (string == null) {
                LightJavaModuleReferenceElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiJavaModuleReference getReference() {
            return null;
        }

        public String toString() {
            return "PsiJavaModuleReference";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/light/LightJavaModule$LightJavaModuleReferenceElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

