/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LightMemberReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    @NotNull
    private final PsiMember myRefMember;
    private final PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    public LightMemberReference(@NotNull PsiManager manager, @NotNull PsiMember member, PsiSubstitutor substitutor) {
        if (manager == null) {
            LightMemberReference.$$$reportNull$$$0(0);
        }
        if (member == null) {
            LightMemberReference.$$$reportNull$$$0(1);
        }
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myRefMember = member;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public PsiElement resolve() {
        PsiMember psiMember = this.myRefMember;
        if (psiMember == null) {
            LightMemberReference.$$$reportNull$$$0(2);
        }
        return psiMember;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        return new CandidateInfo(resolved, substitutor);
    }

    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) {
                LightMemberReference.$$$reportNull$$$0(3);
            }
            return javaResolveResultArray;
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            LightMemberReference.$$$reportNull$$$0(4);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        if (processor2 == null) {
            LightMemberReference.$$$reportNull$$$0(5);
        }
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        LightReferenceParameterList parameterList = this.myParameterList;
        if (parameterList == null) {
            this.myParameterList = parameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return parameterList;
    }

    public String getQualifiedName() {
        String qualifiedName;
        PsiClass containingClass = this.myRefMember.getContainingClass();
        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return qualifiedName + '.' + this.myRefMember.getName();
        }
        return this.myRefMember.getName();
    }

    public String getReferenceName() {
        return this.getQualifiedName();
    }

    public String getText() {
        return this.myRefMember.getName() + this.getParameterList().getText();
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String name2 = this.getQualifiedName();
        if (name2 == null) {
            if (null == null) {
                LightMemberReference.$$$reportNull$$$0(6);
            }
            return null;
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            String string = name2;
            if (string == null) {
                LightMemberReference.$$$reportNull$$$0(7);
            }
            return string;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name2);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        String string = buf.toString();
        if (string == null) {
            LightMemberReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    public PsiElement copy() {
        return new LightMemberReference(this.myManager, this.myRefMember, this.mySubstitutor);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            LightMemberReference.$$$reportNull$$$0(9);
        }
        throw new IncorrectOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            LightMemberReference.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightMemberReference.$$$reportNull$$$0(11);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "LightClassReference:" + this.myRefMember.getName();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            LightMemberReference.$$$reportNull$$$0(12);
        }
        return element instanceof PsiClass && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public Object @NotNull [] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public PsiElement getElement() {
        LightMemberReference lightMemberReference = this;
        if (lightMemberReference == null) {
            LightMemberReference.$$$reportNull$$$0(13);
        }
        return lightMemberReference;
    }

    public boolean isValid() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null && !parameterList.isValid()) {
            return false;
        }
        return this.myRefMember == null || this.myRefMember.isValid();
    }

    public PsiType @NotNull [] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        PsiType[] psiTypeArray = parameterList == null ? PsiType.EMPTY_ARRAY : parameterList.getTypeArguments();
        if (psiTypeArray == null) {
            LightMemberReference.$$$reportNull$$$0(14);
        }
        return psiTypeArray;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public boolean isQualified() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightMemberReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightMemberReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

