/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.ConstructorReferencesSearchHelper;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.impl.search.PsiAnnotationMethodReferencesSearcher;
import com.intellij.psi.impl.search.SimpleAccessorReferenceSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MethodUsagesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        if (p == null) {
            MethodUsagesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MethodUsagesSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod method = p.getMethod();
        boolean[] isConstructor = new boolean[1];
        PsiManager[] psiManager = new PsiManager[1];
        String[] methodName = new String[1];
        boolean[] isValueAnnotation = new boolean[1];
        boolean[] needStrictSignatureSearch = new boolean[1];
        boolean strictSignatureSearch = p.isStrictSignatureSearch();
        PsiClass aClass = (PsiClass)DumbService.getInstance((Project)p.getProject()).runReadActionInSmartMode(() -> {
            PsiClass aClass1 = method.getContainingClass();
            if (aClass1 == null) {
                return null;
            }
            isConstructor[0] = method.isConstructor();
            psiManager[0] = aClass1.getManager();
            methodName[0] = method.getName();
            isValueAnnotation[0] = PsiUtil.isAnnotationMethod((PsiElement)method) && "value".equals(methodName[0]) && method.getParameterList().isEmpty();
            needStrictSignatureSearch[0] = strictSignatureSearch && (aClass1 instanceof PsiAnonymousClass || aClass1.hasModifierProperty("final") || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private"));
            return aClass1;
        });
        if (aClass == null) {
            return;
        }
        SearchRequestCollector collector = p.getOptimizer();
        SearchScope searchScope = (SearchScope)DumbService.getInstance((Project)p.getProject()).runReadActionInSmartMode(() -> ((MethodReferencesSearch.SearchParameters)p).getEffectiveSearchScope());
        if (searchScope == GlobalSearchScope.EMPTY_SCOPE) {
            return;
        }
        if (isConstructor[0]) {
            new ConstructorReferencesSearchHelper(psiManager[0]).processConstructorReferences(consumer, method, aClass, searchScope, p.getProject(), false, strictSignatureSearch, collector);
        }
        if (isValueAnnotation[0]) {
            ReadActionProcessor<PsiReference> refProcessor = PsiAnnotationMethodReferencesSearcher.createImplicitDefaultAnnotationMethodConsumer(consumer);
            ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).forEach(refProcessor);
        }
        if (needStrictSignatureSearch[0]) {
            ReferencesSearch.searchOptimized((PsiElement)method, (SearchScope)searchScope, (boolean)false, (SearchRequestCollector)collector, consumer);
            return;
        }
        if (StringUtil.isEmpty((String)methodName[0])) {
            return;
        }
        DumbService.getInstance((Project)p.getProject()).runReadActionInSmartMode(() -> {
            PsiMethod[] psiMethodArray;
            if (strictSignatureSearch) {
                PsiMethod[] psiMethodArray2 = new PsiMethod[1];
                psiMethodArray = psiMethodArray2;
                psiMethodArray2[0] = method;
            } else {
                psiMethodArray = aClass.findMethodsByName(methodName[0], false);
            }
            PsiMethod[] methods = psiMethodArray;
            short searchContext = 11;
            for (PsiMethod m : methods) {
                SearchScope methodUseScope = PsiSearchHelper.getInstance((Project)p.getProject()).getUseScope((PsiElement)m);
                collector.searchWord(methodName[0], searchScope.intersectWith(methodUseScope), searchContext, true, (PsiElement)m, (RequestResultProcessor)this.getTextOccurrenceProcessor(new PsiMethod[]{m}, aClass, strictSignatureSearch));
            }
            SearchScope accessScope = methods[0].getUseScope();
            for (int i = 1; i < methods.length; ++i) {
                PsiMethod method1 = methods[i];
                accessScope = accessScope.union(method1.getUseScope());
            }
            SearchScope restrictedByAccessScope = searchScope.intersectWith(accessScope);
            SimpleAccessorReferenceSearcher.addPropertyAccessUsages(method, restrictedByAccessScope, collector);
            return null;
        });
    }

    @NotNull
    protected MethodTextOccurrenceProcessor getTextOccurrenceProcessor(PsiMethod @NotNull [] methods, @NotNull PsiClass aClass, boolean strictSignatureSearch) {
        if (aClass == null) {
            MethodUsagesSearcher.$$$reportNull$$$0(2);
        }
        if (methods == null) {
            MethodUsagesSearcher.$$$reportNull$$$0(3);
        }
        return new MethodTextOccurrenceProcessor(aClass, strictSignatureSearch, methods);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/MethodUsagesSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextOccurrenceProcessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

