/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImpl
extends JavaStubPsiElement<PsiClassStub<?>>
implements PsiExtensibleClass,
Queryable {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);
    private volatile String myCachedName;

    public PsiClassImpl(PsiClassStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.CLASS);
    }

    protected PsiClassImpl(PsiClassStub stub, IStubElementType type2) {
        super(stub, type2);
        this.addTrace(null);
    }

    public PsiClassImpl(ASTNode node) {
        super(node);
        this.addTrace(null);
    }

    private void addTrace(@Nullable PsiClassStub stub) {
        if (ourTraceStubAstBinding) {
            String creationTrace = "Creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            if (stub != null) {
                String stubTrace;
                creationTrace = creationTrace + "\nfrom stub " + stub + "@" + System.identityHashCode(stub) + "\n";
                if (stub instanceof UserDataHolder && (stubTrace = (String)((UserDataHolder)stub).getUserData(CREATION_TRACE)) != null) {
                    creationTrace = creationTrace + stubTrace;
                }
            }
            this.putUserData(CREATION_TRACE, creationTrace);
        }
    }

    public void subtreeChanged() {
        this.dropCaches();
        super.subtreeChanged();
    }

    private void dropCaches() {
        this.myCachedName = null;
    }

    @Override
    protected Object clone() {
        PsiClassImpl clone = (PsiClassImpl)super.clone();
        clone.dropCaches();
        return clone;
    }

    public PsiElement getOriginalElement() {
        return (PsiElement)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(this.getProject());
            PsiClassImpl result = helper != null ? helper.getOriginalClass(this) : this;
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiClassImpl.$$$reportNull$$$0(0);
        }
        return compositeElement;
    }

    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    public PsiElement getScope() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        CompositeElement treeElement = this.getNode();
        for (ASTNode parent = treeElement.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!(parent.getElementType() instanceof IStubElementType)) continue;
            return parent.getPsi();
        }
        return this.getContainingFile();
    }

    public String getName() {
        PsiIdentifier identifier;
        String name2 = this.myCachedName;
        if (name2 != null) {
            return name2;
        }
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        name2 = stub == null ? ((identifier = this.getNameIdentifier()) == null ? null : identifier.getText()) : stub.getName();
        this.myCachedName = name2;
        return name2;
    }

    public String getQualifiedName() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PsiJavaFile) {
            return StringUtil.getQualifiedName((String)((PsiJavaFile)parent).getPackageName(), (String)StringUtil.notNullize((String)this.getName()));
        }
        if (parent instanceof PsiClass) {
            String parentQName = ((PsiClass)parent).getQualifiedName();
            if (parentQName == null) {
                return null;
            }
            return StringUtil.getQualifiedName((String)parentQName, (String)StringUtil.notNullize((String)this.getName()));
        }
        return null;
    }

    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        PsiModifierList modlist;
        if (name2 == null) {
            PsiClassImpl.$$$reportNull$$$0(1);
        }
        return (modlist = this.getModifierList()) != null && modlist.hasModifierProperty(name2);
    }

    public PsiReferenceList getExtendsList() {
        return (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.EXTENDS_LIST);
    }

    public PsiReferenceList getImplementsList() {
        return (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.IMPLEMENTS_LIST);
    }

    public PsiClassType @NotNull [] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(2);
        }
        return psiClassTypeArray;
    }

    public PsiClassType @NotNull [] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(3);
        }
        return psiClassTypeArray;
    }

    @Nullable
    public PsiReferenceList getPermitsList() {
        return (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.PERMITS_LIST);
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    public PsiClass @NotNull [] getInterfaces() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getInterfaces(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    public PsiClass @NotNull [] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    public PsiClassType @NotNull [] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(6);
        }
        return psiClassTypeArray;
    }

    @Nullable
    public PsiClass getContainingClass() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            StubElement parent = stub.getParentStub();
            return parent instanceof PsiClassStub ? (PsiClass)((PsiClassStub)parent).getPsi() : null;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClassLevelDeclarationStatement) {
            return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
        }
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    public PsiElement getContext() {
        return this.getContext(null);
    }

    public PsiElement getContext(@Nullable String referenceName) {
        StubElement parent;
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub == null) {
            return this.getParent();
        }
        if (referenceName == null) {
            return super.getContext();
        }
        for (parent = stub.getParentStub(); parent != null && !(parent instanceof PsiClassStub) && !(parent instanceof PsiFileStub); parent = parent.getParentStub()) {
            Object[] allLocalClasses = (PsiClass[])parent.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (allLocalClasses.length > 0 && ContainerUtil.exists((Object[])allLocalClasses, c -> referenceName.equals(c.getName()))) {
                return this.getParent();
            }
            if (!(parent instanceof PsiMethodStub)) continue;
            return parent.getPsi();
        }
        return parent != null ? parent.getPsi() : this.getParent();
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            PsiClassImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public PsiField @NotNull [] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            PsiClassImpl.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    public PsiMethod @NotNull [] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    public PsiMethod @NotNull [] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    public PsiClass @NotNull [] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    public PsiRecordComponent @NotNull [] getRecordComponents() {
        PsiRecordComponent[] psiRecordComponentArray = this.myInnersCache.getRecordComponents();
        if (psiRecordComponentArray == null) {
            PsiClassImpl.$$$reportNull$$$0(12);
        }
        return psiRecordComponentArray;
    }

    @Nullable
    public PsiRecordHeader getRecordHeader() {
        return (PsiRecordHeader)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.RECORD_HEADER);
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list = Arrays.asList((PsiField[])this.getStubOrPsiChildren(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list = Arrays.asList((PsiMethod[])this.getStubOrPsiChildren(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiClass> list = Arrays.asList((PsiClass[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY));
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    public PsiClassInitializer @NotNull [] getInitializers() {
        PsiClassInitializer[] psiClassInitializerArray = (PsiClassInitializer[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.CLASS_INITIALIZER, PsiClassInitializer.ARRAY_FACTORY);
        if (psiClassInitializerArray == null) {
            PsiClassImpl.$$$reportNull$$$0(16);
        }
        return psiClassInitializerArray;
    }

    public PsiTypeParameter @NotNull [] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            PsiClassImpl.$$$reportNull$$$0(17);
        }
        return psiTypeParameterArray;
    }

    public PsiField @NotNull [] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            PsiClassImpl.$$$reportNull$$$0(18);
        }
        return psiFieldArray;
    }

    public PsiMethod @NotNull [] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(19);
        }
        return psiMethodArray;
    }

    public PsiClass @NotNull [] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(20);
        }
        return psiClassArray;
    }

    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(21);
        }
        return psiMethodArray;
    }

    public PsiMethod @NotNull [] findMethodsByName(String name2, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name2, checkBases);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(22);
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name2, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name2, checkBases);
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
        if (list == null) {
            PsiClassImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    public PsiDocComment getDocComment() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(18);
    }

    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(19);
    }

    public boolean isInterface() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInterface();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.INTERFACE_KEYWORD;
    }

    public boolean isAnnotationType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnnotationType();
        }
        return this.getNode().findChildByRole(247) != null;
    }

    public boolean isEnum() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isEnum();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.ENUM_KEYWORD;
    }

    public boolean isRecord() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isRecord();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.RECORD_KEYWORD;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiClassImpl.$$$reportNull$$$0(25);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitClass((PsiClass)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiClass:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiClassImpl.$$$reportNull$$$0(26);
        }
        if (state == null) {
            PsiClassImpl.$$$reportNull$$$0(27);
        }
        if (place == null) {
            PsiClassImpl.$$$reportNull$$$0(28);
        }
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)place);
        return PsiClassImplUtil.processDeclarationsInClass(this, processor2, state, null, lastParent, place, level, false);
    }

    public PsiElement setName(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            PsiClassImpl.$$$reportNull$$$0(29);
        }
        String oldName = this.getName();
        boolean isRenameFile = this.isRenameFileOnRenaming();
        PsiImplUtil.setName((PsiElement)Objects.requireNonNull(this.getNameIdentifier()), newName);
        if (isRenameFile) {
            PsiFile file;
            String fileName = (file = (PsiFile)this.getParent()).getName();
            int dotIndex = fileName.lastIndexOf(46);
            file.setName(dotIndex >= 0 ? newName + "." + fileName.substring(dotIndex + 1) : newName);
        }
        for (PsiMethod method : this.getMethods()) {
            if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
            method.setName(newName);
        }
        return this;
    }

    private boolean isRenameFileOnRenaming() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            PsiFile file = (PsiFile)parent;
            String fileName = file.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String name2 = dotIndex >= 0 ? fileName.substring(0, dotIndex) : fileName;
            String oldName = this.getName();
            return name2.equals(oldName);
        }
        return false;
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            PsiClassImpl.$$$reportNull$$$0(30);
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            PsiClassImpl.$$$reportNull$$$0(31);
        }
        return searchScope;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            PsiClassImpl.$$$reportNull$$$0(32);
        }
        PsiClassImpl.putInfo(this, info);
    }

    public static void putInfo(@NotNull PsiClass psiClass, @NotNull Map<String, String> info) {
        if (psiClass == null) {
            PsiClassImpl.$$$reportNull$$$0(33);
        }
        if (info == null) {
            PsiClassImpl.$$$reportNull$$$0(34);
        }
        info.put("className", psiClass.getName());
        info.put("qualifiedClassName", psiClass.getQualifiedName());
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof Queryable) {
            ((Queryable)file).putInfo(info);
        }
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return this.myInnersCache.getValuesMethod();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiClassImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiClassImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleSignatures";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethods";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodsAndTheirSubstitutors";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

