/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCodeFragmentImpl
extends PsiFileImpl
implements JavaCodeFragment,
IntentionFilterOwner {
    private final PsiElement myContext;
    private boolean myPhysical;
    private PsiType myThisType;
    private PsiType mySuperType;
    private LinkedHashMap<String, String> myPseudoImports = new LinkedHashMap();
    private JavaCodeFragment.VisibilityChecker myVisibilityChecker;
    private JavaCodeFragment.ExceptionHandler myExceptionHandler;
    private GlobalSearchScope myResolveScope;
    private IntentionFilterOwner.IntentionActionsFilter myIntentionActionsFilter;
    private FileViewProvider myViewProvider;

    public PsiCodeFragmentImpl(Project project, IElementType contentElementType, boolean isPhysical, @NonNls String name2, CharSequence text2, @Nullable PsiElement context) {
        super(TokenType.CODE_FRAGMENT, contentElementType, PsiManagerEx.getInstanceEx((Project)project).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile(name2, FileTypeManager.getInstance().getFileTypeByFileName(name2), text2), isPhysical));
        this.myContext = context;
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi((PsiFile)this);
        this.myPhysical = isPhysical;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getContentElementType().getLanguage();
        if (language == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(0);
        }
        return language;
    }

    protected PsiCodeFragmentImpl clone() {
        PsiCodeFragmentImpl clone = (PsiCodeFragmentImpl)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myPhysical = false;
        clone.myOriginalFile = this;
        clone.myPseudoImports = new LinkedHashMap<String, String>(this.myPseudoImports);
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi((PsiFile)clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                PsiCodeFragmentImpl.$$$reportNull$$$0(1);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(2);
        }
        return fileViewProvider;
    }

    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(3);
        }
        return javaFileType;
    }

    public PsiElement getContext() {
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    public PsiType getThisType() {
        return this.myThisType;
    }

    public void setThisType(PsiType psiType) {
        this.myThisType = psiType;
    }

    public PsiType getSuperType() {
        return this.mySuperType;
    }

    public void setSuperType(PsiType superType) {
        this.mySuperType = superType;
    }

    public String importsToString() {
        return StringUtil.join(this.myPseudoImports.values(), (String)",");
    }

    public void addImportsFromString(String imports2) {
        StringTokenizer tokenizer = new StringTokenizer(imports2, ",");
        while (tokenizer.hasMoreTokens()) {
            String qName = tokenizer.nextToken();
            String name2 = PsiNameHelper.getShortClassName((String)qName);
            this.myPseudoImports.put(name2, qName);
        }
    }

    public void setVisibilityChecker(JavaCodeFragment.VisibilityChecker checker) {
        this.myVisibilityChecker = checker;
    }

    public JavaCodeFragment.VisibilityChecker getVisibilityChecker() {
        return this.myVisibilityChecker;
    }

    public boolean isPhysical() {
        return this.myPhysical;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitCodeFragment((JavaCodeFragment)this);
        } else {
            visitor2.visitFile((PsiFile)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        IElementType i;
        ElementClassHint classHint2;
        if (processor2 == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(7);
        }
        if ((classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY)) == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            String name2;
            NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
            String string = name2 = nameHint != null ? nameHint.getName(state) : null;
            if (name2 != null) {
                PsiClass imported;
                String qNameImported = this.myPseudoImports.get(name2);
                if (qNameImported != null && (imported = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qNameImported, this.getResolveScope())) != null && !processor2.execute((PsiElement)imported, state)) {
                    return false;
                }
            } else {
                for (String qNameImported : this.myPseudoImports.values()) {
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qNameImported, this.getResolveScope());
                    if (aClass == null || processor2.execute((PsiElement)aClass, state)) continue;
                    return false;
                }
            }
            if (this.myContext == null) {
                return JavaResolveUtil.processImplicitlyImportedPackages(processor2, state, place, this.getManager());
            }
        }
        if ((i = this.myContentElementType) == JavaElementType.TYPE_WITH_CONJUNCTIONS_TEXT || i == JavaElementType.TYPE_WITH_DISJUNCTIONS_TEXT || i == JavaElementType.EXPRESSION_STATEMENT || i == JavaElementType.REFERENCE_TEXT) {
            return true;
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor2, state, lastParent, place);
    }

    public String toString() {
        return "PsiCodeFragment:" + this.getName();
    }

    public boolean importClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(8);
        }
        String className2 = aClass.getName();
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        this.myPseudoImports.put(className2, qName);
        this.myManager.beforeChange(false);
        if (this.isPhysical()) {
            Project project = this.myManager.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)this);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new ImportClassUndoableAction(className2, qName, document, this.myPseudoImports));
        }
        return true;
    }

    public JavaCodeFragment.ExceptionHandler getExceptionHandler() {
        return this.myExceptionHandler;
    }

    public void setIntentionActionsFilter(@NotNull IntentionFilterOwner.IntentionActionsFilter filter) {
        if (filter == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(9);
        }
        this.myIntentionActionsFilter = filter;
    }

    public IntentionFilterOwner.IntentionActionsFilter getIntentionActionsFilter() {
        return this.myIntentionActionsFilter;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        if (this.myResolveScope != null) {
            GlobalSearchScope globalSearchScope = this.myResolveScope;
            if (globalSearchScope == null) {
                PsiCodeFragmentImpl.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.getResolveScope();
        if (globalSearchScope == null) {
            PsiCodeFragmentImpl.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    public void setExceptionHandler(JavaCodeFragment.ExceptionHandler exceptionHandler) {
        this.myExceptionHandler = exceptionHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiCodeFragmentImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiCodeFragmentImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIntentionActionsFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImportClassUndoableAction
    extends BasicUndoableAction {
        private final String myClassName;
        private final String myQName;
        private final LinkedHashMap<String, String> myPseudoImports;

        ImportClassUndoableAction(String className2, String qName, Document document, LinkedHashMap<String, String> pseudoImportsMap) {
            super(new Document[]{document});
            this.myClassName = className2;
            this.myQName = qName;
            this.myPseudoImports = pseudoImportsMap;
        }

        public void undo() {
            this.myPseudoImports.remove(this.myClassName);
        }

        public void redo() {
            this.myPseudoImports.put(this.myClassName, this.myQName);
        }
    }
}

