/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.ClassReferencePointer;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    PsiTypeElementImpl(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(type2);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeInfo().myType;
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    private TypeInfo getTypeInfo() {
        return (TypeInfo)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this, __ -> this.calculateTypeInfo());
    }

    @NotNull
    private TypeInfo calculateTypeInfo() {
        PsiType inferredType = PsiAugmentProvider.getInferredType((PsiTypeElement)this);
        if (inferredType != null) {
            return new TypeInfo(inferredType, true);
        }
        Object type2 = null;
        boolean inferred = false;
        SmartList annotations = new SmartList();
        PsiElement parent = this.getParent();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type2 == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type2 = new PsiDiamondTypeImpl((PsiManager)this.getManager(), this);
                    break;
                }
                type2 = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken((PsiElement)child, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type2 == null) : this;
                String text2 = child.getText();
                type2 = annotations.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text2) : new PsiPrimitiveType(text2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.VAR_KEYWORD)) {
                assert (type2 == null) : this;
                type2 = this.inferVarType(parent);
                inferred = true;
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type2 == null) : this;
                type2 = new PsiClassReferenceType(PsiTypeElementImpl.getReferenceComputable((PsiJavaCodeReferenceElement)child), null, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                assert (type2 != null) : this;
                type2 = new PsiArrayType(type2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.ELLIPSIS)) {
                assert (type2 != null) : this;
                type2 = new PsiEllipsisType(type2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.QUEST) || child instanceof ASTNode && ((ASTNode)child).getElementType() == JavaElementType.DUMMY_ELEMENT && "any".equals(child.getText())) {
                assert (type2 == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
                PsiElement boundType = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)boundKind);
                type2 = PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded((PsiManager)this.getManager()));
                type2 = type2.annotate(PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations));
                break;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type2 = PsiIntersectionType.createIntersection((boolean)false, (PsiType[])types.toArray(PsiType.createArray((int)types.size())));
                break;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type2 = PsiDisjunctionType.createDisjunction(types, (PsiManager)this.getManager());
            break;
        }
        if (type2 == null) {
            return new TypeInfo((PsiType)PsiType.NULL, inferred);
        }
        if (parent instanceof PsiModifierListOwner) {
            type2 = JavaSharedImplUtil.applyAnnotations(type2, ((PsiModifierListOwner)parent).getModifierList());
        }
        return new TypeInfo((PsiType)type2, inferred);
    }

    private PsiType inferVarType(PsiElement parent) {
        if (parent instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)parent).getDeclarationScope();
            if (declarationScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue2 = ((PsiForeachStatement)declarationScope).getIteratedValue();
                if (iteratedValue2 != null) {
                    return JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2);
                }
                return null;
            }
            if (declarationScope instanceof PsiLambdaExpression) {
                return ((PsiParameter)parent).getType();
            }
        } else {
            for (PsiTypeElementImpl e = this; e != null; e = e.getNextSibling()) {
                if (!(e instanceof PsiExpression)) continue;
                if (!(e instanceof PsiArrayInitializerExpression)) {
                    PsiExpression expression2 = (PsiExpression)e;
                    PsiType type2 = (PsiType)RecursionManager.doPreventingRecursion((Object)expression2, (boolean)true, () -> expression2.getType());
                    return type2 == null ? null : JavaVarTypeUtil.getUpwardProjection(type2);
                }
                return null;
            }
        }
        return null;
    }

    public boolean isInferredType() {
        return PsiUtil.isJavaToken((PsiElement)this.getFirstChild(), (IElementType)JavaTokenType.VAR_KEYWORD) || this.getTypeInfo().myInferred;
    }

    @NotNull
    private static ClassReferencePointer getReferenceComputable(@NotNull PsiJavaCodeReferenceElement ref) {
        block6: {
            int index;
            PsiElement parent;
            PsiTypeElement rootType;
            block7: {
                if (ref == null) {
                    PsiTypeElementImpl.$$$reportNull$$$0(3);
                }
                if ((rootType = PsiTypeElementImpl.getRootTypeElement(ref)) == null) break block6;
                parent = rootType.getParent();
                if (parent instanceof PsiMethod) break block7;
                if (!(parent instanceof PsiVariable)) break block6;
            }
            if ((index = PsiTypeElementImpl.allReferencesInside(rootType).indexOf(ref::equals)) < 0) {
                throw new AssertionError(rootType.getClass());
            }
            return PsiTypeElementImpl.computeFromTypeOwner(parent, index, new WeakReference<PsiJavaCodeReferenceElement>(ref));
        }
        ClassReferencePointer classReferencePointer = ClassReferencePointer.constant(ref);
        if (classReferencePointer == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(4);
        }
        return classReferencePointer;
    }

    @Nullable
    private static PsiTypeElement getRootTypeElement(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(5);
        }
        PsiElement root = (PsiElement)SyntaxTraverser.psiApi().parents((Object)ref.getParent()).takeWhile(it -> it instanceof PsiTypeElement || it instanceof PsiReferenceParameterList || it instanceof PsiJavaCodeReferenceElement).last();
        return (PsiTypeElement)ObjectUtils.tryCast((Object)root, PsiTypeElement.class);
    }

    @NotNull
    private static JBIterable<PsiJavaCodeReferenceElement> allReferencesInside(@NotNull PsiTypeElement rootType) {
        if (rootType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(6);
        }
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)rootType).filter(PsiJavaCodeReferenceElement.class);
        if (jBIterable == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    private static ClassReferencePointer computeFromTypeOwner(final PsiElement parent, final int index, final @NotNull WeakReference<PsiJavaCodeReferenceElement> ref) {
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(8);
        }
        return new ClassReferencePointer(){
            volatile WeakReference<PsiJavaCodeReferenceElement> myCache;
            {
                this.myCache = ref;
            }

            @Override
            @Nullable
            public PsiJavaCodeReferenceElement retrieveReference() {
                PsiJavaCodeReferenceElement result = (PsiJavaCodeReferenceElement)this.myCache.get();
                if (result == null) {
                    PsiType type2 = this.calcTypeByParent();
                    if (type2 instanceof PsiClassReferenceType) {
                        result = this.findReferenceByIndex((PsiClassReferenceType)type2);
                    }
                    this.myCache = new WeakReference<PsiJavaCodeReferenceElement>(result);
                }
                return result;
            }

            @Nullable
            private PsiJavaCodeReferenceElement findReferenceByIndex(PsiClassReferenceType type2) {
                PsiTypeElement root = PsiTypeElementImpl.getRootTypeElement(type2.getReference());
                return root == null ? null : (PsiJavaCodeReferenceElement)PsiTypeElementImpl.allReferencesInside(root).get(index);
            }

            @Nullable
            private PsiType calcTypeByParent() {
                PsiType type2;
                PsiType psiType = type2 = parent instanceof PsiMethod ? ((PsiMethod)parent).getReturnType() : ((PsiVariable)parent).getType();
                if (type2 instanceof PsiArrayType) {
                    return type2.getDeepComponentType();
                }
                return type2;
            }

            @Override
            @NotNull
            public PsiJavaCodeReferenceElement retrieveNonNullReference() {
                PsiJavaCodeReferenceElement result = this.retrieveReference();
                if (result == null) {
                    PsiType type2 = this.calcTypeByParent();
                    if (!(type2 instanceof PsiClassReferenceType)) {
                        PsiUtilCore.ensureValid((PsiElement)parent);
                        throw new IllegalStateException("No reference type for " + parent.getClass() + "; type: " + (type2 != null ? type2.getClass() : "null"));
                    }
                    result = this.findReferenceByIndex((PsiClassReferenceType)type2);
                    if (result == null) {
                        PsiUtilCore.ensureValid((PsiElement)parent);
                        throw new RuntimeExceptionWithAttachments("Can't retrieve reference by index " + index + " for " + parent.getClass() + "; type: " + type2.getClass(), new Attachment[]{new Attachment("memberType.txt", type2.getCanonicalText())});
                    }
                }
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = result;
                if (psiJavaCodeReferenceElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiJavaCodeReferenceElement;
            }

            public String toString() {
                String msg = "Type element reference of " + parent.getClass() + " #" + parent.getClass().getSimpleName() + ", index=" + index;
                return parent.isValid() ? msg + " #" + parent.getLanguage() : msg + ", invalid";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl$1", "retrieveNonNullReference"));
            }
        };
    }

    @NotNull
    private static TypeAnnotationProvider createProvider(@NotNull List<PsiAnnotation> annotations) {
        if (annotations == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(9);
        }
        TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.Static.create((PsiAnnotation[])((PsiAnnotation[])ContainerUtil.copyAndClear(annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true)));
        if (typeAnnotationProvider == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(10);
        }
        return typeAnnotationProvider;
    }

    @NotNull
    private List<PsiType> collectTypes() {
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiTypeElement.class);
        List list = ContainerUtil.map((Collection)typeElements, typeElement -> typeElement.getType());
        if (list == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi((ASTNode)ref);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(13);
        }
        if (place == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(14);
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = annotations != null ? annotations : PsiAnnotation.EMPTY_ARRAY;
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(15);
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(16);
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(17);
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        PsiModifierList modifierList;
        PsiIdentifier identifier;
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(18);
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)this.getProject()).createAnnotationFromText('@' + qualifiedName, (PsiElement)this);
        PsiElement firstChild = this.getFirstChild();
        for (PsiElement child = this.getLastChild(); child != firstChild; child = child.getPrevSibling()) {
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET) && !PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.ELLIPSIS)) continue;
            PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore((PsiElement)annotation, child);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(19);
            }
            return psiAnnotation;
        }
        if (firstChild instanceof PsiJavaCodeReferenceElement && (identifier = (PsiIdentifier)PsiTreeUtil.getChildOfType((PsiElement)firstChild, PsiIdentifier.class)) != null && identifier != firstChild.getFirstChild()) {
            PsiAnnotation psiAnnotation = (PsiAnnotation)firstChild.addBefore((PsiElement)annotation, (PsiElement)identifier);
            if (psiAnnotation == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(20);
            }
            return psiAnnotation;
        }
        PsiElement parent = this.getParent();
        while (parent instanceof PsiTypeElement && ((PsiTypeElement)parent).getType() instanceof PsiArrayType) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiModifierListOwner && (modifierList = ((PsiModifierListOwner)parent).getModifierList()) != null) {
            PsiTypeParameterList list;
            PsiTypeParameterList psiTypeParameterList = list = parent instanceof PsiTypeParameterListOwner ? ((PsiTypeParameterListOwner)parent).getTypeParameterList() : null;
            if (list == null || list.textMatches((CharSequence)"")) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)modifierList.add((PsiElement)annotation);
                if (psiAnnotation == null) {
                    PsiTypeElementImpl.$$$reportNull$$$0(21);
                }
                return psiAnnotation;
            }
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addBefore((PsiElement)annotation, firstChild);
        if (psiAnnotation == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(22);
        }
        return psiAnnotation;
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiElement result;
        if (newElement == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(23);
        }
        if (!(newElement instanceof PsiTypeElement) || !((PsiTypeElement)newElement).isInferredType()) {
            PsiImplUtil.markTypeAnnotations(this);
        }
        if ((result = super.replace(newElement)) instanceof PsiTypeElement) {
            PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result);
        }
        return result;
    }

    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceComputable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "allReferencesInside";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceComputable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypeElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allReferencesInside";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeFromTypeOwner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeInfo {
        private final PsiType myType;
        private final boolean myInferred;

        private TypeInfo(PsiType type2, boolean inferred) {
            this.myType = type2;
            this.myInferred = inferred;
        }
    }
}

