/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CheckedExceptionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;

    public CheckedExceptionCompatibilityConstraint(PsiExpression expression2, PsiType t) {
        super(t);
        this.myExpression = expression2;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        block18: {
            PsiExpression body2;
            PsiType type3;
            if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)this.myExpression)) {
                return true;
            }
            PsiType myT = this.getCurrentType();
            if (this.myExpression instanceof PsiParenthesizedExpression) {
                constraints.add(new CheckedExceptionCompatibilityConstraint(((PsiParenthesizedExpression)this.myExpression).getExpression(), myT));
                return true;
            }
            if (this.myExpression instanceof PsiConditionalExpression) {
                PsiExpression elseExpression2;
                PsiExpression thenExpression2 = ((PsiConditionalExpression)this.myExpression).getThenExpression();
                if (thenExpression2 != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(thenExpression2, myT));
                }
                if ((elseExpression2 = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(elseExpression2, myT));
                }
                return true;
            }
            if (!(this.myExpression instanceof PsiLambdaExpression) && !(this.myExpression instanceof PsiMethodReferenceExpression)) break block18;
            if (!LambdaUtil.isFunctionalType((PsiType)myT)) {
                session.registerIncompatibleErrorMessage(session.getPresentableText(myT) + " is not a functional interface");
                return false;
            }
            PsiType groundTargetType = this.myExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT, (PsiLambdaExpression)this.myExpression, false) : FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)groundTargetType);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage("No valid function type can be found for " + session.getPresentableText(myT));
                return false;
            }
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)groundTargetType));
            if (this.myExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)this.myExpression).hasFormalParameterTypes() || this.myExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)this.myExpression).isExact()) {
                for (PsiParameter parameter2 : interfaceMethod.getParameterList().getParameters()) {
                    PsiType type4 = substitutor.substitute(parameter2.getType());
                    if (session.isProperType(type4)) continue;
                    session.registerIncompatibleErrorMessage("Parameter type is not yet inferred: " + session.getPresentableText(type4));
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (!(!(this.myExpression instanceof PsiLambdaExpression) && ((PsiMethodReferenceExpression)this.myExpression).isExact() || session.isProperType(type3 = substitutor.substitute(returnType)))) {
                session.registerIncompatibleErrorMessage("Return type is not yet inferred: " + session.getPresentableText(type3));
                return false;
            }
            List expectedThrownTypes = ContainerUtil.map((Object[])interfaceMethod.getThrowsList().getReferencedTypes(), type2 -> session.substituteWithInferenceVariables(substitutor.substitute(type2)));
            ArrayList<PsiType> expectedNonProperThrownTypes = new ArrayList<PsiType>();
            for (PsiType type4 : expectedThrownTypes) {
                if (session.isProperType(type4)) continue;
                expectedNonProperThrownTypes.add(type4);
            }
            ArrayList thrownTypes = new ArrayList();
            Object object = body2 = this.myExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)this.myExpression).getBody() : this.myExpression;
            if (body2 != null) {
                List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{body2});
                thrownTypes.addAll(ContainerUtil.filter((Collection)exceptions, type2 -> !ExceptionUtil.isUncheckedException(type2)));
            }
            if (expectedNonProperThrownTypes.isEmpty()) {
                for (PsiType thrownType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedThrownTypes, thrownType)) continue;
                    session.registerIncompatibleErrorMessage("Unhandled exception: " + session.getPresentableText(thrownType));
                    return false;
                }
            } else {
                ArrayList<PsiType> expectedProperTypes = new ArrayList<PsiType>(expectedThrownTypes);
                expectedProperTypes.removeAll(expectedNonProperThrownTypes);
                for (PsiType thrownType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedProperTypes, thrownType)) continue;
                    for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                        constraints.add(new StrictSubtypingConstraint(expectedNonProperThrownType, thrownType));
                    }
                }
                for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                    InferenceVariable variable = session.getInferenceVariable(expectedNonProperThrownType);
                    if (variable == null) continue;
                    variable.setThrownBound();
                }
            }
        }
        return true;
    }

    private static boolean isAddressed(List<PsiType> expectedThrownTypes, PsiType thrownType) {
        for (PsiType expectedThrownType : expectedThrownTypes) {
            if (!TypeConversionUtil.isAssignable((PsiType)expectedThrownType, (PsiType)thrownType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression2) {
        return new CheckedExceptionCompatibilityConstraint(expression2, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<? super InferenceVariable> result) {
        session.collectDependencies(returnType, result);
    }
}

