/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.impl.source.tree.injected.ConcatenationInjectorManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MyTestInjector {
    private final PsiManager myPsiManager;

    public MyTestInjector(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            MyTestInjector.$$$reportNull$$$0(0);
        }
        this.myPsiManager = psiManager;
    }

    public void injectAll(@NotNull Disposable parent) {
        if (parent == null) {
            MyTestInjector.$$$reportNull$$$0(1);
        }
        MyTestInjector.injectVariousStuffEverywhere(parent, this.myPsiManager);
        Project project = this.myPsiManager.getProject();
        Language ql = Language.findLanguageByID((String)"JPAQL");
        Language js = Language.findLanguageByID((String)"JavaScript");
        MyTestInjector.registerForStringVarInitializer(parent, project, ql, "ql", null, null);
        MyTestInjector.registerForStringVarInitializer(parent, project, ql, "qlPrefixed", "xxx", null);
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "js", null, null);
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "jsSeparated", " + ", " + 'separator'");
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "jsBrokenPrefix", "xx ", "");
        MyTestInjector.registerForStringVarInitializer(parent, project, Language.findLanguageByID((String)"Oracle"), "oracle", null, null);
        MyTestInjector.registerForParameterValue(parent, project, Language.findLanguageByID((String)"Groovy"), "groovy");
        MyTestInjector.registerForStringVarInitializer(parent, project, (Language)JavaLanguage.INSTANCE, "java", "", "");
    }

    private static void registerForParameterValue(Disposable parent, Project project, Language language, String paramName) {
        if (language == null) {
            return;
        }
        ConcatenationAwareInjector injector = (injectionPlacesRegistrar, operands2) -> {
            PsiElement operand2 = operands2[0];
            if (!(operand2 instanceof PsiLiteralExpression)) {
                return;
            }
            if (!(operand2.getParent() instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList expressionList = (PsiExpressionList)operand2.getParent();
            int i = ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)operand2);
            if (!(operand2.getParent().getParent() instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2.getParent().getParent();
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (i >= parameters2.length) {
                return;
            }
            PsiParameter parameter2 = parameters2[i];
            if (!paramName.equals(parameter2.getName())) {
                return;
            }
            TextRange textRange = MyTestInjector.textRangeToInject((PsiLanguageInjectionHost)operand2);
            injectionPlacesRegistrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)operand2, textRange).doneInjecting();
        };
        ConcatenationInjectorManager.EP_NAME.getPoint((AreaInstance)project).registerExtension((Object)injector, parent);
    }

    private static void registerForStringVarInitializer(@NotNull Disposable parent, @NotNull Project project, Language language, @NotNull @NonNls String varName, @NonNls String prefix, @NonNls String suffix) {
        if (parent == null) {
            MyTestInjector.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MyTestInjector.$$$reportNull$$$0(3);
        }
        if (varName == null) {
            MyTestInjector.$$$reportNull$$$0(4);
        }
        if (language == null) {
            return;
        }
        ConcatenationAwareInjector injector = (injectionPlacesRegistrar, operands2) -> {
            PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)operands2[0], PsiVariable.class);
            if (variable == null) {
                return;
            }
            if (!varName.equals(variable.getName())) {
                return;
            }
            if (!(operands2[0] instanceof PsiLiteralExpression)) {
                return;
            }
            boolean started = false;
            String prefixFromPrev = "";
            for (int i = 0; i < operands2.length; ++i) {
                PsiElement operand2 = operands2[i];
                if (!(operand2 instanceof PsiLiteralExpression)) continue;
                Object value2 = ((PsiLiteralExpression)operand2).getValue();
                if (!(value2 instanceof String)) {
                    prefixFromPrev = prefixFromPrev + value2;
                    continue;
                }
                TextRange textRange = MyTestInjector.textRangeToInject((PsiLanguageInjectionHost)operand2);
                if (!started) {
                    injectionPlacesRegistrar.startInjecting(language);
                    started = true;
                }
                injectionPlacesRegistrar.addPlace(prefixFromPrev + (i == 0 ? "" : (prefix == null ? "" : prefix)), i == operands2.length - 1 ? null : suffix, (PsiLanguageInjectionHost)operand2, textRange);
                prefixFromPrev = "";
            }
            if (started) {
                injectionPlacesRegistrar.doneInjecting();
            }
        };
        ConcatenationInjectorManager.EP_NAME.getPoint((AreaInstance)project).registerExtension((Object)injector, parent);
    }

    private static void injectVariousStuffEverywhere(@NotNull Disposable parent, PsiManager psiManager) {
        if (parent == null) {
            MyTestInjector.$$$reportNull$$$0(5);
        }
        Language ql = Language.findLanguageByID((String)"JPAQL");
        final Language js = Language.findLanguageByID((String)"JavaScript 1.8");
        Language html = Language.findLanguageByID((String)"HTML");
        if (ql == null || js == null) {
            return;
        }
        Language ecma4 = Language.findLanguageByID((String)"ECMA Script Level 4");
        InjectedLanguageManager.getInstance((Project)psiManager.getProject()).registerMultiHostInjector(new MultiHostInjector(){

            public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
                String attrName;
                XmlAttributeValue value2;
                PsiElement parent1;
                if (registrar == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent1 = (value2 = (XmlAttributeValue)context).getParent()) instanceof XmlAttribute && "jsInBraces".equals(attrName = ((XmlAttribute)parent1).getLocalName())) {
                    registrar.startInjecting(js);
                    String text2 = value2.getText();
                    int index = 0;
                    while (text2.indexOf(123, index) != -1) {
                        int lbrace = text2.indexOf(123, index);
                        int rbrace = text2.indexOf(125, index);
                        registrar.addPlace("", "", (PsiLanguageInjectionHost)value2, new TextRange(lbrace + 1, rbrace));
                        index = rbrace + 1;
                    }
                    registrar.doneInjecting();
                }
            }

            @NotNull
            public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
                List<Class<XmlAttributeValue>> list = Collections.singletonList(XmlAttributeValue.class);
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "registrar";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "elementsToInjectIn";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getLanguagesToInject";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, parent);
        LanguageInjector myInjector = (host, placesToInject) -> {
            String text2;
            String text3;
            XmlAttributeValue value2;
            PsiElement parent1;
            if (host instanceof XmlAttributeValue && (parent1 = (value2 = (XmlAttributeValue)host).getParent()) instanceof XmlAttribute) {
                String attrName = ((XmlAttribute)parent1).getLocalName();
                if ("ql".equals(attrName)) {
                    MyTestInjector.inject(host, placesToInject, ql);
                    return;
                }
                if ("js".equals(attrName)) {
                    MyTestInjector.inject(host, placesToInject, js);
                    return;
                }
                if ("jsprefix".equals(attrName)) {
                    MyTestInjector.inject(host, placesToInject, js, "function foo(doc, window){", "}");
                    return;
                }
            }
            if (host instanceof XmlText) {
                int end;
                int start;
                XmlText xmlText = (XmlText)host;
                XmlTag tag = xmlText.getParentTag();
                if (tag == null) {
                    return;
                }
                if ("ql".equals(tag.getLocalName())) {
                    MyTestInjector.inject(host, placesToInject, ql);
                    return;
                }
                if ("js".equals(tag.getLocalName())) {
                    MyTestInjector.inject(host, placesToInject, js);
                    return;
                }
                if ("htmlInject".equals(tag.getLocalName())) {
                    MyTestInjector.inject(host, placesToInject, html);
                    return;
                }
                if (ecma4 != null && "ecma4".equals(tag.getLocalName())) {
                    MyTestInjector.inject(host, placesToInject, ecma4);
                    return;
                }
                if ("jsprefix".equals(tag.getLocalName())) {
                    MyTestInjector.inject(host, placesToInject, js, "function foo(doc, window){", "}");
                    return;
                }
                if ("jsInHash".equals(tag.getLocalName()) && (text3 = xmlText.getText()).contains("#") && (start = text3.indexOf(35)) != (end = text3.lastIndexOf(35)) && start != -1) {
                    placesToInject.addPlace(js, new TextRange(start + 1, end), null, null);
                    return;
                }
            }
            if (host instanceof PsiComment && ((PsiComment)host).getTokenType() == JavaTokenType.C_STYLE_COMMENT) {
                text2 = host.getText();
                String prefix = "/*\n * {{{\n";
                String suffix = " }}}\n */";
                if (text2.startsWith(prefix) && text2.endsWith(suffix)) {
                    String s = StringUtil.trimEnd((String)StringUtil.trimStart((String)text2, (String)prefix), (String)suffix);
                    int off = 0;
                    while (!s.isEmpty()) {
                        String t = s.trim();
                        if (t.startsWith("*")) {
                            t = t.substring(1).trim();
                        }
                        int i = s.length() - t.length();
                        off += i;
                        int endOfLine = t.indexOf(10);
                        if (endOfLine == -1) {
                            endOfLine = t.length();
                        }
                        placesToInject.addPlace(js, TextRange.from((int)(prefix.length() + off), (int)endOfLine), "", "\n");
                        off += endOfLine;
                        s = s.substring(i + endOfLine);
                    }
                    return;
                }
            }
            if (host instanceof PsiCommentImpl) {
                text2 = host.getText();
                if (text2.startsWith("/*--{") && text2.endsWith("}--*/")) {
                    TextRange textRange = new TextRange(4, text2.length() - 4);
                    if (!(host.getParent() instanceof PsiMethod)) {
                        return;
                    }
                    PsiMethod method = (PsiMethod)host.getParent();
                    if (!method.hasModifierProperty("native") || !method.hasModifierProperty("public")) {
                        return;
                    }
                    String paramList = "";
                    for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
                        if (!paramList.isEmpty()) {
                            paramList = paramList + ",";
                        }
                        paramList = paramList + parameter2.getName();
                    }
                    String header = "function " + method.getName() + "(" + paramList + ") {";
                    Language gwt = Language.findLanguageByID((String)"GWT JavaScript");
                    placesToInject.addPlace(gwt, textRange, header, "}");
                    return;
                }
                parent1 = host.getParent();
                if (parent1 instanceof PsiMethod && ((PsiMethod)parent1).getName().equals("xml")) {
                    placesToInject.addPlace((Language)XMLLanguage.INSTANCE, new TextRange(2, host.getTextLength() - 2), null, null);
                    return;
                }
            }
            if (host instanceof PsiLiteralExpression && ((PsiLiteralExpression)host).getValue() instanceof String) {
                PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)host, PsiVariable.class);
                if (variable == null) {
                    return;
                }
                if (host.getParent() instanceof PsiPolyadicExpression) {
                    return;
                }
                if ("ql".equals(variable.getName())) {
                    placesToInject.addPlace(ql, MyTestInjector.textRangeToInject(host), null, null);
                }
                if ("xml".equals(variable.getName())) {
                    placesToInject.addPlace((Language)XMLLanguage.INSTANCE, MyTestInjector.textRangeToInject(host), null, null);
                }
                if ("js".equals(variable.getName())) {
                    placesToInject.addPlace(js, MyTestInjector.textRangeToInject(host), "function foo(doc,window) {", "}");
                }
                if ("lang".equals(variable.getName())) {
                    PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class);
                    text3 = (aClass = aClass.findInnerClassByName("Language", false)).getInitializers()[0].getBody().getFirstBodyElement().getNextSibling().getText().substring(2);
                    Language language = Language.findLanguageByID((String)text3);
                    if (language != null) {
                        placesToInject.addPlace(language, MyTestInjector.textRangeToInject(host), "", "");
                    }
                }
            }
        };
        LanguageInjector.EXTENSION_POINT_NAME.getPoint().registerExtension((Object)myInjector, parent);
    }

    private static void inject(PsiLanguageInjectionHost host, InjectedLanguagePlaces placesToInject, Language language) {
        MyTestInjector.inject(host, placesToInject, language, null, null);
    }

    private static void inject(PsiLanguageInjectionHost host, InjectedLanguagePlaces placesToInject, Language language, @NonNls String prefix, String suffix) {
        TextRange insideQuotes = MyTestInjector.textRangeToInject(host);
        placesToInject.addPlace(language, insideQuotes, prefix, suffix);
    }

    public static TextRange textRangeToInject(PsiLanguageInjectionHost host) {
        ASTNode[] children = host.getNode().getChildren(null);
        ProperTextRange insideQuotes = new ProperTextRange(0, host.getTextLength());
        if (children.length > 1 && children[0].getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            insideQuotes = new ProperTextRange(children[1].getTextRange().getStartOffset() - host.getTextRange().getStartOffset(), insideQuotes.getEndOffset());
        }
        if (children.length > 1 && children[children.length - 1].getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            insideQuotes = new ProperTextRange(insideQuotes.getStartOffset(), children[children.length - 2].getTextRange().getEndOffset() - host.getTextRange().getStartOffset());
        }
        if (host instanceof PsiLiteralExpression) {
            insideQuotes = new ProperTextRange(1, host.getTextLength() - 1);
        }
        return insideQuotes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/MyTestInjector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "injectAll";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerForStringVarInitializer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "injectVariousStuffEverywhere";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

