/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringActionContextUtil {
    public static boolean isJavaClassHeader(@NotNull PsiElement element) {
        if (element == null) {
            RefactoringActionContextUtil.$$$reportNull$$$0(0);
        }
        if (element.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        return psiClass != null && (element == psiClass || element == psiClass.getNameIdentifier() || PsiTreeUtil.isAncestor((PsiElement)psiClass.getModifierList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getExtendsList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getImplementsList(), (PsiElement)element, (boolean)false));
    }

    @Nullable
    public static PsiMethod getJavaMethodHeader(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element.getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (psiMethod != null && (element == psiMethod || element == psiMethod.getNameIdentifier() || PsiTreeUtil.isAncestor((PsiElement)psiMethod.getModifierList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiMethod.getParameterList(), (PsiElement)element, (boolean)false))) {
            return psiMethod;
        }
        return null;
    }

    public static boolean isOutsideModuleAndCodeBlock(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            RefactoringActionContextUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RefactoringActionContextUtil.$$$reportNull$$$0(2);
        }
        if (PsiUtil.isModuleFile((PsiFile)file)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/actions/RefactoringActionContextUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaClassHeader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isOutsideModuleAndCodeBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

