/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.anonymousToInner;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerDialog;
import com.intellij.refactoring.anonymousToInner.VariableInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.ElementNeedsThis;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousToInnerHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(AnonymousToInnerHandler.class);
    private Project myProject;
    private PsiManager myManager;
    private PsiAnonymousClass myAnonClass;
    private PsiClass myTargetClass;
    protected String myNewClassName;
    protected VariableInfo[] myVariableInfos;
    protected boolean myMakeStatic;
    private final Set<PsiTypeParameter> myTypeParametersToCreate = new LinkedHashSet<PsiTypeParameter>();
    private Boolean cachedNeedsThis;

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(1);
        }
        if (elements.length == 1 && elements[0] instanceof PsiAnonymousClass) {
            this.invoke(project, (Editor)CommonDataKeys.EDITOR.getData(dataContext), (PsiAnonymousClass)elements[0]);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiAnonymousClass anonymousClass = AnonymousToInnerHandler.findAnonymousClass(file, offset);
        if (anonymousClass == null) {
            this.showErrorMessage(editor, RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.anonymous", (Object[])new Object[0])));
            return;
        }
        PsiElement parent = anonymousClass.getParent();
        if (parent instanceof PsiEnumConstant) {
            this.showErrorMessage(editor, RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"anonymous.to.inner.enum.constant.cannot.refactor.message", (Object[])new Object[0])));
            return;
        }
        this.invoke(project, editor, anonymousClass);
    }

    private void showErrorMessage(Editor editor, String message2) {
        CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message2, (String)AnonymousToInnerHandler.getRefactoringName(), (String)"refactoring.convertAnonymous");
    }

    public void invoke(Project project, Editor editor, PsiAnonymousClass anonymousClass) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myAnonClass = anonymousClass;
        PsiClassType baseRef = this.myAnonClass.getBaseClassType();
        PsiClass baseClass = baseRef.resolve();
        if (baseClass == null) {
            String message2 = JavaRefactoringBundle.message((String)"error.cannot.resolve", (Object[])new Object[]{baseRef.getCanonicalText()});
            this.showErrorMessage(editor, message2);
            return;
        }
        if (PsiUtil.isLocalClass((PsiClass)baseClass)) {
            String message3 = JavaRefactoringBundle.message((String)"error.not.supported.for.local", (Object[])new Object[]{AnonymousToInnerHandler.getRefactoringName()});
            this.showErrorMessage(editor, message3);
            return;
        }
        PsiElement targetContainer = AnonymousToInnerHandler.findTargetContainer(this.myAnonClass);
        if (FileTypeUtils.isInServerPageFile((PsiElement)targetContainer) && targetContainer instanceof PsiFile) {
            String message4 = JavaRefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{AnonymousToInnerHandler.getRefactoringName()});
            this.showErrorMessage(editor, message4);
            return;
        }
        LOG.assertTrue(targetContainer instanceof PsiClass);
        this.myTargetClass = (PsiClass)targetContainer;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myTargetClass)) {
            return;
        }
        LinkedHashMap<PsiVariable, VariableInfo> variableInfoMap = new LinkedHashMap<PsiVariable, VariableInfo>();
        this.collectUsedVariables(variableInfoMap, (PsiElement)this.myAnonClass);
        VariableInfo[] infos = variableInfoMap.values().toArray(new VariableInfo[0]);
        this.myVariableInfos = infos;
        Arrays.sort(this.myVariableInfos, (o1, o2) -> {
            PsiType type1 = o1.variable.getType();
            PsiType type2 = o2.variable.getType();
            if (type1 instanceof PsiEllipsisType) {
                return 1;
            }
            if (type2 instanceof PsiEllipsisType) {
                return -1;
            }
            return ArrayUtil.find((Object[])infos, (Object)o1) > ArrayUtil.find((Object[])infos, (Object)o2) ? 1 : -1;
        });
        if (!this.showRefactoringDialog()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Runnable action = () -> {
                try {
                    this.doRefactoring();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, AnonymousToInnerHandler.getRefactoringName(), null);
    }

    protected boolean showRefactoringDialog() {
        boolean anInterface = this.myTargetClass.isInterface();
        boolean needsThis = this.needsThis() || PsiUtil.isInnerClass((PsiClass)this.myTargetClass);
        AnonymousToInnerDialog dialog = new AnonymousToInnerDialog(this.myProject, this.myAnonClass, this.myVariableInfos, needsThis || anInterface);
        if (!dialog.showAndGet()) {
            return false;
        }
        this.myNewClassName = dialog.getClassName();
        this.myVariableInfos = dialog.getVariableInfos();
        this.myMakeStatic = !needsThis && (anInterface || dialog.isMakeStatic());
        return true;
    }

    private void doRefactoring() throws IncorrectOperationException {
        this.calculateTypeParametersToCreate();
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myAnonClass, false);
        PsiClass innerClass = (PsiClass)this.myTargetClass.add((PsiElement)this.createClass(this.myNewClassName));
        ChangeContextUtil.decodeContextInfo((PsiElement)innerClass, this.myTargetClass, (PsiExpression)RefactoringChangeUtil.createThisExpression(this.myTargetClass.getManager(), this.myTargetClass));
        PsiNewExpression newExpr = (PsiNewExpression)this.myAnonClass.getParent();
        StringBuilder buf = new StringBuilder();
        buf.append("new ");
        buf.append(innerClass.getName());
        if (!this.myTypeParametersToCreate.isEmpty()) {
            buf.append("<");
            int idx = 0;
            Iterator<PsiTypeParameter> it = this.myTypeParametersToCreate.iterator();
            while (it.hasNext()) {
                if (idx > 0) {
                    buf.append(", ");
                }
                String typeParamName = ((PsiTypeParameter)it.next()).getName();
                buf.append(typeParamName);
                ++idx;
            }
            buf.append(">");
        }
        buf.append("(");
        boolean isFirstParameter = true;
        for (VariableInfo info : this.myVariableInfos) {
            if (!info.passAsParameter) continue;
            if (isFirstParameter) {
                isFirstParameter = false;
            } else {
                buf.append(",");
            }
            buf.append(info.variable.getName());
        }
        buf.append(")");
        PsiNewExpression newClassExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createExpressionFromText(buf.toString(), null);
        newClassExpression = (PsiNewExpression)newExpr.replace((PsiElement)newClassExpression);
        if (PsiDiamondTypeUtil.canCollapseToDiamond(newClassExpression, newClassExpression, newClassExpression.getType())) {
            RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)newClassExpression.getClassOrAnonymousClassReference().getParameterList());
        }
    }

    @Nullable
    public static PsiAnonymousClass findAnonymousClass(PsiFile file, int offset) {
        for (PsiElement element = file.findElementAt(offset); element != null; element = element.getParent()) {
            PsiNewExpression newExpression;
            if (element instanceof PsiAnonymousClass) {
                return (PsiAnonymousClass)element;
            }
            if (!(element instanceof PsiNewExpression) || (newExpression = (PsiNewExpression)element).getAnonymousClass() == null) continue;
            return newExpression.getAnonymousClass();
        }
        return null;
    }

    public static PsiElement findTargetContainer(PsiAnonymousClass anonClass) {
        PsiElement parent = anonClass.getParent();
        while (!(parent instanceof PsiClass) || parent instanceof PsiAnonymousClass) {
            if (parent instanceof PsiFile) {
                return parent;
            }
            parent = parent.getParent();
        }
        return parent;
    }

    private void collectUsedVariables(final Map<PsiVariable, VariableInfo> variableInfoMap, PsiElement scope) {
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiVariable var;
                PsiClass containingClass;
                PsiElement refElement;
                if (expression2.getQualifierExpression() == null && (refElement = expression2.resolve()) instanceof PsiVariable && !(refElement instanceof PsiField) && PsiTreeUtil.isAncestor((PsiElement)(containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(var = (PsiVariable)refElement), PsiClass.class)), (PsiElement)AnonymousToInnerHandler.this.myAnonClass, (boolean)true)) {
                    AnonymousToInnerHandler.this.saveVariable(variableInfoMap, var, expression2);
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    public boolean needsThis() {
        if (this.cachedNeedsThis == null) {
            ElementNeedsThis memberNeedsThis = new ElementNeedsThis(this.myTargetClass, (PsiElement)this.myAnonClass);
            this.myAnonClass.accept((PsiElementVisitor)memberNeedsThis);
            class HasExplicitThis
            extends JavaRecursiveElementWalkingVisitor {
                boolean hasExplicitThis;

                HasExplicitThis() {
                }

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                }

                public void visitThisExpression(PsiThisExpression expression2) {
                    this.hasExplicitThis = true;
                }
            }
            HasExplicitThis hasExplicitThis = new HasExplicitThis();
            PsiExpressionList argList = this.myAnonClass.getArgumentList();
            if (argList != null) {
                argList.accept((PsiElementVisitor)hasExplicitThis);
            }
            this.cachedNeedsThis = memberNeedsThis.usesMembers() || hasExplicitThis.hasExplicitThis;
        }
        return this.cachedNeedsThis;
    }

    private void saveVariable(Map<PsiVariable, VariableInfo> variableInfoMap, PsiVariable var, PsiReferenceExpression usage) {
        VariableInfo info = variableInfoMap.get(var);
        if (info == null) {
            info = new VariableInfo(var);
            variableInfoMap.put(var, info);
        }
        info.saveInField = info.saveInField | !this.isUsedInInitializer((PsiElement)usage);
    }

    private boolean isUsedInInitializer(PsiElement usage) {
        PsiElement parent = usage.getParent();
        while (!this.myAnonClass.equals(parent)) {
            PsiExpressionList expressionList;
            if (parent instanceof PsiExpressionList ? this.myAnonClass.equals((expressionList = (PsiExpressionList)parent).getParent()) : parent instanceof PsiClassInitializer && this.myAnonClass.equals(((PsiClassInitializer)parent).getContainingClass())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private PsiClass createClass(String name2) throws IncorrectOperationException {
        PsiElement lastChild;
        PsiReferenceList superConstructorThrowsList;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myAnonClass.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        PsiNewExpression newExpression = (PsiNewExpression)this.myAnonClass.getParent();
        PsiMethod superConstructor = newExpression.resolveConstructor();
        PsiClass aClass = factory.createClass(name2);
        PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
        LOG.assertTrue(typeParameterList != null);
        for (PsiTypeParameter typeParameter : this.myTypeParametersToCreate) {
            typeParameterList.add((PsiElement)typeParameter);
        }
        if (!this.myTargetClass.isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"private", (boolean)true);
            PsiModifierListOwner owner2 = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonClass, PsiModifierListOwner.class);
            if (owner2 != null && owner2.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"static", (boolean)true);
            }
        } else {
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"packageLocal", (boolean)true);
        }
        PsiJavaCodeReferenceElement baseClassRef = this.myAnonClass.getBaseClassReference();
        PsiClass baseClass = (PsiClass)baseClassRef.resolve();
        if (baseClass == null || !"java.lang.Object".equals(baseClass.getQualifiedName())) {
            PsiReferenceList refList;
            PsiReferenceList psiReferenceList = refList = baseClass != null && baseClass.isInterface() ? aClass.getImplementsList() : aClass.getExtendsList();
            if (refList != null) {
                refList.add((PsiElement)baseClassRef);
            }
        }
        this.renameReferences((PsiElement)this.myAnonClass);
        AnonymousToInnerHandler.copyClassBody((PsiClass)this.myAnonClass, aClass, this.myVariableInfos.length > 0);
        if (this.myVariableInfos.length > 0) {
            this.createFields(aClass);
        }
        PsiExpressionList argList = newExpression.getArgumentList();
        assert (argList != null);
        PsiExpression[] originalExpressions = argList.getExpressions();
        PsiReferenceList psiReferenceList = superConstructorThrowsList = superConstructor != null && superConstructor.getThrowsList().getReferencedTypes().length > 0 ? superConstructor.getThrowsList() : null;
        if (this.myVariableInfos.length > 0 || originalExpressions.length > 0 || superConstructorThrowsList != null) {
            PsiMethod constructor = factory.createConstructor();
            if (superConstructorThrowsList != null) {
                constructor.getThrowsList().replace((PsiElement)superConstructorThrowsList);
            }
            if (originalExpressions.length > 0) {
                this.createSuperStatement(constructor, originalExpressions);
            }
            if (this.myVariableInfos.length > 0) {
                this.fillParameterList(constructor);
                this.createAssignmentStatements(constructor);
                this.appendInitializers(constructor);
            }
            constructor = (PsiMethod)codeStyleManager.reformat((PsiElement)constructor);
            aClass.add((PsiElement)constructor);
        }
        if (!this.needsThis() && this.myMakeStatic && !this.myTargetClass.isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"static", (boolean)true);
        }
        if (PsiUtil.isJavaToken((PsiElement)(lastChild = aClass.getLastChild()), (IElementType)JavaTokenType.SEMICOLON)) {
            lastChild.delete();
        }
        return aClass;
    }

    private void appendInitializers(PsiMethod constructor) throws IncorrectOperationException {
        PsiCodeBlock constructorBody = constructor.getBody();
        assert (constructorBody != null);
        ArrayList<Object> toAdd = new ArrayList<Object>();
        for (PsiClassInitializer psiClassInitializer : this.myAnonClass.getInitializers()) {
            if (psiClassInitializer.hasModifierProperty("static")) continue;
            toAdd.add(psiClassInitializer);
        }
        for (PsiClassInitializer psiClassInitializer : this.myAnonClass.getFields()) {
            if (psiClassInitializer.hasModifierProperty("static") || psiClassInitializer.getInitializer() == null) continue;
            toAdd.add(psiClassInitializer);
        }
        toAdd.sort(Comparator.comparingInt(e -> e.getTextRange().getStartOffset()));
        for (PsiElement psiElement : toAdd) {
            if (psiElement instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)psiElement;
                PsiCodeBlock psiCodeBlock = initializer.getBody();
                PsiElement firstBodyElement = psiCodeBlock.getFirstBodyElement();
                if (firstBodyElement == null) continue;
                constructorBody.addRange(firstBodyElement, psiCodeBlock.getLastBodyElement());
                continue;
            }
            PsiField field = (PsiField)psiElement;
            PsiExpressionStatement psiExpressionStatement = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createStatementFromText(field.getName() + "= 0;", null);
            PsiExpression rightExpression = ((PsiAssignmentExpression)psiExpressionStatement.getExpression()).getRExpression();
            assert (rightExpression != null);
            PsiExpression fieldInitializer = field.getInitializer();
            assert (fieldInitializer != null);
            rightExpression.replace((PsiElement)fieldInitializer);
            constructorBody.add((PsiElement)psiExpressionStatement);
        }
    }

    private static void copyClassBody(PsiClass sourceClass, PsiClass targetClass, boolean appendInitializersToConstructor) throws IncorrectOperationException {
        PsiElement lbrace = sourceClass.getLBrace();
        PsiElement rbrace = sourceClass.getRBrace();
        if (lbrace != null) {
            targetClass.addRange(lbrace.getNextSibling(), rbrace != null ? rbrace.getPrevSibling() : sourceClass.getLastChild());
            if (appendInitializersToConstructor) {
                PsiField[] fields;
                PsiClassInitializer[] initializers;
                for (PsiClassInitializer initializer : initializers = targetClass.getInitializers()) {
                    if (initializer.hasModifierProperty("static")) continue;
                    initializer.delete();
                }
                for (PsiField field : fields = targetClass.getFields()) {
                    PsiExpression initializer = field.getInitializer();
                    if (field.hasModifierProperty("static") || initializer == null) continue;
                    initializer.delete();
                }
            }
        }
    }

    private void fillParameterList(PsiMethod constructor) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        PsiParameterList parameterList = constructor.getParameterList();
        for (VariableInfo info : this.myVariableInfos) {
            if (!info.passAsParameter) continue;
            parameterList.add((PsiElement)factory.createParameter(info.parameterName, info.variable.getType()));
        }
    }

    private void createFields(PsiClass aClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        for (VariableInfo info : this.myVariableInfos) {
            if (!info.saveInField) continue;
            PsiType type2 = info.variable.getType();
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            PsiField field = factory.createField(info.fieldName, type2);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            aClass.add((PsiElement)field);
        }
    }

    private void createAssignmentStatements(PsiMethod constructor) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        for (VariableInfo info : this.myVariableInfos) {
            boolean useThis;
            if (!info.saveInField) continue;
            String text2 = info.fieldName + "=a;";
            boolean bl = useThis = info.passAsParameter && info.parameterName.equals(info.fieldName);
            if (useThis) {
                text2 = "this." + text2;
            }
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(text2, null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement);
            PsiCodeBlock constructorBody = constructor.getBody();
            assert (constructorBody != null);
            statement = (PsiExpressionStatement)constructorBody.add((PsiElement)statement);
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
            PsiReferenceExpression rExpr = (PsiReferenceExpression)assignment.getRExpression();
            assert (rExpr != null);
            if (info.passAsParameter) {
                rExpr.replace((PsiElement)factory.createExpressionFromText(info.parameterName, null));
                continue;
            }
            rExpr.delete();
        }
    }

    private void renameReferences(PsiElement scope) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        for (VariableInfo info : this.myVariableInfos) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)info.variable, (SearchScope)new LocalSearchScope(scope))) {
                PsiElement ref = reference.getElement();
                PsiIdentifier identifier = (PsiIdentifier)((PsiJavaCodeReferenceElement)ref).getReferenceNameElement();
                assert (identifier != null);
                boolean renameToFieldName = !this.isUsedInInitializer(ref);
                PsiIdentifier newNameIdentifier = factory.createIdentifier(renameToFieldName ? info.fieldName : info.parameterName);
                if (renameToFieldName) {
                    identifier.replace((PsiElement)newNameIdentifier);
                    continue;
                }
                if (!info.passAsParameter) continue;
                identifier.replace((PsiElement)newNameIdentifier);
            }
        }
    }

    private void createSuperStatement(PsiMethod constructor, PsiExpression[] paramExpressions) throws IncorrectOperationException {
        PsiCodeBlock body2 = constructor.getBody();
        assert (body2 != null);
        final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        PsiStatement statement = factory.createStatementFromText("super();", null);
        statement = (PsiStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement);
        statement = (PsiStatement)body2.add((PsiElement)statement);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression();
        PsiExpressionList exprList = methodCall.getArgumentList();
        PsiThisExpression qualifiedThis = (PsiThisExpression)factory.createExpressionFromText("A.this", null);
        PsiJavaCodeReferenceElement targetClassRef = factory.createClassReferenceElement(this.myTargetClass);
        PsiJavaCodeReferenceElement thisQualifier = qualifiedThis.getQualifier();
        assert (thisQualifier != null);
        thisQualifier.replace((PsiElement)targetClassRef);
        for (PsiExpression expr2 : paramExpressions) {
            ChangeContextUtil.encodeContextInfo((PsiElement)expr2, true);
            PsiElement newExpr = exprList.add((PsiElement)expr2);
            ChangeContextUtil.decodeContextInfo(newExpr, this.myTargetClass, (PsiExpression)qualifiedThis);
        }
        class SupersConvertor
        extends JavaRecursiveElementVisitor {
            SupersConvertor() {
            }

            public void visitThisExpression(PsiThisExpression expression2) {
                try {
                    PsiThisExpression qualifiedThis = (PsiThisExpression)factory.createExpressionFromText("A.this", null);
                    PsiJavaCodeReferenceElement targetClassRef = factory.createClassReferenceElement(AnonymousToInnerHandler.this.myTargetClass);
                    PsiJavaCodeReferenceElement thisQualifier = qualifiedThis.getQualifier();
                    assert (thisQualifier != null);
                    thisQualifier.replace((PsiElement)targetClassRef);
                    expression2.replace((PsiElement)qualifiedThis);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
            }
        }
        SupersConvertor supersConvertor = new SupersConvertor();
        methodCall.getArgumentList().accept((PsiElementVisitor)supersConvertor);
    }

    private void calculateTypeParametersToCreate() {
        this.myAnonClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiTypeParameterListOwner owner2;
                super.visitReferenceElement(reference);
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiTypeParameter && (owner2 = ((PsiTypeParameter)resolved).getOwner()) != null && !PsiTreeUtil.isAncestor((PsiElement)AnonymousToInnerHandler.this.myAnonClass, (PsiElement)owner2, (boolean)false) && (RefactoringUtil.isInStaticContext((PsiElement)owner2, AnonymousToInnerHandler.this.myTargetClass) || AnonymousToInnerHandler.this.myMakeStatic)) {
                    AnonymousToInnerHandler.this.myTypeParametersToCreate.add((PsiTypeParameter)resolved);
                }
            }
        });
    }

    static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"anonymousToInner.refactoring.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/anonymousToInner/AnonymousToInnerHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

