/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.AccessModifier;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodDescriptor
implements MethodDescriptor<ParameterInfoImpl, String> {
    @NotNull
    private final PsiMethod myMethod;

    public JavaMethodDescriptor(@NotNull PsiMethod method) {
        if (method == null) {
            JavaMethodDescriptor.$$$reportNull$$$0(0);
        }
        this.myMethod = method;
    }

    public String getName() {
        return this.myMethod.getName();
    }

    @NotNull
    public List<ParameterInfoImpl> getParameters() {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = this.myMethod.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            ParameterInfoImpl info = ParameterInfoImpl.create(i).withName(parameter2.getName()).withType(parameter2.getType());
            info.defaultValue = "";
            result.add(info);
        }
        ArrayList<ParameterInfoImpl> arrayList = result;
        if (arrayList == null) {
            JavaMethodDescriptor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public String getVisibility() {
        String string = VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList());
        if (string == null) {
            JavaMethodDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            JavaMethodDescriptor.$$$reportNull$$$0(3);
        }
        return psiMethod;
    }

    public int getParametersCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @Nullable
    public String getReturnTypeText() {
        PsiTypeElement typeElement = this.myMethod.getReturnTypeElement();
        if (typeElement != null) {
            PsiType type2 = typeElement.getType();
            if (type2.getAnnotations().length > 0) {
                return type2.getPresentableText(true);
            }
            return typeElement.getText();
        }
        return null;
    }

    public boolean canChangeVisibility() {
        return AccessModifier.getAvailableModifiers((PsiMember)this.myMethod).size() > 1;
    }

    public boolean canChangeParameters() {
        return true;
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        MethodDescriptor.ReadWriteOption readWriteOption = this.myMethod.isConstructor() ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
        if (readWriteOption == null) {
            JavaMethodDescriptor.$$$reportNull$$$0(4);
        }
        return readWriteOption;
    }

    public boolean canChangeName() {
        return !this.myMethod.isConstructor();
    }

    public List<AccessModifier> getAllowedModifiers() {
        return AccessModifier.getAvailableModifiers((PsiMember)this.myMethod);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaMethodDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaMethodDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canChangeReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

