/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParametersFolder {
    private final Map<PsiVariable, PsiExpression> myExpressions = new HashMap<PsiVariable, PsiExpression>();
    private final Map<PsiVariable, String> myArgs = new HashMap<PsiVariable, String>();
    private final Map<PsiVariable, List<PsiExpression>> myMentionedInExpressions = new HashMap<PsiVariable, List<PsiExpression>>();
    private final Set<PsiVariable> myDeleted = new HashSet<PsiVariable>();
    private boolean myFoldingSelectedByDefault;

    ParametersFolder() {
    }

    void clear() {
        this.myExpressions.clear();
        this.myMentionedInExpressions.clear();
        this.myDeleted.clear();
    }

    boolean isParameterSafeToDelete(@NotNull VariableData data, @NotNull LocalSearchScope scope) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(1);
        }
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
            PsiElement expression2 = reference.getElement();
            while (expression2 != null) {
                for (PsiExpression psiExpression : this.myExpressions.values()) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression2, (PsiElement)psiExpression)) continue;
                    continue block0;
                }
                expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
            }
            return false;
        }
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression == null) {
            return true;
        }
        for (PsiVariable variable : this.myExpressions.keySet()) {
            PsiExpression expr2;
            if (variable == data.variable || this.myDeleted.contains(variable) || (expr2 = this.myExpressions.get(variable)) == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr2, (PsiElement)psiExpression)) continue;
            this.myDeleted.add(data.variable);
            return true;
        }
        return false;
    }

    void foldParameterUsagesInBody(@NotNull List<? extends VariableData> datum, PsiElement @NotNull [] elements, @NotNull SearchScope scope) {
        if (datum == null) {
            ParametersFolder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            ParametersFolder.$$$reportNull$$$0(4);
        }
        LinkedHashMap equivalentExpressions = new LinkedHashMap();
        for (VariableData variableData : datum) {
            PsiExpression psiExpression;
            if (this.myDeleted.contains(variableData.variable) || (psiExpression = this.myExpressions.get(variableData.variable)) == null) continue;
            HashSet<PsiExpression> eqExpressions = new HashSet<PsiExpression>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)variableData.variable, (SearchScope)scope)) {
                PsiExpression expression2 = ParametersFolder.findEquivalent(psiExpression, reference.getElement());
                if (expression2 == null || !expression2.isValid()) continue;
                eqExpressions.add(expression2);
            }
            equivalentExpressions.put(variableData, eqExpressions);
        }
        for (VariableData variableData : equivalentExpressions.keySet()) {
            Set eqExpressions = (Set)equivalentExpressions.get((Object)variableData);
            block3: for (PsiExpression expression3 : eqExpressions) {
                if (!expression3.isValid()) continue;
                PsiExpression refExpression = JavaPsiFacade.getElementFactory((Project)expression3.getProject()).createExpressionFromText(variableData.name, (PsiElement)expression3);
                PsiElement replaced = expression3.replace((PsiElement)refExpression);
                for (PsiElement psiElement : elements) {
                    if (expression3 != psiElement) continue;
                    elements[i] = replaced;
                    continue block3;
                }
            }
        }
    }

    boolean isParameterFoldable(@NotNull VariableData data, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables, @NotNull UniqueNameGenerator nameGenerator, @NotNull String defaultName) {
        List<PsiExpression> mentionedInExpressions;
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(6);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(7);
        }
        if (nameGenerator == null) {
            ParametersFolder.$$$reportNull$$$0(8);
        }
        if (defaultName == null) {
            ParametersFolder.$$$reportNull$$$0(9);
        }
        if ((mentionedInExpressions = this.getMentionedExpressions(data.variable, scope, inputVariables)) == null) {
            return false;
        }
        int currentRank = 0;
        PsiExpression mostRanked = null;
        for (int i = mentionedInExpressions.size() - 1; i >= 0; --i) {
            PsiExpression expression2 = mentionedInExpressions.get(i);
            int r = ParametersFolder.findUsedVariables(data, inputVariables, expression2).size();
            if (currentRank >= r && (!(expression2 instanceof PsiArrayAccessExpression) || !this.myFoldingSelectedByDefault || currentRank != r)) continue;
            currentRank = r;
            mostRanked = expression2;
        }
        if (mostRanked != null) {
            this.myExpressions.put(data.variable, mostRanked);
            this.myArgs.put(data.variable, mostRanked.getText());
            data.type = RefactoringChangeUtil.getTypeByExpression(mostRanked);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)mostRanked.getProject());
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, mostRanked, data.type);
            if (nameInfo.names.length > 0 && !Objects.equals(nameInfo.names[0], data.name) && !Objects.equals(nameInfo.names[0], defaultName)) {
                data.name = nameInfo.names[0];
                ParametersFolder.setUniqueName(data, nameGenerator, mostRanked, codeStyleManager);
            }
        }
        return mostRanked != null;
    }

    private static void setUniqueName(@NotNull VariableData data, @NotNull UniqueNameGenerator nameGenerator, @NotNull PsiExpression expr2, @NotNull JavaCodeStyleManager codeStyleManager) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(10);
        }
        if (nameGenerator == null) {
            ParametersFolder.$$$reportNull$$$0(11);
        }
        if (expr2 == null) {
            ParametersFolder.$$$reportNull$$$0(12);
        }
        if (codeStyleManager == null) {
            ParametersFolder.$$$reportNull$$$0(13);
        }
        String name2 = data.name;
        int idx = 1;
        while (true) {
            if (nameGenerator.isUnique(name2, "", "") && name2.equals(codeStyleManager.suggestUniqueVariableName(name2, (PsiElement)expr2, true))) break;
            name2 = data.name + idx++;
        }
        data.name = name2;
        nameGenerator.addExistingName(name2);
    }

    @NotNull
    private static Set<PsiVariable> findUsedVariables(@NotNull VariableData data, final @NotNull List<? extends PsiVariable> inputVariables, @NotNull PsiExpression expression2) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(14);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(15);
        }
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(16);
        }
        final HashSet<PsiVariable> found = new HashSet<PsiVariable>();
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && inputVariables.contains(resolved)) {
                    found.add((PsiVariable)resolved);
                }
            }
        });
        found.remove(data.variable);
        HashSet<PsiVariable> hashSet = found;
        if (hashSet == null) {
            ParametersFolder.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    boolean isFoldable() {
        return !this.myExpressions.isEmpty();
    }

    @Nullable
    private List<PsiExpression> getMentionedExpressions(@NotNull PsiVariable var, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables) {
        if (var == null) {
            ParametersFolder.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(19);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(20);
        }
        if (this.myMentionedInExpressions.containsKey(var)) {
            return this.myMentionedInExpressions.get(var);
        }
        PsiElement[] scopeElements = scope.getScope();
        ArrayList<PsiExpression> expressions2 = null;
        Boolean arrayAccess = null;
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)var, (SearchScope)scope)) {
            PsiElement expression2 = reference.getElement();
            if (expressions2 == null) {
                expressions2 = new ArrayList<PsiExpression>();
                while (expression2 instanceof PsiExpression) {
                    PsiType expressionType;
                    PsiElement parent;
                    if (ParametersFolder.isAccessedForWriting((PsiExpression)expression2)) {
                        return null;
                    }
                    if (ParametersFolder.isAncestor(expression2, scopeElements) || ParametersFolder.dependsOnLocals(expression2, inputVariables) || (parent = expression2.getParent()) instanceof PsiExpressionStatement || (expressionType = ((PsiExpression)expression2).getType()) == null || PsiType.VOID.equals((Object)expressionType) || ParametersFolder.isTooLongExpressionChain(expression2)) continue block0;
                    if (!ParametersFolder.isMethodNameExpression(expression2)) {
                        expressions2.add((PsiExpression)expression2);
                    }
                    if (expression2 instanceof PsiArrayAccessExpression && (arrayAccess == null || arrayAccess.booleanValue())) {
                        arrayAccess = ParametersFolder.isSafeToFoldArrayAccess(scope, expression2);
                    }
                    expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
                }
                continue;
            }
            Iterator iterator = expressions2.iterator();
            while (iterator.hasNext()) {
                PsiExpression equivalent = ParametersFolder.findEquivalent((PsiExpression)iterator.next(), expression2);
                if (equivalent == null) {
                    iterator.remove();
                    continue;
                }
                if (!(equivalent instanceof PsiArrayAccessExpression) || arrayAccess != null && !arrayAccess.booleanValue()) continue;
                arrayAccess = ParametersFolder.isSafeToFoldArrayAccess(scope, (PsiElement)equivalent);
            }
        }
        if (arrayAccess != null && arrayAccess.booleanValue()) {
            this.myFoldingSelectedByDefault = true;
        }
        this.myMentionedInExpressions.put(var, expressions2);
        return expressions2;
    }

    private static boolean isSafeToFoldArrayAccess(@NotNull LocalSearchScope scope, PsiElement expression2) {
        if (scope == null) {
            ParametersFolder.$$$reportNull$$$0(21);
        }
        while (true) {
            PsiElement parent;
            if ((parent = expression2.getParent()) != null && scope.containsRange(parent.getContainingFile(), parent.getTextRange())) {
                if (parent instanceof PsiIfStatement || parent instanceof PsiConditionalExpression || parent instanceof PsiSwitchStatement) {
                    return false;
                }
            } else {
                return true;
            }
            expression2 = parent;
        }
    }

    private static boolean isAccessedForWriting(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(22);
        }
        final PsiExpression[] exprWithWriteAccessInside = new PsiExpression[1];
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (exprWithWriteAccessInside[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitExpression(PsiExpression expression2) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                    exprWithWriteAccessInside[0] = expression2;
                }
                super.visitExpression(expression2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/extractMethod/ParametersFolder$2", "visitElement"));
            }
        });
        return exprWithWriteAccessInside[0] != null;
    }

    private static boolean isAncestor(@NotNull PsiElement expression2, PsiElement @NotNull [] scopeElements) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(23);
        }
        if (scopeElements == null) {
            ParametersFolder.$$$reportNull$$$0(24);
        }
        for (PsiElement scopeElement : scopeElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)expression2, (PsiElement)scopeElement, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTooLongExpressionChain(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(25);
        }
        int count = 0;
        PsiElement element = ParametersFolder.getInnerExpression(expression2);
        while (element != null) {
            if (++count > 1) {
                return true;
            }
            element = ParametersFolder.getInnerExpression(element);
        }
        return false;
    }

    private static PsiElement getInnerExpression(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(26);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression();
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            while (expression2 instanceof PsiArrayAccessExpression) {
                expression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            }
            return expression2;
        }
        return null;
    }

    private static boolean isMethodNameExpression(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(27);
        }
        PsiElement parent = expression2.getParent();
        return expression2 instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression && ((PsiReferenceExpression)expression2).getReferenceNameElement() == ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceNameElement();
    }

    private static boolean dependsOnLocals(@NotNull PsiElement expression2, final @NotNull List<? extends PsiVariable> inputVariables) {
        if (expression2 == null) {
            ParametersFolder.$$$reportNull$$$0(28);
        }
        if (inputVariables == null) {
            ParametersFolder.$$$reportNull$$$0(29);
        }
        final boolean[] localVarsUsed = new boolean[]{false};
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiVariable variable;
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiVariable && !((variable = (PsiVariable)resolved) instanceof PsiField) && !inputVariables.contains(variable)) {
                    localVarsUsed[0] = true;
                    return;
                }
                super.visitReferenceExpression(expression2);
            }
        });
        return localVarsUsed[0];
    }

    @NotNull
    String getGeneratedCallArgument(@NotNull VariableData data) {
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(30);
        }
        String string = this.myArgs.containsKey(data.variable) ? this.myArgs.get(data.variable) : data.variable.getName();
        if (string == null) {
            ParametersFolder.$$$reportNull$$$0(31);
        }
        return string;
    }

    void putCallArgument(@NotNull PsiVariable argument, @NotNull PsiExpression value2) {
        if (argument == null) {
            ParametersFolder.$$$reportNull$$$0(32);
        }
        if (value2 == null) {
            ParametersFolder.$$$reportNull$$$0(33);
        }
        this.myArgs.put(argument, value2.getText());
    }

    boolean annotateWithParameter(@NotNull VariableData data, @NotNull PsiElement element) {
        PsiExpression expression2;
        PsiExpression psiExpression;
        if (data == null) {
            ParametersFolder.$$$reportNull$$$0(34);
        }
        if (element == null) {
            ParametersFolder.$$$reportNull$$$0(35);
        }
        if ((psiExpression = this.myExpressions.get(data.variable)) != null && (expression2 = ParametersFolder.findEquivalent(psiExpression, element)) != null) {
            expression2.putUserData(DuplicatesFinder.PARAMETER, (Object)new DuplicatesFinder.Parameter(data.variable, expression2.getType(), true));
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression findEquivalent(PsiExpression expr2, @NotNull PsiElement element) {
        if (element == null) {
            ParametersFolder.$$$reportNull$$$0(36);
        }
        PsiElement expression2 = element;
        while (expression2 != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression2, (PsiElement)expr2)) {
                PsiExpression psiExpression = (PsiExpression)expression2;
                return PsiUtil.isAccessedForWriting((PsiExpression)psiExpression) ? null : psiExpression;
            }
            expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
        }
        return null;
    }

    boolean wasExcluded(@NotNull PsiVariable variable) {
        if (variable == null) {
            ParametersFolder.$$$reportNull$$$0(37);
        }
        return this.myDeleted.contains(variable) || this.myMentionedInExpressions.containsKey(variable) && this.myExpressions.get(variable) == null;
    }

    boolean isFoldingSelectedByDefault() {
        return this.myFoldingSelectedByDefault;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datum";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 15: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameGenerator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleManager";
                break;
            }
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElements";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametersFolder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsedVariables";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedCallArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isParameterSafeToDelete";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "foldParameterUsagesInBody";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isParameterFoldable";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUsedVariables";
                break;
            }
            case 17: 
            case 31: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMentionedExpressions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToFoldArrayAccess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForWriting";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isTooLongExpressionChain";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInnerExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMethodNameExpression";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnLocals";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedCallArgument";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "putCallArgument";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithParameter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findEquivalent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "wasExcluded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

