/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.newImpl.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.newImpl.structures.DataOutput;
import com.intellij.refactoring.extractMethod.newImpl.structures.FlowOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0002J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0015\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\rH\u0002J,\u0010\"\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b 0\n2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0$\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010%J&\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/refactoring/extractMethod/newImpl/CallBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;)V", "factory", "Lcom/intellij/psi/PsiElementFactory;", "buildCall", "", "Lcom/intellij/psi/PsiStatement;", "methodCall", "", "flowOutput", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/FlowOutput;", "dataOutput", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/DataOutput;", "exposedDeclarations", "Lcom/intellij/psi/PsiVariable;", "buildExpressionCall", "conditionalExit", "flow", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/FlowOutput$ConditionalFlow;", "createDeclaration", "type", "Lcom/intellij/psi/PsiType;", "name", "initializer", "createFlowStatements", "expressionOf", "Lcom/intellij/psi/PsiExpression;", "Lorg/jetbrains/annotations/NotNull;", "expression", "statementsOf", "statements", "", "([Ljava/lang/String;)Ljava/util/List;", "unconditionalExit", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/FlowOutput$UnconditionalFlow;", "variableDeclaration", "intellij.java.impl"})
public final class CallBuilder {
    private final PsiElementFactory factory;
    private final PsiElement context;

    private final PsiExpression expressionOf(String expression2) {
        PsiExpression psiExpression = this.factory.createExpressionFromText(expression2, this.context);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiExpression, (String)"factory.createExpression\u2026Text(expression, context)");
        return psiExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiStatement> statementsOf(String ... statements) {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = statements;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void statement;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiStatement psiStatement = this.factory.createStatementFromText((String)statement, this.context);
            collection.add(psiStatement);
        }
        return (List)destination$iv$iv;
    }

    private final PsiStatement createDeclaration(PsiType type2, String name2, String initializer) {
        PsiStatement psiStatement;
        if (type2 != null) {
            PsiDeclarationStatement psiDeclarationStatement = this.factory.createVariableDeclarationStatement(name2, type2, this.expressionOf(initializer));
            Intrinsics.checkExpressionValueIsNotNull((Object)psiDeclarationStatement, (String)"factory.createVariableDe\u2026xpressionOf(initializer))");
            psiStatement = (PsiStatement)psiDeclarationStatement;
        } else {
            PsiStatement psiStatement2 = this.factory.createStatementFromText(name2 + " = " + initializer + ';', this.context);
            psiStatement = psiStatement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiStatement2, (String)"factory.createStatementF\u2026 $initializer;\", context)");
        }
        return psiStatement;
    }

    private final List<PsiStatement> variableDeclaration(String methodCall, DataOutput dataOutput) {
        PsiElement psiElement;
        Object[] declarationStatement;
        PsiStatement declaration2;
        PsiStatement psiStatement;
        PsiStatement psiStatement2;
        DataOutput dataOutput2 = dataOutput;
        if (dataOutput2 instanceof DataOutput.VariableOutput) {
            PsiType psiType = dataOutput.getType();
            CallBuilder callBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            PsiType it = psiType;
            boolean bl3 = false;
            PsiType psiType2 = ((DataOutput.VariableOutput)dataOutput).getDeclareType() ? psiType : null;
            psiStatement2 = callBuilder.createDeclaration(psiType2, ((DataOutput.VariableOutput)dataOutput).getName(), methodCall);
        } else if (dataOutput2 instanceof DataOutput.ExpressionOutput) {
            PsiType psiType = dataOutput.getType();
            String string = ((DataOutput.ExpressionOutput)dataOutput).getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            psiStatement2 = this.createDeclaration(psiType, string, methodCall);
        } else if (Intrinsics.areEqual((Object)dataOutput2, (Object)DataOutput.ArtificialBooleanOutput.INSTANCE) || dataOutput2 instanceof DataOutput.EmptyOutput) {
            psiStatement2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (!((psiStatement = (declaration2 = psiStatement2)) instanceof PsiDeclarationStatement)) {
            psiStatement = null;
        }
        Object[] objectArray = declarationStatement = (Object[])psiStatement;
        if (!((declarationStatement != null && (objectArray = objectArray.getDeclaredElements()) != null ? (PsiElement)ArraysKt.firstOrNull((Object[])objectArray) : (psiElement = null)) instanceof PsiVariable)) {
            psiElement = null;
        }
        PsiVariable declaredVariable = (PsiVariable)psiElement;
        if (dataOutput instanceof DataOutput.VariableOutput && declaredVariable != null) {
            boolean needsFinal = ((DataOutput.VariableOutput)dataOutput).getVariable().hasModifierProperty("final");
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiModifierListOwner)declaredVariable), (String)"final", (boolean)needsFinal);
        }
        return CollectionsKt.listOfNotNull((Object)declaration2);
    }

    private final List<PsiStatement> conditionalExit(String methodCall, FlowOutput.ConditionalFlow flow, DataOutput dataOutput) {
        String string;
        DataOutput dataOutput2 = dataOutput;
        if (dataOutput2 instanceof DataOutput.VariableOutput) {
            string = "if (" + ((DataOutput.VariableOutput)dataOutput).getName() + " == null) " + ((PsiStatement)CollectionsKt.first(flow.getStatements())).getText();
        } else if (dataOutput2 instanceof DataOutput.ExpressionOutput) {
            string = "if (" + ((DataOutput.ExpressionOutput)dataOutput).getName() + " != null) return " + ((DataOutput.ExpressionOutput)dataOutput).getName() + ';';
        } else if (Intrinsics.areEqual((Object)dataOutput2, (Object)DataOutput.ArtificialBooleanOutput.INSTANCE)) {
            string = "if (" + methodCall + ") " + ((PsiStatement)CollectionsKt.first(flow.getStatements())).getText();
        } else {
            if (dataOutput2 instanceof DataOutput.EmptyOutput) {
                throw (Throwable)new IllegalArgumentException();
            }
            throw new NoWhenBranchMatchedException();
        }
        String exit = string;
        return this.statementsOf(exit);
    }

    private final List<PsiStatement> unconditionalExit(String methodCall, FlowOutput.UnconditionalFlow flow, DataOutput dataOutput) {
        List<PsiStatement> list;
        DataOutput dataOutput2 = dataOutput;
        if (dataOutput2 instanceof DataOutput.VariableOutput) {
            String[] stringArray = new String[1];
            String string = ((PsiStatement)CollectionsKt.first(flow.getStatements())).getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"flow.statements.first().text");
            stringArray[0] = string;
            list = this.statementsOf(stringArray);
        } else if (dataOutput2 instanceof DataOutput.ExpressionOutput) {
            list = this.statementsOf("return " + methodCall + ';');
        } else {
            if (Intrinsics.areEqual((Object)dataOutput2, (Object)DataOutput.ArtificialBooleanOutput.INSTANCE)) {
                throw (Throwable)new IllegalStateException();
            }
            if (dataOutput2 instanceof DataOutput.EmptyOutput) {
                if (flow.isDefaultExit()) {
                    list = this.statementsOf(methodCall + ';');
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = methodCall + ';';
                    String string = ((PsiStatement)CollectionsKt.first(flow.getStatements())).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"flow.statements.first().text");
                    stringArray[1] = string;
                    list = this.statementsOf(stringArray);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<PsiStatement> createFlowStatements(String methodCall, FlowOutput flowOutput, DataOutput dataOutput) {
        List<PsiStatement> list;
        FlowOutput flowOutput2 = flowOutput;
        if (flowOutput2 instanceof FlowOutput.ConditionalFlow) {
            list = this.conditionalExit(methodCall, (FlowOutput.ConditionalFlow)flowOutput, dataOutput);
        } else if (flowOutput2 instanceof FlowOutput.UnconditionalFlow) {
            list = this.unconditionalExit(methodCall, (FlowOutput.UnconditionalFlow)flowOutput, dataOutput);
        } else if (Intrinsics.areEqual((Object)flowOutput2, (Object)FlowOutput.EmptyFlow.INSTANCE)) {
            list = !(dataOutput instanceof DataOutput.VariableOutput) ? this.statementsOf(methodCall + ';') : CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiStatement> buildCall(@NotNull String methodCall, @NotNull FlowOutput flowOutput, @NotNull DataOutput dataOutput, @NotNull List<? extends PsiVariable> exposedDeclarations) {
        Collection<PsiDeclarationStatement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)methodCall, (String)"methodCall");
        Intrinsics.checkParameterIsNotNull((Object)flowOutput, (String)"flowOutput");
        Intrinsics.checkParameterIsNotNull((Object)dataOutput, (String)"dataOutput");
        Intrinsics.checkParameterIsNotNull(exposedDeclarations, (String)"exposedDeclarations");
        List<PsiStatement> variableDeclaration = !(flowOutput instanceof FlowOutput.ConditionalFlow) && dataOutput instanceof DataOutput.ExpressionOutput ? CollectionsKt.emptyList() : this.variableDeclaration(methodCall, dataOutput);
        Iterable iterable = exposedDeclarations;
        Collection collection2 = CollectionsKt.plus((Collection)variableDeclaration, (Iterable)this.createFlowStatements(methodCall, flowOutput, dataOutput));
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiVariable psiVariable = (PsiVariable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PsiDeclarationStatement psiDeclarationStatement = ExtractMethodHelper.INSTANCE.createDeclaration((PsiVariable)it);
            collection.add(psiDeclarationStatement);
        }
        collection = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
    }

    @NotNull
    public final List<PsiElement> buildExpressionCall(@NotNull String methodCall, @NotNull DataOutput dataOutput) {
        Intrinsics.checkParameterIsNotNull((Object)methodCall, (String)"methodCall");
        Intrinsics.checkParameterIsNotNull((Object)dataOutput, (String)"dataOutput");
        boolean bl = dataOutput instanceof DataOutput.ExpressionOutput;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String expression2 = ((DataOutput.ExpressionOutput)dataOutput).getName() != null ? ((DataOutput.ExpressionOutput)dataOutput).getName() + " = " + methodCall : methodCall;
        return CollectionsKt.listOf((Object)this.factory.createExpressionFromText(expression2, this.context));
    }

    public CallBuilder(@NotNull Project project, @Nullable PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.context = context;
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementFactory, (String)"PsiElementFactory.getInstance(project)");
        this.factory = psiElementFactory;
    }
}

