/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.PreviewPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;

public final class ExtractMethodPreviewManager {
    private final Project myProject;
    private ContentManager myContentManager;

    public ExtractMethodPreviewManager(Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = toolWindowManager.registerToolWindow("Extract Method", true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject);
            this.myContentManager = toolWindow.getContentManager();
            ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)this.myContentManager);
        });
    }

    public void showPreview(ExtractMethodProcessor processor2) {
        PsiFile psiFile = processor2.getElements()[0].getContainingFile();
        String title = (psiFile != null ? psiFile.getName() + ": " : "") + processor2.getMethodName() + "()";
        PreviewPanel panel2 = new PreviewPanel(processor2);
        Content content = this.myContentManager.getFactory().createContent((JComponent)((Object)panel2), title, true);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        panel2.setContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Extract Method").activate(panel2::initLater);
    }

    public void closeContent(Content content) {
        this.myContentManager.removeContent(content, true);
        content.release();
    }

    public static ExtractMethodPreviewManager getInstance(Project project) {
        return (ExtractMethodPreviewManager)ServiceManager.getService((Project)project, ExtractMethodPreviewManager.class);
    }
}

