/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractGeneratedClassUtil;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessorToEverything;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractLightMethodObjectHandler {
    public static final Key<PsiMethod> REFERENCE_METHOD = Key.create((String)"CompilingEvaluatorReferenceMethod");
    public static final Key<PsiType> REFERENCED_TYPE = Key.create((String)"CompilingEvaluatorReferencedType");
    private static final Logger LOG = Logger.getInstance(ExtractLightMethodObjectHandler.class);

    @Nullable
    public static ExtractedData extractLightMethodObject(Project project, @Nullable PsiElement originalContext, @NotNull PsiCodeFragment fragment, final @NotNull String methodName, @Nullable JavaSdkVersion javaVersion) throws PrepareFailedException {
        boolean useMagicAccessor;
        ControlFlow controlFlow;
        PsiExpression expr2;
        PsiElement firstElementCopy;
        PsiElement[] elementsCopy;
        PsiElement container;
        Object anchor;
        PsiLambdaExpression lambdaExpression;
        PsiClass containingClass;
        PsiElement elementAt;
        TextRange range;
        Object originalAnchor;
        PsiElement identifier;
        PsiNameIdentifierOwner identifierOwner;
        PsiElementFactory elementFactory;
        PsiElement[] elements;
        if (fragment == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(1);
        }
        if ((elements = ExtractLightMethodObjectHandler.completeToStatementArray(fragment, elementFactory = JavaPsiFacade.getElementFactory((Project)project))) == null) {
            elements = CodeInsightUtil.findStatementsInRange((PsiFile)fragment, 0, fragment.getTextLength());
        }
        if (elements.length == 0) {
            return null;
        }
        if (originalContext == null) {
            return null;
        }
        PsiFile file = originalContext.getContainingFile();
        PsiFile copy = PsiFileFactory.getInstance((Project)project).createFileFromText(file.getName(), file.getFileType(), (CharSequence)file.getText(), file.getModificationStamp(), false);
        if (originalContext instanceof PsiKeyword && "private".equals(originalContext.getText()) && (identifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)originalContext, PsiNameIdentifierOwner.class)) != null && (identifier = identifierOwner.getNameIdentifier()) != null) {
            originalContext = identifier;
        }
        if ((originalAnchor = CodeInsightUtil.findElementInRange(copy, (range = originalContext.getTextRange()).getStartOffset(), range.getEndOffset(), originalContext.getClass())) == null && (elementAt = copy.findElementAt(range.getStartOffset())) != null && elementAt.getClass() == originalContext.getClass()) {
            originalAnchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)elementAt);
        }
        if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType(originalAnchor, PsiClass.class, (boolean)false)) == null) {
            return null;
        }
        PsiElement containingMethod = PsiTreeUtil.getParentOfType(originalAnchor, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
        if (containingMethod instanceof PsiLambdaExpression && (lambdaExpression = (PsiLambdaExpression)containingMethod).getBody() instanceof PsiExpression) {
            PsiCodeBlock newBody = RefactoringUtil.expandExpressionLambdaToCodeBlock(lambdaExpression);
            originalAnchor = newBody.getStatements()[0];
        }
        if ((anchor = RefactoringUtil.getParentStatement(originalAnchor, false)) == null && PsiTreeUtil.getParentOfType(originalAnchor, PsiCodeBlock.class) != null) {
            anchor = originalAnchor;
        }
        if (anchor == null) {
            container = ((PsiClassInitializer)containingClass.add((PsiElement)elementFactory.createClassInitializer())).getBody();
            anchor = container.getLastChild();
        } else {
            container = anchor.getParent();
        }
        if (anchor instanceof PsiStatement && RefactoringUtil.isLoopOrIf(container)) {
            PsiBlockStatement codeBlockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("{}", container);
            codeBlockStatement.getCodeBlock().add(anchor);
            PsiCodeBlock codeBlock = ((PsiBlockStatement)anchor.replace((PsiElement)codeBlockStatement)).getCodeBlock();
            anchor = codeBlock.getStatements()[0];
            originalAnchor = anchor;
            container = codeBlock;
        }
        if ((elementsCopy = CodeInsightUtil.findStatementsInRange(copy, (firstElementCopy = container.addRangeBefore(elements[0], elements[elements.length - 1], anchor)).getTextRange().getStartOffset(), anchor.getTextRange().getStartOffset())).length == 0) {
            return null;
        }
        if (elementsCopy[elementsCopy.length - 1] instanceof PsiExpressionStatement && !((expr2 = ((PsiExpressionStatement)elementsCopy[elementsCopy.length - 1]).getExpression()) instanceof PsiAssignmentExpression)) {
            PsiType expressionType = GenericsUtil.getVariableTypeByExpressionType((PsiType)expr2.getType());
            if (expressionType instanceof PsiDisjunctionType) {
                expressionType = ((PsiDisjunctionType)expressionType).getLeastUpperBound();
            }
            if (ExtractLightMethodObjectHandler.isValidVariableType(expressionType)) {
                String uniqueResultName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("result", elementsCopy[0], true);
                String statementText = expressionType.getCanonicalText() + " " + uniqueResultName + " = " + expr2.getText() + ";";
                elementsCopy[elementsCopy.length - 1] = elementsCopy[elementsCopy.length - 1].replace((PsiElement)elementFactory.createStatementFromText(statementText, elementsCopy[elementsCopy.length - 1]));
            }
        }
        LOG.assertTrue(elementsCopy[0].getParent() == container, (Object)("element: " + elementsCopy[0].getText() + "; container: " + container.getText()));
        int startOffsetInContainer = elementsCopy[0].getStartOffsetInParent();
        try {
            controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(container, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        List variables = ControlFlowUtil.getUsedVariables(controlFlow, controlFlow.getStartOffset(elementsCopy[0]), controlFlow.getEndOffset(elementsCopy[elementsCopy.length - 1]));
        variables = ContainerUtil.filter(variables, variable -> {
            PsiElement variableScope = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
            return variableScope != null && PsiTreeUtil.isAncestor((PsiElement)variableScope, (PsiElement)elementsCopy[elementsCopy.length - 1], (boolean)true);
        });
        String outputVariables = StringUtil.join((Collection)variables, variable -> "\"variable: \" + " + variable.getName(), (String)" +");
        PsiStatement outStatement = elementFactory.createStatementFromText("System.out.println(" + outputVariables + ");", anchor);
        outStatement = (PsiStatement)container.addAfter((PsiElement)outStatement, elementsCopy[elementsCopy.length - 1]);
        boolean bl = useMagicAccessor = Registry.is((String)"debugger.compiling.evaluator.magic.accessor") && javaVersion != null && !javaVersion.isAtLeast(JavaSdkVersion.JDK_1_9);
        if (useMagicAccessor) {
            LOG.info("Magic accessor available");
            copy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                private void makePublic(PsiMember method) {
                    if (method.hasModifierProperty("private")) {
                        VisibilityUtil.setVisibility((PsiModifierList)method.getModifierList(), (String)"public");
                    }
                }

                public void visitMethod(PsiMethod method) {
                    super.visitMethod(method);
                    this.makePublic((PsiMember)method);
                }

                public void visitField(PsiField field) {
                    super.visitField(field);
                    this.makePublic((PsiMember)field);
                }
            });
        }
        ExtractMethodObjectProcessor extractMethodObjectProcessor = new ExtractMethodObjectProcessor(project, null, elementsCopy, ""){

            @Override
            protected AbstractExtractDialog createExtractMethodObjectDialog(ExtractMethodObjectProcessor.MyExtractMethodProcessor processor2) {
                return new LightExtractMethodObjectDialog(this, methodName);
            }

            @Override
            protected PsiElement addInnerClass(PsiClass containingClass, PsiClass innerClass) {
                return containingClass.addBefore((PsiElement)innerClass, containingClass.getLastChild());
            }

            @Override
            protected boolean isFoldingApplicable() {
                return false;
            }
        };
        extractMethodObjectProcessor.getExtractProcessor().setShowErrorDialogs(false);
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = extractMethodObjectProcessor.getExtractProcessor();
        if (extractProcessor.prepare()) {
            if (extractProcessor.showDialog()) {
                PsiMethod method;
                try {
                    extractProcessor.doExtract();
                    UsageInfo[] usages = extractMethodObjectProcessor.findUsages();
                    extractMethodObjectProcessor.performRefactoring(usages);
                    extractMethodObjectProcessor.runChangeSignature();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (extractMethodObjectProcessor.isCreateInnerClass()) {
                    extractMethodObjectProcessor.changeInstanceAccess(project);
                }
                LOG.assertTrue((method = extractMethodObjectProcessor.getMethod()) != null);
                method.delete();
            }
        } else {
            return null;
        }
        int startOffset = startOffsetInContainer + container.getTextRange().getStartOffset();
        PsiClass inner = extractMethodObjectProcessor.getInnerClass();
        PsiMethod[] methods = inner.findMethodsByName("invoke", false);
        boolean useReflection = javaVersion == null || javaVersion.isAtLeast(JavaSdkVersion.JDK_1_9) || Registry.is((String)"debugger.compiling.evaluator.reflection.access.with.java8");
        PsiClass generatedClass = extractMethodObjectProcessor.getInnerClass();
        if (useReflection && methods.length == 1) {
            PsiMethod method = methods[0];
            PsiMethodCallExpression callExpression = ExtractLightMethodObjectHandler.findCallExpression(copy, method);
            if (callExpression != null) {
                boolean isJdkAtLeast11;
                LOG.info("Use reflection to evaluate inaccessible members");
                new ReflectionAccessorToEverything(generatedClass, elementFactory).grantAccessThroughReflection(callExpression);
                boolean bl2 = isJdkAtLeast11 = javaVersion == null || javaVersion.isAtLeast(JavaSdkVersion.JDK_11);
                if (isJdkAtLeast11 || Registry.is((String)"debugger.compiling.evaluator.extract.generated.class")) {
                    generatedClass = ExtractGeneratedClassUtil.extractGeneratedClass(generatedClass, elementFactory, anchor);
                }
            } else {
                LOG.warn("Generated method call expression not found");
            }
        }
        String generatedCall = copy.getText().substring(startOffset, outStatement.getTextOffset());
        return new ExtractedData(generatedCall, (PsiClass)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)generatedClass), (PsiElement)originalAnchor, useMagicAccessor);
    }

    @Nullable
    private static PsiMethodCallExpression findCallExpression(@NotNull PsiFile copy, final @NotNull PsiMethod method) {
        if (copy == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(2);
        }
        if (method == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(3);
        }
        final PsiMethodCallExpression[] result = new PsiMethodCallExpression[1];
        copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                if (method.equals(expression2.resolveMethod())) {
                    if (result[0] != null) {
                        LOG.error("To many generated method invocations found");
                    } else {
                        result[0] = expression2;
                    }
                }
            }
        });
        return result[0];
    }

    private static PsiElement @Nullable [] completeToStatementArray(PsiCodeFragment fragment, PsiElementFactory elementFactory) {
        PsiExpression expression2 = CodeInsightUtil.findExpressionInRange((PsiFile)fragment, 0, fragment.getTextLength());
        if (expression2 != null) {
            String completeExpressionText = null;
            if (expression2 instanceof PsiArrayInitializerExpression) {
                PsiType type2;
                PsiExpression[] initializers = ((PsiArrayInitializerExpression)expression2).getInitializers();
                if (initializers.length > 0 && (type2 = initializers[0].getType()) != null) {
                    completeExpressionText = "new " + type2.getCanonicalText() + "[]" + expression2.getText();
                }
            } else {
                completeExpressionText = expression2.getText();
            }
            if (completeExpressionText != null) {
                return new PsiElement[]{elementFactory.createStatementFromText(completeExpressionText + ";", (PsiElement)expression2)};
            }
        }
        return null;
    }

    private static boolean isValidVariableType(PsiType type2) {
        return type2 instanceof PsiClassType || type2 instanceof PsiArrayType || type2 instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractLightMethodObject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LightExtractMethodObjectDialog
    implements AbstractExtractDialog {
        private final ExtractMethodObjectProcessor myProcessor;
        @NotNull
        private final String myMethodName;

        LightExtractMethodObjectDialog(ExtractMethodObjectProcessor processor2, @NotNull String methodName) {
            if (methodName == null) {
                LightExtractMethodObjectDialog.$$$reportNull$$$0(0);
            }
            this.myProcessor = processor2;
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getChosenMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                LightExtractMethodObjectDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public VariableData[] getChosenParameters() {
            InputVariables inputVariables = this.myProcessor.getExtractProcessor().getInputVariables();
            return inputVariables.getInputVariables().toArray(new VariableData[0]);
        }

        @Override
        @NotNull
        public String getVisibility() {
            return "packageLocal";
        }

        @Override
        public boolean isMakeStatic() {
            return this.myProcessor.getExtractProcessor().isCanBeStatic() && !this.myProcessor.getExtractProcessor().getInputVariables().hasInstanceFields();
        }

        @Override
        public boolean isChainedConstructor() {
            return false;
        }

        @Override
        public PsiType getReturnType() {
            return null;
        }

        @Override
        public void show() {
        }

        @Override
        public boolean isOK() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler$LightExtractMethodObjectDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler$LightExtractMethodObjectDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChosenMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ExtractedData {
        private final String myGeneratedCallText;
        private final PsiClass myGeneratedInnerClass;
        private final PsiElement myAnchor;
        private final boolean myUseMagicAccessor;

        public ExtractedData(String generatedCallText, PsiClass generatedInnerClass, PsiElement anchor, boolean useMagicAccessor) {
            this.myGeneratedCallText = generatedCallText;
            this.myGeneratedInnerClass = generatedInnerClass;
            this.myAnchor = anchor;
            this.myUseMagicAccessor = useMagicAccessor;
        }

        public PsiElement getAnchor() {
            return this.myAnchor;
        }

        public String getGeneratedCallText() {
            return this.myGeneratedCallText;
        }

        public PsiClass getGeneratedInnerClass() {
            return this.myGeneratedInnerClass;
        }

        public boolean useMagicAccessor() {
            return this.myUseMagicAccessor;
        }
    }
}

