/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.extractSuperclass.BindToOldUsageInfo;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassViewDescriptor;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessorBase;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class ExtractSuperBaseProcessor
extends TurnRefsToSuperProcessorBase {
    private static final Logger LOG = Logger.getInstance(ExtractSuperClassProcessor.class);
    protected PsiDirectory myTargetDirectory;
    protected final String myNewClassName;
    protected final MemberInfo[] myMemberInfos;
    protected final DocCommentPolicy myJavaDocPolicy;

    public ExtractSuperBaseProcessor(Project project, boolean replaceInstanceOf, PsiDirectory targetDirectory, String newClassName, PsiClass aClass, MemberInfo[] memberInfos, DocCommentPolicy javaDocPolicy) {
        super(project, replaceInstanceOf, newClassName);
        this.myTargetDirectory = targetDirectory;
        this.myNewClassName = newClassName;
        this.myClass = aClass;
        this.myMemberInfos = memberInfos;
        this.myJavaDocPolicy = javaDocPolicy;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ExtractSuperBaseProcessor.$$$reportNull$$$0(0);
        }
        return new ExtractSuperClassViewDescriptor(this.myTargetDirectory, this.myClass, this.myMemberInfos);
    }

    protected boolean doesAnyExtractedInterfaceExtends(PsiClass aClass) {
        for (MemberInfo memberInfo : this.myMemberInfos) {
            PsiElement member = memberInfo.getMember();
            if (!(member instanceof PsiClass) || memberInfo.getOverrides() == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)member), (PsiClass)aClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    protected boolean doMemberInfosContain(PsiMethod method) {
        for (MemberInfo info : this.myMemberInfos) {
            PsiMethod methodBySignature;
            if (!(info.getMember() instanceof PsiMethod ? MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)((PsiMethod)info.getMember())) : info.getMember() instanceof PsiClass && info.getOverrides() != null && (methodBySignature = ((PsiClass)info.getMember()).findMethodBySignature(method, true)) != null)) continue;
            return true;
        }
        return false;
    }

    protected boolean doMemberInfosContain(PsiField field) {
        for (MemberInfo info : this.myMemberInfos) {
            if (!this.myManager.areElementsEquivalent((PsiElement)field, info.getMember())) continue;
            return true;
        }
        return false;
    }

    protected UsageInfo @NotNull [] findUsages() {
        PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        this.detectTurnToSuperRefs(refs, result);
        PsiPackage originalPackage = JavaDirectoryService.getInstance().getPackage(this.myClass.getContainingFile().getContainingDirectory());
        if (Comparing.equal((Object)JavaDirectoryService.getInstance().getPackage(this.myTargetDirectory), (Object)originalPackage)) {
            result.clear();
        }
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (this.canTurnToSuper(element) || RefactoringUtil.inImportStatement(ref, element)) continue;
            result.add((UsageInfo)new BindToOldUsageInfo(element, ref, this.myClass));
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            ExtractSuperBaseProcessor.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ExtractSuperBaseProcessor.$$$reportNull$$$0(2);
        }
        try {
            String superClassName = this.myClass.getName();
            String oldQualifiedName = this.myClass.getQualifiedName();
            this.myClass.setName(this.myNewClassName);
            PsiClass superClass = this.extractSuper(superClassName);
            PsiDirectory initialDirectory = this.myClass.getContainingFile().getContainingDirectory();
            PsiFile containingFile = this.myClass.getContainingFile();
            try {
                if (this.myTargetDirectory != initialDirectory) {
                    containingFile = (PsiFile)this.myTargetDirectory.add(this.myClass.getContainingFile().copy());
                    this.myClass.getContainingFile().delete();
                }
            }
            catch (IncorrectOperationException e) {
                RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
            }
            for (UsageInfo usage : usages) {
                PsiReference reference;
                if (!(usage instanceof BindToOldUsageInfo) || (reference = usage.getReference()) == null || !reference.getElement().isValid()) continue;
                reference.bindToElement((PsiElement)this.myClass);
            }
            if (!Objects.equals(oldQualifiedName, superClass.getQualifiedName())) {
                ExtractSuperBaseProcessor.processTurnToSuperRefs(usages, superClass);
            }
            if (containingFile instanceof PsiJavaFile) {
                JavaCodeStyleManager.getInstance((Project)this.myProject).removeRedundantImports((PsiJavaFile)containingFile);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.performVariablesRenaming();
    }

    protected abstract PsiClass extractSuper(String var1) throws IncorrectOperationException;

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ExtractSuperBaseProcessor.$$$reportNull$$$0(3);
        }
        this.myClass = (PsiClass)elements[0];
        this.myTargetDirectory = (PsiDirectory)elements[1];
        for (int i = 0; i < this.myMemberInfos.length; ++i) {
            MemberInfo info = this.myMemberInfos[i];
            info.updateMember((PsiElement)((PsiMember)elements[i + 2]));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"extract.subclass.command", (Object[])new Object[0]);
        if (string == null) {
            ExtractSuperBaseProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            ExtractSuperBaseProcessor.$$$reportNull$$$0(5);
        }
        List<PsiElement> list = ((ExtractSuperClassViewDescriptor)descriptor).getMembersToMakeWritable();
        if (list == null) {
            ExtractSuperBaseProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractSuperclass/ExtractSuperBaseProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractSuperclass/ExtractSuperBaseProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

