/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.extractSuperclass.JavaExtractSuperBaseDialog;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.UsesAndInterfacesDependencyMemberInfoModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class ExtractSuperclassDialog
extends JavaExtractSuperBaseDialog {
    private final InterfaceContainmentVerifier myContainmentVerifier = new InterfaceContainmentVerifier(){

        @Override
        public boolean checkedInterfacesContain(PsiMethod psiMethod) {
            return PullUpProcessor.checkedInterfacesContain(ExtractSuperclassDialog.this.getMemberInfos(), psiMethod);
        }
    };
    private final Callback myCallback;

    ExtractSuperclassDialog(Project project, PsiClass sourceClass, List<MemberInfo> selectedMembers, Callback callback) {
        super(project, sourceClass, selectedMembers, ExtractSuperclassHandler.getRefactoringName());
        this.myCallback = callback;
        this.init();
    }

    InterfaceContainmentVerifier getContainmentVerifier() {
        return this.myContainmentVerifier;
    }

    private List<MemberInfo> getMemberInfos() {
        return this.myMemberInfos;
    }

    protected String getClassNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"superclass.name") : JavaRefactoringBundle.message((String)"extractSuper.rename.original.class.to", (Object[])new Object[0]);
    }

    protected String getPackageNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"package.for.new.superclass") : RefactoringBundle.message((String)"package.for.original.class");
    }

    @NotNull
    protected String getEntityName() {
        String string = RefactoringBundle.message((String)"ExtractSuperClass.superclass");
        if (string == null) {
            ExtractSuperclassDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected String getTopLabelText() {
        return RefactoringBundle.message((String)"extract.superclass.from");
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.form.superclass"), this.myMemberInfos, RefactoringBundle.message((String)"make.abstract"));
        panel2.add((Component)((Object)memberSelectionPanel), "Center");
        UsesAndInterfacesDependencyMemberInfoModel<PsiMember, MemberInfo> memberInfoModel = new UsesAndInterfacesDependencyMemberInfoModel<PsiMember, MemberInfo>((PsiClass)this.mySourceClass, null, false, this.myContainmentVerifier){

            public Boolean isFixedAbstract(MemberInfo member) {
                return Boolean.TRUE;
            }
        };
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        panel2.add((Component)this.myDocCommentPanel, "East");
        return panel2;
    }

    protected String getDocCommentPanelName() {
        return JavaRefactoringBundle.message((String)"javadoc.for.abstracts", (Object[])new Object[0]);
    }

    protected String getExtractedSuperNameNotSpecifiedMessage() {
        return RefactoringBundle.message((String)"no.superclass.name.specified");
    }

    protected boolean checkConflicts() {
        return this.myCallback.checkConflicts(this);
    }

    protected int getDocCommentPolicySetting() {
        return JavaRefactoringSettings.getInstance().EXTRACT_SUPERCLASS_JAVADOC;
    }

    protected void setDocCommentPolicySetting(int policy) {
        JavaRefactoringSettings.getInstance().EXTRACT_SUPERCLASS_JAVADOC = policy;
    }

    protected ExtractSuperBaseProcessor createProcessor() {
        return new ExtractSuperClassProcessor(this.myProject, this.getTargetDirectory(), this.getExtractedSuperName(), (PsiClass)this.mySourceClass, this.getSelectedMemberInfos().toArray(new MemberInfo[0]), false, new DocCommentPolicy(this.getDocCommentPolicy()));
    }

    protected String getHelpId() {
        return "refactoring.extractSuperclass";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractSuperclass/ExtractSuperclassDialog", "getEntityName"));
    }

    public static interface Callback {
        public boolean checkConflicts(ExtractSuperclassDialog var1);
    }
}

