/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import java.util.List;

public class EnumTypeConversionRule
extends TypeConversionRule {
    private final List<PsiField> myEnumConstants;

    public EnumTypeConversionRule(List<PsiField> enumConstants) {
        this.myEnumConstants = enumConstants;
    }

    @Override
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiMethod constructor;
        PsiParameter[] parameters2;
        PsiMethod[] constructors;
        SearchScope searchScope;
        PsiMethod resolved;
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethodCallExpression.class, (boolean)false);
        if (callExpression != null && (resolved = callExpression.resolveMethod()) != null && !PsiSearchScopeUtil.isInScope((SearchScope)(searchScope = labeler.getRules().getSearchScope()), (PsiElement)resolved)) {
            return null;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)context, PsiField.class);
        if (field != null && !this.myEnumConstants.contains(field) && field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasInitializer()) {
            return null;
        }
        PsiClass toClass = PsiUtil.resolveClassInType((PsiType)to);
        if (toClass != null && toClass.isEnum() && (constructors = toClass.getConstructors()).length == 1 && (parameters2 = (constructor = constructors[0]).getParameterList().getParameters()).length == 1 && TypeConversionUtil.isAssignable((PsiType)parameters2[0].getType(), (PsiType)from)) {
            return new TypeConversionDescriptorBase();
        }
        return null;
    }
}

