/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;

public abstract class AbstractInplaceIntroduceFieldPopup
extends AbstractJavaInplaceIntroducer {
    private final SmartPsiElementPointer<PsiClass> myParentClass;
    protected final OccurrenceManager myOccurrenceManager;
    private final SmartPsiElementPointer<PsiElement> myAnchorElement;
    private int myAnchorIdx = -1;
    private final SmartPsiElementPointer<PsiElement> myAnchorElementIfAll;
    private int myAnchorIdxIfAll = -1;
    protected RangeMarker myFieldRangeStart;

    public AbstractInplaceIntroduceFieldPopup(Project project, Editor editor, PsiExpression expr2, PsiVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, String title, PsiClass parentClass, PsiElement anchorElement, OccurrenceManager occurrenceManager, PsiElement anchorElementIfAll) {
        super(project, editor, expr2, localVariable, occurrences, typeSelectorManager, title);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.myParentClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)parentClass);
        this.myOccurrenceManager = occurrenceManager;
        this.myAnchorElement = anchorElement != null ? smartPointerManager.createSmartPsiElementPointer(anchorElement) : null;
        this.myAnchorElementIfAll = anchorElementIfAll != null ? smartPointerManager.createSmartPsiElementPointer(anchorElementIfAll) : null;
        int occurrencesLength = occurrences.length;
        for (int i = 0; i < occurrencesLength; ++i) {
            PsiExpression occurrence = occurrences[i];
            PsiElement parent = occurrence.getParent();
            if (parent == anchorElement) {
                this.myAnchorIdx = i;
            }
            if (parent != anchorElementIfAll) continue;
            this.myAnchorIdxIfAll = i;
        }
    }

    protected PsiElement checkLocalScope() {
        return this.getParentClass();
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return new LocalSearchScope((PsiElement)this.getParentClass());
    }

    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return super.startsOnTheSameElement(handler, element) || this.getParentClass() != null && element instanceof PsiLocalVariable && this.getParentClass().findFieldByName(((PsiLocalVariable)element).getName(), false) != null;
    }

    protected PsiElement getAnchorElement() {
        if (this.myAnchorIdx != -1 && ((PsiExpression[])this.myOccurrences)[this.myAnchorIdx] != null) {
            return ((PsiExpression[])this.myOccurrences)[this.myAnchorIdx].getParent();
        }
        return this.myAnchorElement != null ? this.myAnchorElement.getElement() : null;
    }

    protected PsiElement getAnchorElementIfAll() {
        if (this.myAnchorIdxIfAll != -1 && ((PsiExpression[])this.myOccurrences)[this.myAnchorIdxIfAll] != null) {
            return ((PsiExpression[])this.myOccurrences)[this.myAnchorIdxIfAll].getParent();
        }
        return this.myAnchorElementIfAll != null ? this.myAnchorElementIfAll.getElement() : null;
    }

    protected PsiVariable getVariable() {
        if (this.myFieldRangeStart == null) {
            return null;
        }
        PsiClass parentClass = this.getParentClass();
        if (parentClass == null || !parentClass.isValid()) {
            return null;
        }
        PsiElement element = parentClass.getContainingFile().findElementAt(this.myFieldRangeStart.getStartOffset());
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        }
        if (element instanceof PsiField) {
            return (PsiVariable)element;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
        if (field != null) {
            return field;
        }
        element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        return (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
    }

    protected PsiClass getParentClass() {
        return (PsiClass)this.myParentClass.getElement();
    }
}

