/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterUI;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.JavaIntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceIntroduceParameterPopup
extends AbstractJavaInplaceIntroducer {
    private final PsiMethod myMethod;
    private final PsiMethod myMethodToSearchFor;
    private final boolean myMustBeFinal;
    private int myParameterIndex = -1;
    private final InplaceIntroduceParameterUI myPanel;

    InplaceIntroduceParameterPopup(Project project, Editor editor, TypeSelectorManagerImpl typeSelectorManager, PsiExpression expr2, PsiLocalVariable localVar, PsiMethod method, PsiMethod methodToSearchFor, PsiExpression[] occurrences, TIntArrayList parametersToRemove, boolean mustBeFinal) {
        super(project, editor, expr2, (PsiVariable)localVar, occurrences, typeSelectorManager, IntroduceParameterHandler.getRefactoringName());
        this.myMethod = method;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myMustBeFinal = mustBeFinal;
        this.myWholePanel.add((Component)this.getPreviewComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.create((int)0, (int)5), 0, 0));
        this.myPanel = new InplaceIntroduceParameterUI(project, localVar, expr2, method, parametersToRemove, typeSelectorManager, (PsiExpression[])this.myOccurrences){

            @Override
            protected PsiParameter getParameter() {
                return InplaceIntroduceParameterPopup.this.getParameter();
            }

            @Override
            protected void updateControls(JCheckBox[] removeParamsCb) {
                super.updateControls(removeParamsCb);
                if (InplaceIntroduceParameterPopup.this.myParameterIndex < 0) {
                    return;
                }
                InplaceIntroduceParameterPopup.this.restartInplaceIntroduceTemplate();
            }

            @Override
            protected TIntArrayList getParametersToRemove() {
                TIntArrayList parameters2 = new TIntArrayList();
                if (this.myCbReplaceAllOccurences == null || this.myCbReplaceAllOccurences.isSelected()) {
                    for (int i = 0; i < this.myParametersToRemove.length; ++i) {
                        if (this.myParametersToRemove[i] == null) continue;
                        parameters2.add(i);
                    }
                }
                return parameters2;
            }
        };
        this.myPanel.appendOccurrencesDelegate(this.myWholePanel);
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(String[] names2, PsiType defaultType) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
        return (PsiVariable)WriteAction.compute(() -> {
            PsiParameter anchor = JavaIntroduceParameterMethodUsagesProcessor.getAnchorParameter(this.myMethod);
            PsiParameter psiParameter = (PsiParameter)this.myMethod.getParameterList().addAfter((PsiElement)elementFactory.createParameter(this.chooseName(names2, this.myMethod.getLanguage()), defaultType), (PsiElement)anchor);
            PsiUtil.setModifierProperty((PsiModifierListOwner)psiParameter, (String)"final", (boolean)this.myPanel.hasFinalModifier());
            this.myParameterIndex = this.myMethod.getParameterList().getParameterIndex(psiParameter);
            return psiParameter;
        });
    }

    protected PsiElement checkLocalScope() {
        return this.myMethod;
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return new LocalSearchScope((PsiElement)this.myMethod);
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.PARAMETER;
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return IntroduceParameterHandler.createNameSuggestionGenerator((PsiExpression)((PsiExpression)this.myExpr), (String)propName, (Project)this.myProject, null).getSuggestedNameInfo((PsiType)defaultType).names;
    }

    @Nullable
    private PsiParameter getParameter() {
        if (!this.myMethod.isValid()) {
            return null;
        }
        PsiParameter[] parameters2 = this.myMethod.getParameterList().getParameters();
        return parameters2.length > this.myParameterIndex && this.myParameterIndex >= 0 ? parameters2[this.myParameterIndex] : null;
    }

    protected JComponent getComponent() {
        return this.myWholePanel;
    }

    public boolean isReplaceAllOccurrences() {
        return this.myPanel.isReplaceAllOccurences();
    }

    protected PsiVariable getVariable() {
        return this.getParameter();
    }

    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return handler instanceof IntroduceParameterHandler && super.startsOnTheSameElement(handler, element);
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            InplaceIntroduceParameterPopup.$$$reportNull$$$0(0);
        }
        this.myPanel.saveSettings(JavaRefactoringSettings.getInstance());
    }

    protected void performIntroduce() {
        boolean isDeleteLocalVariable = false;
        PsiExpression parameterInitializer = (PsiExpression)this.myExpr;
        if (this.getLocalVariable() != null) {
            if (this.myPanel.isUseInitializer()) {
                parameterInitializer = ((PsiVariable)this.getLocalVariable()).getInitializer();
            }
            isDeleteLocalVariable = this.myPanel.isDeleteLocalVariable();
        }
        TIntArrayList parametersToRemove = this.myPanel.getParametersToRemove();
        IntroduceParameterProcessor processor2 = new IntroduceParameterProcessor(this.myProject, this.myMethod, this.myMethodToSearchFor, parameterInitializer, (PsiExpression)this.myExpr, (PsiLocalVariable)this.getLocalVariable(), isDeleteLocalVariable, this.getInputName(), this.myPanel.isReplaceAllOccurences(), this.myPanel.getReplaceFieldsWithGetters(), this.myMustBeFinal || this.myPanel.isGenerateFinal(), this.isGenerateDelegate(), this.getType(), parametersToRemove);
        Runnable runnable = () -> {
            Runnable performRefactoring = () -> {
                processor2.setPrepareSuccessfulSwingThreadCallback(() -> {});
                processor2.run();
                this.normalizeParameterIdxAccordingToRemovedParams(parametersToRemove);
                PsiParameter parameter2 = this.getParameter();
                if (parameter2 != null) {
                    super.saveSettings((PsiVariable)parameter2);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                performRefactoring.run();
            } else {
                ApplicationManager.getApplication().invokeLater(performRefactoring, this.myProject.getDisposed());
            }
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, runnable, this.getCommandName(), null);
    }

    public boolean isGenerateDelegate() {
        return this.myPanel.isGenerateDelegate();
    }

    protected void updateTitle(@Nullable PsiVariable variable) {
        if (variable == null) {
            return;
        }
        this.updateTitle(variable, variable.getName());
    }

    protected void updateTitle(@Nullable PsiVariable variable, String value2) {
        PsiElement declarationScope;
        PsiElement psiElement = declarationScope = variable != null ? ((PsiParameter)variable).getDeclarationScope() : null;
        if (declarationScope instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            StringBuilder buf = new StringBuilder();
            buf.append(psiMethod.getName()).append(" (");
            boolean frst = true;
            ArrayList<TextRange> ranges2Remove = new ArrayList<TextRange>();
            TextRange addedRange = null;
            for (PsiParameter parameter2 : psiMethod.getParameterList().getParameters()) {
                if (frst) {
                    frst = false;
                } else {
                    buf.append(", ");
                }
                int startOffset = buf.length();
                if (this.myMustBeFinal || this.myPanel.isGenerateFinal()) {
                    buf.append("final ");
                }
                buf.append(parameter2.getType().getPresentableText()).append(" ").append(variable == parameter2 ? value2 : parameter2.getName());
                int endOffset = buf.length();
                if (variable == parameter2) {
                    addedRange = new TextRange(startOffset, endOffset);
                    continue;
                }
                if (!this.myPanel.isParamToRemove(parameter2)) continue;
                ranges2Remove.add(new TextRange(startOffset, endOffset));
            }
            buf.append(")");
            this.setPreviewText(buf.toString());
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.getPreviewEditor().getDocument(), (Project)this.myProject, (boolean)true);
            markupModel.removeAllHighlighters();
            for (TextRange textRange : ranges2Remove) {
                markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 0, InplaceIntroduceParameterPopup.getTestAttributesForRemoval(), HighlighterTargetArea.EXACT_RANGE);
            }
            markupModel.addRangeHighlighter(addedRange.getStartOffset(), addedRange.getEndOffset(), 0, InplaceIntroduceParameterPopup.getTextAttributesForAdd(), HighlighterTargetArea.EXACT_RANGE);
            this.revalidate();
        }
    }

    private static TextAttributes getTextAttributesForAdd() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setEffectType(EffectType.ROUNDED_BOX);
        textAttributes.setEffectColor((Color)JBColor.RED);
        return textAttributes;
    }

    private static TextAttributes getTestAttributesForRemoval() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setEffectType(EffectType.STRIKEOUT);
        textAttributes.setEffectColor((Color)JBColor.BLACK);
        return textAttributes;
    }

    protected String getActionName() {
        return "IntroduceParameter";
    }

    private void normalizeParameterIdxAccordingToRemovedParams(TIntArrayList parametersToRemove) {
        parametersToRemove.forEach(value2 -> {
            if (this.myParameterIndex >= value2) {
                --this.myParameterIndex;
            }
            return true;
        });
    }

    public void setReplaceAllOccurrences(boolean replaceAll) {
        this.myPanel.setReplaceAllOccurrences(replaceAll);
    }

    public PsiMethod getMethodToIntroduceParameter() {
        return this.myMethod;
    }

    public PsiMethod getMethodToSearchFor() {
        return this.myMethodToSearchFor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/introduceParameter/InplaceIntroduceParameterPopup", "saveSettings"));
    }
}

