/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveJavaMemberHandler
implements MoveMemberHandler {
    @Override
    @Nullable
    public MoveMembersProcessor.MoveMembersUsageInfo getUsage(@NotNull PsiMember member, @NotNull PsiReference psiReference, @NotNull Set<PsiMember> membersToMove, @NotNull PsiClass targetClass) {
        PsiElement ref;
        if (member == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(0);
        }
        if (psiReference == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(1);
        }
        if (membersToMove == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(2);
        }
        if (targetClass == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(3);
        }
        if ((ref = psiReference.getElement()) instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refExpr, membersToMove, targetClass, true)) {
                if (!RefactoringUtil.isInMovedElement((PsiElement)refExpr, membersToMove)) {
                    if (qualifier != null) {
                        return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, null, (PsiElement)qualifier, psiReference);
                    }
                } else if (qualifier instanceof PsiReferenceExpression && member.getContainingClass() != null && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)member.getContainingClass())) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
                }
            } else {
                if (qualifier == null) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)refExpr, psiReference);
                }
                return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
            }
        }
        return null;
    }

    @Override
    public void checkConflictsOnUsage(@NotNull MoveMembersProcessor.MoveMembersUsageInfo usageInfo, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MoveMembersOptions moveMembersOptions, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiReference reference;
        PsiElement element;
        if (usageInfo == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(4);
        }
        if (targetClass == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(5);
        }
        if (membersToMove == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(6);
        }
        if (moveMembersOptions == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(7);
        }
        if (conflicts == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(8);
        }
        if ((element = usageInfo.getElement()) == null) {
            return;
        }
        PsiMember member = usageInfo.member;
        if (element instanceof PsiReferenceExpression) {
            PsiExpression qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
            PsiClass accessObjectClass = null;
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
            }
            if (!JavaResolveUtil.isAccessible(member, targetClass, modifierListCopy, element, accessObjectClass, null)) {
                String newVisibility = moveMembersOptions.getExplicitMemberVisibility();
                String visibility = newVisibility != null ? newVisibility : VisibilityUtil.getVisibilityStringToDisplay((PsiMember)member);
                String message2 = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), visibility, RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element), (boolean)true)});
                conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message2));
            }
        }
        if (member instanceof PsiField && targetClass.isInterface()) {
            ReadWriteAccessDetector.Access access;
            ReadWriteAccessDetector accessDetector = ReadWriteAccessDetector.findDetector((PsiElement)member);
            if (accessDetector != null && (access = accessDetector.getExpressionAccess(element)) != ReadWriteAccessDetector.Access.Read) {
                String message3 = RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true) + " has write access but is moved to an interface";
                conflicts.putValue((Object)element, (Object)CommonRefactoringUtil.capitalize((String)message3));
            }
        } else if (member instanceof PsiField && usageInfo.reference instanceof PsiExpression && member.hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)usageInfo.reference)) && !RefactoringHierarchyUtil.willBeInTargetClass(usageInfo.reference, membersToMove, targetClass, true)) {
            conflicts.putValue((Object)usageInfo.member, (Object)"final variable initializer won't be available after move.");
        }
        if (MoveJavaMemberHandler.toBeConvertedToEnum(moveMembersOptions, member, targetClass) && !MoveJavaMemberHandler.isEnumAcceptable(element, targetClass)) {
            conflicts.putValue((Object)element, (Object)"Enum type won't be applicable in the current context");
        }
        if ((reference = usageInfo.getReference()) != null) {
            RefactoringConflictsUtil.checkAccessibilityConflicts(reference, member, modifierListCopy, targetClass, membersToMove, conflicts);
        }
    }

    private static boolean isEnumAcceptable(PsiElement element, PsiClass targetClass) {
        ExpectedTypeInfo[] types;
        if (element instanceof PsiExpression && (types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)element, false)).length == 1) {
            PsiType type2 = types[0].getType();
            return type2.isAssignableFrom((PsiType)JavaPsiFacade.getElementFactory((Project)element.getProject()).createType(targetClass));
        }
        return false;
    }

    @Override
    public void checkConflictsOnMember(@NotNull PsiMember member, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(9);
        }
        if (targetClass == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(10);
        }
        if (membersToMove == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(11);
        }
        if (conflicts == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(12);
        }
        if (member instanceof PsiMethod && MoveJavaMemberHandler.hasMethod(targetClass, (PsiMethod)member) || member instanceof PsiField && MoveJavaMemberHandler.hasField(targetClass, (PsiField)member)) {
            String message2 = RefactoringBundle.message((String)"0.already.exists.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message2));
        }
        RefactoringConflictsUtil.checkUsedElements(member, (PsiElement)member, membersToMove, null, targetClass, (PsiElement)targetClass, conflicts);
    }

    protected static boolean hasMethod(PsiClass targetClass, PsiMethod method) {
        PsiMethod[] targetClassMethods;
        for (PsiMethod candidate : targetClassMethods = targetClass.findMethodsByName(method.getName(), true)) {
            if (candidate == method || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)method.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)candidate.getSignature(PsiSubstitutor.EMPTY))) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasField(PsiClass targetClass, PsiField field) {
        PsiField fieldByName = targetClass.findFieldByName(field.getName(), true);
        return fieldByName != null && fieldByName != field;
    }

    @Override
    public boolean changeExternalUsage(@NotNull MoveMembersOptions options, @NotNull MoveMembersProcessor.MoveMembersUsageInfo usage) {
        PsiElement element;
        if (options == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(13);
        }
        if (usage == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(14);
        }
        if ((element = usage.getElement()) == null || !element.isValid()) {
            return true;
        }
        if (usage.reference instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)usage.reference;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier != null) {
                if (usage.qualifierClass != null && PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiSwitchLabelStatement.class) == null) {
                    MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
                } else {
                    Project project = element.getProject();
                    PsiClass targetClass = JavaPsiFacade.getInstance((Project)project).findClass(options.getTargetClassName(), element.getResolveScope());
                    if (targetClass != null) {
                        PsiReferenceParameterList parameterList = refExpr.getParameterList();
                        if ((targetClass.isEnum() || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)element, (boolean)true)) && parameterList != null && parameterList.getTypeArguments().length == 0 && !(refExpr instanceof PsiMethodReferenceExpression)) {
                            refExpr.setQualifierExpression(null);
                        } else {
                            MoveJavaMemberHandler.changeQualifier(refExpr, targetClass, usage.member);
                        }
                    }
                }
            } else if (!(usage.qualifierClass == null || usage.qualifierClass.isEnum() && PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiSwitchLabelStatement.class) != null)) {
                MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
            }
            return true;
        }
        return false;
    }

    protected static void changeQualifier(PsiReferenceExpression refExpr, PsiClass aClass, PsiMember member) throws IncorrectOperationException {
        if (RefactoringUtil.hasOnDemandStaticImport((PsiElement)refExpr, aClass) && !(refExpr instanceof PsiMethodReferenceExpression)) {
            refExpr.setQualifierExpression(null);
        } else if (!ImportsUtil.hasStaticImportOn((PsiElement)refExpr, (PsiMember)member, (boolean)false) || refExpr.getQualifierExpression() != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)refExpr.getProject());
            refExpr.setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
        }
    }

    @Override
    @NotNull
    public PsiMember doMove(@NotNull MoveMembersOptions options, @NotNull PsiMember member, PsiElement anchor, @NotNull PsiClass targetClass) {
        PsiMember memberCopy;
        if (options == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(15);
        }
        if (member == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(16);
        }
        if (targetClass == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(17);
        }
        if (member instanceof PsiVariable) {
            ((PsiVariable)member).normalizeDeclaration();
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)member, true);
        if (MoveJavaMemberHandler.toBeConvertedToEnum(options, member, targetClass)) {
            memberCopy = EnumConstantsUtil.createEnumConstant(targetClass, member.getName(), ((PsiVariable)member).getInitializer());
        } else {
            memberCopy = (PsiMember)member.copy();
            PsiClass containingClass = member.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !targetClass.isInterface()) {
                PsiModifierList list = memberCopy.getModifierList();
                assert (list != null);
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
            }
        }
        member.delete();
        PsiMember psiMember = anchor != null ? (PsiMember)targetClass.addAfter((PsiElement)memberCopy, anchor) : (PsiMember)targetClass.add((PsiElement)memberCopy);
        if (psiMember == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(18);
        }
        return psiMember;
    }

    private static boolean toBeConvertedToEnum(@NotNull MoveMembersOptions options, @NotNull PsiMember member, @NotNull PsiClass targetClass) {
        if (options == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(19);
        }
        if (member == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(20);
        }
        if (targetClass == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(21);
        }
        return options.makeEnumConstant() && member instanceof PsiVariable && EnumConstantsUtil.isSuitableForEnumConstant(((PsiVariable)member).getType(), targetClass);
    }

    @Override
    public void decodeContextInfo(@NotNull PsiElement scope) {
        if (scope == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(22);
        }
        ChangeContextUtil.decodeContextInfo(scope, null, null);
    }

    @Override
    @Nullable
    public PsiElement getAnchor(@NotNull PsiMember member, final @NotNull PsiClass targetClass, final Set<PsiMember> membersToMove) {
        if (member == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(23);
        }
        if (targetClass == null) {
            MoveJavaMemberHandler.$$$reportNull$$$0(24);
        }
        if (member instanceof PsiField && member.hasModifierProperty("static")) {
            final ArrayList afterFields = new ArrayList();
            PsiExpression psiExpression = ((PsiField)member).getInitializer();
            if (psiExpression != null) {
                psiExpression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        PsiField psiField;
                        super.visitReferenceExpression(expression2);
                        PsiElement psiElement = expression2.resolve();
                        if (psiElement instanceof PsiField && ((psiField = (PsiField)psiElement).getContainingClass() == targetClass || membersToMove.contains(psiField)) && !afterFields.contains(psiField)) {
                            afterFields.add(psiField);
                        }
                    }
                });
            }
            if (!afterFields.isEmpty()) {
                afterFields.sort((o1, o2) -> -PsiUtilCore.compareElementsByPosition((PsiElement)o1, (PsiElement)o2));
                return (PsiElement)afterFields.get(0);
            }
            ArrayList<PsiField> beforeFields = new ArrayList<PsiField>();
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)targetClass))) {
                PsiField fieldWithReference = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiField.class);
                if (fieldWithReference == null || afterFields.contains(fieldWithReference) || fieldWithReference.getContainingClass() != targetClass) continue;
                beforeFields.add(fieldWithReference);
            }
            beforeFields.sort(PsiUtil.BY_POSITION);
            if (!beforeFields.isEmpty()) {
                return ((PsiField)beforeFields.get(0)).getPrevSibling();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReference";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveMembersOptions";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveMembers/MoveJavaMemberHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doMove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictsOnUsage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkConflictsOnMember";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "changeExternalUsage";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toBeConvertedToEnum";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "decodeContextInfo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

