/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveMembers.MoveMembersDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.HashSet;

public class MoveMembersImpl {
    @Deprecated
    public static final String REFACTORING_NAME = "Move Static Members";

    public static void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback moveCallback) {
        if (elements.length == 0) {
            return;
        }
        PsiElement first = elements[0];
        if (!(first instanceof PsiMember) || ((PsiMember)first).getContainingClass() == null) {
            return;
        }
        PsiClass sourceClass = ((PsiMember)first).getContainingClass();
        HashSet<PsiMember> preselectMembers = new HashSet<PsiMember>();
        for (PsiElement element : elements) {
            if (element instanceof PsiMember && !sourceClass.equals(((PsiMember)element).getContainingClass())) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"members.to.be.moved.should.belong.to.the.same.class"));
                CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message2, (String)"refactoring.moveMembers", (Project)project);
                return;
            }
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                if (!field.hasModifierProperty("static")) {
                    String fieldName = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    String message3 = RefactoringBundle.message((String)"field.0.is.not.static", (Object[])new Object[]{fieldName, MoveMembersImpl.getRefactoringName()});
                    CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message3, (String)"refactoring.moveMembers", (Project)project);
                    return;
                }
                preselectMembers.add((PsiMember)field);
                continue;
            }
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                String methodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
                if (method.isConstructor()) {
                    String message4 = RefactoringBundle.message((String)"0.refactoring.cannot.be.applied.to.constructors", (Object[])new Object[]{MoveMembersImpl.getRefactoringName()});
                    CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message4, (String)"refactoring.moveMembers", (Project)project);
                    return;
                }
                if (!method.hasModifierProperty("static")) {
                    String message5 = RefactoringBundle.message((String)"method.0.is.not.static", (Object[])new Object[]{methodName, MoveMembersImpl.getRefactoringName()});
                    CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message5, (String)"refactoring.moveMembers", (Project)project);
                    return;
                }
                preselectMembers.add((PsiMember)method);
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            if (!aClass.hasModifierProperty("static")) {
                String message6 = JavaRefactoringBundle.message((String)"inner.class.0.is.not.static", (Object[])new Object[]{aClass.getQualifiedName(), MoveMembersImpl.getRefactoringName()});
                CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message6, (String)"refactoring.moveMembers", (Project)project);
                return;
            }
            preselectMembers.add((PsiMember)aClass);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)sourceClass)) {
            return;
        }
        PsiClass initialTargerClass = targetContainer instanceof PsiClass ? (PsiClass)targetContainer : null;
        MoveMembersDialog dialog = new MoveMembersDialog(project, sourceClass, initialTargerClass, preselectMembers, moveCallback);
        dialog.show();
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"move.members.title");
    }
}

