/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.ClassHidesImportedClassUsageInfo;
import com.intellij.refactoring.rename.ClassHidesUnqualifiableClassUsageInfo;
import com.intellij.refactoring.rename.CollidingClassImportUsageInfo;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.ResolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.SubmemberHidesMemberUsageInfo;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameJavaClassProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenameJavaClassProcessor.class);
    @NonNls
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s");

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PsiClass;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(2);
        }
        if (usages == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(3);
        }
        PsiClass aClass = (PsiClass)element;
        ArrayList<UsageInfo> postponedCollisions = new ArrayList<UsageInfo>();
        ArrayList<MemberHidesOuterMemberUsageInfo> hidesOut = new ArrayList<MemberHidesOuterMemberUsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ResolvableCollisionUsageInfo)) continue;
            if (usage instanceof CollidingClassImportUsageInfo) {
                ((CollidingClassImportUsageInfo)usage).getImportStatement().delete();
                continue;
            }
            if (usage instanceof MemberHidesOuterMemberUsageInfo) {
                PsiElement usageElement = usage.getElement();
                PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)usageElement;
                if (collidingRef == null) continue;
                hidesOut.add(new MemberHidesOuterMemberUsageInfo(usageElement, (PsiMember)((PsiClass)collidingRef.resolve())));
                continue;
            }
            postponedCollisions.add(usage);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)aClass.getContainingFile(), true, false);
        aClass.setName(newName);
        for (UsageInfo usage : usages) {
            PsiReference ref;
            if (usage instanceof ResolvableCollisionUsageInfo || (ref = usage.getReference()) == null) continue;
            try {
                ref.bindToElement((PsiElement)aClass);
            }
            catch (IncorrectOperationException e) {
                ref.handleElementRename(newName);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)aClass.getContainingFile(), null, null);
        for (UsageInfo postponedCollision : postponedCollisions) {
            ClassHidesImportedClassUsageInfo collision = (ClassHidesImportedClassUsageInfo)postponedCollision;
            collision.resolveCollision();
        }
        for (MemberHidesOuterMemberUsageInfo usage : hidesOut) {
            PsiJavaCodeReferenceElement collidingRef = (PsiJavaCodeReferenceElement)usage.getElement();
            PsiMember member = (PsiMember)usage.getReferencedElement();
            if (collidingRef == null || !collidingRef.isValid() || member == null || !member.isValid()) continue;
            PsiManager manager = member.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)member.getProject());
            String name2 = member.getName();
            PsiClass containingClass = member.getContainingClass();
            if (name2 == null || containingClass == null || manager.areElementsEquivalent(factory.createReferenceFromText(name2, (PsiElement)collidingRef).resolve(), (PsiElement)member)) continue;
            PsiJavaCodeReferenceElement ref = factory.createReferenceFromText("A." + name2, (PsiElement)collidingRef);
            PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)ref.getQualifier();
            LOG.assertTrue(qualifier != null);
            PsiJavaCodeReferenceElement classReference2 = factory.createClassReferenceElement(containingClass);
            qualifier.replace((PsiElement)classReference2);
            collidingRef.replace((PsiElement)ref);
        }
        if (listener != null) {
            listener.elementRenamed((PsiElement)aClass);
        }
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        PsiClass aClass;
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiClass && (aClass = (PsiClass)element).getParent() instanceof PsiClass) {
            String dollaredStringToReplace;
            String dollaredStringToSearch = ClassUtil.getJVMClassName((PsiClass)aClass);
            String string = dollaredStringToReplace = dollaredStringToSearch == null ? null : RefactoringUtil.getNewInnerClassName(aClass, dollaredStringToSearch, newName);
            if (dollaredStringToReplace != null) {
                return Pair.create((Object)dollaredStringToSearch, (Object)dollaredStringToReplace);
            }
        }
        return null;
    }

    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(7);
        }
        if (nonJava) {
            PsiClass aClass = (PsiClass)element;
            return PsiUtilCore.getQualifiedNameAfterRename((String)aClass.getQualifiedName(), (String)newName);
        }
        return newName;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        PsiMethod[] constructors;
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(9);
        }
        if (allRenames == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(11);
        }
        for (PsiMethod constructor : constructors = ((PsiClass)element).getConstructors()) {
            if (constructor instanceof PsiMirrorElement) {
                PsiElement prototype = ((PsiMirrorElement)constructor).getPrototype();
                if (!(prototype instanceof PsiNamedElement)) continue;
                allRenames.put(prototype, newName);
                continue;
            }
            if (constructor instanceof LightElement) continue;
            allRenames.put((PsiElement)constructor, newName);
        }
    }

    public void findCollisions(@NotNull PsiElement element, final @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        PsiTypeParameterListOwner owner2;
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(13);
        }
        if (allRenames == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(14);
        }
        if (result == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(15);
        }
        final PsiClass aClass = (PsiClass)element;
        ClassCollisionsDetector classCollisionsDetector = new ClassCollisionsDetector(aClass);
        ArrayList<UsageInfo> initialResults = new ArrayList<UsageInfo>(result);
        for (UsageInfo usageInfo : initialResults) {
            if (!(usageInfo instanceof MoveRenameUsageInfo)) continue;
            classCollisionsDetector.addClassCollisions(usageInfo.getElement(), newName, result);
        }
        RenameJavaClassProcessor.findSubmemberHidesMemberCollisions(aClass, newName, result);
        if (aClass instanceof PsiTypeParameter && (owner2 = ((PsiTypeParameter)aClass).getOwner()) != null) {
            for (PsiTypeParameter typeParameter : owner2.getTypeParameters()) {
                if (!Objects.equals(newName, typeParameter.getName())) continue;
                result.add((UsageInfo)new UnresolvableCollisionUsageInfo((PsiElement)aClass, (PsiElement)typeParameter){

                    public String getDescription() {
                        return JavaRefactoringBundle.message((String)"there.is.already.type.parameter.in.0.with.name.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false), newName});
                    }
                });
            }
        }
    }

    public static void findSubmemberHidesMemberCollisions(PsiClass aClass, String newName, List<UsageInfo> result) {
        block9: {
            PsiClass[] supers;
            PsiTypeParameterListOwner owner2;
            block8: {
                if (!(aClass.getParent() instanceof PsiClass)) break block8;
                PsiClass parent = (PsiClass)aClass.getParent();
                Collection inheritors = ClassInheritorsSearch.search((PsiClass)parent).findAll();
                for (PsiClass inheritor : inheritors) {
                    if (newName.equals(inheritor.getName())) {
                        ClassCollisionsDetector classCollisionsDetector = new ClassCollisionsDetector(aClass);
                        for (PsiReference reference2 : ReferencesSearch.search((PsiElement)inheritor, (SearchScope)new LocalSearchScope((PsiElement)inheritor))) {
                            classCollisionsDetector.addClassCollisions(reference2.getElement(), newName, result);
                        }
                    }
                    PsiClass[] inners = inheritor.getInnerClasses();
                    for (PsiClass inner : inners) {
                        if (!newName.equals(inner.getName())) continue;
                        result.add((UsageInfo)new SubmemberHidesMemberUsageInfo((PsiElement)inner, (PsiElement)aClass));
                    }
                }
                break block9;
            }
            if (!(aClass instanceof PsiTypeParameter) || !((owner2 = ((PsiTypeParameter)aClass).getOwner()) instanceof PsiClass)) break block9;
            for (PsiClass superClass : supers = ((PsiClass)owner2).getSupers()) {
                if (newName.equals(superClass.getName())) {
                    ClassCollisionsDetector classCollisionsDetector = new ClassCollisionsDetector(aClass);
                    for (PsiReference reference3 : ReferencesSearch.search((PsiElement)superClass, (SearchScope)new LocalSearchScope((PsiElement)superClass))) {
                        classCollisionsDetector.addClassCollisions(reference3.getElement(), newName, result);
                    }
                }
                PsiClass[] inners = superClass.getInnerClasses();
                for (PsiClass inner : inners) {
                    if (!newName.equals(inner.getName())) continue;
                    ReferencesSearch.search((PsiElement)inner).forEach(reference -> {
                        PsiElement refElement = reference.getElement();
                        if (refElement instanceof PsiReferenceExpression && ((PsiReferenceExpression)refElement).isQualified()) {
                            return true;
                        }
                        MemberHidesOuterMemberUsageInfo info = new MemberHidesOuterMemberUsageInfo(refElement, (PsiMember)aClass);
                        result.add((UsageInfo)info);
                        return true;
                    });
                }
            }
        }
    }

    private static String removeSpaces(String s) {
        return WHITE_SPACE_PATTERN.matcher(s).replaceAll("");
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(16);
        }
        if (newName == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(17);
        }
        if (conflicts == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(18);
        }
        if (element instanceof PsiCompiledElement) {
            return;
        }
        PsiClass aClass = (PsiClass)element;
        if (newName.equals(aClass.getName())) {
            return;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            PsiClass[] innerClasses;
            for (PsiClass innerClass : innerClasses = containingClass.getInnerClasses()) {
                if (!newName.equals(innerClass.getName())) continue;
                conflicts.putValue((Object)innerClass, (Object)JavaRefactoringBundle.message((String)"inner.class.0.is.already.defined.in.class.1", (Object[])new Object[]{newName, containingClass.getQualifiedName()}));
                break;
            }
        } else if (!(aClass instanceof PsiTypeParameter)) {
            String qualifiedNameAfterRename = PsiUtilCore.getQualifiedNameAfterRename((String)aClass.getQualifiedName(), (String)newName);
            Project project = element.getProject();
            PsiClass conflictingClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedNameAfterRename, GlobalSearchScope.allScope((Project)project));
            if (conflictingClass != null) {
                conflicts.putValue((Object)conflictingClass, (Object)JavaRefactoringBundle.message((String)"class.0.already.exists", (Object[])new Object[]{qualifiedNameAfterRename}));
            }
        }
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameClass";
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(19);
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(20);
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(21);
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenameJavaClassProcessor.$$$reportNull$$$0(22);
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameJavaClassProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextOccurrenceSearchStrings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "findCollisions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassCollisionsDetector {
        final HashSet<PsiFile> myProcessedFiles = new HashSet();
        final PsiClass myRenamedClass;
        private final String myRenamedClassQualifiedName;

        ClassCollisionsDetector(PsiClass renamedClass) {
            this.myRenamedClass = renamedClass;
            this.myRenamedClassQualifiedName = this.myRenamedClass.getQualifiedName();
        }

        public void addClassCollisions(PsiElement referenceElement, String newName, List<UsageInfo> results) {
            PsiTypeParameterList typeParameterList;
            PsiTypeParameterListOwner member;
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)referenceElement.getProject()).getResolveHelper();
            PsiClass aClass = resolveHelper.resolveReferencedClass(newName, referenceElement);
            if (aClass == null) {
                return;
            }
            if (aClass instanceof PsiTypeParameter && this.myRenamedClass instanceof PsiTypeParameter && (member = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiTypeParameterListOwner.class)) != null && (typeParameterList = member.getTypeParameterList()) != null && ArrayUtilRt.find((Object[])typeParameterList.getTypeParameters(), (Object)this.myRenamedClass) > -1 && member.hasModifierProperty("static")) {
                return;
            }
            PsiFile containingFile = referenceElement.getContainingFile();
            String text2 = referenceElement.getText();
            if (Objects.equals(this.myRenamedClassQualifiedName, RenameJavaClassProcessor.removeSpaces(text2))) {
                return;
            }
            if (this.myProcessedFiles.contains(containingFile)) {
                return;
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)new LocalSearchScope((PsiElement)containingFile))) {
                PsiElement collisionReferenceElement = reference.getElement();
                if (!(collisionReferenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                PsiElement parent = collisionReferenceElement.getParent();
                if (parent instanceof PsiImportStatement) {
                    results.add((UsageInfo)new CollidingClassImportUsageInfo((PsiImportStatement)parent, (PsiElement)this.myRenamedClass));
                    continue;
                }
                if (aClass.getQualifiedName() != null) {
                    results.add((UsageInfo)new ClassHidesImportedClassUsageInfo((PsiJavaCodeReferenceElement)collisionReferenceElement, this.myRenamedClass, aClass));
                    continue;
                }
                results.add((UsageInfo)new ClassHidesUnqualifiableClassUsageInfo((PsiJavaCodeReferenceElement)collisionReferenceElement, this.myRenamedClass, aClass));
            }
            this.myProcessedFiles.add(containingFile);
        }
    }
}

