/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamer
extends AutomaticRenamer {
    public AutomaticOverloadsRenamer(@NotNull PsiMethod method, String newName) {
        if (method == null) {
            AutomaticOverloadsRenamer.$$$reportNull$$$0(0);
        }
        for (PsiMethod overload : this.getOverloads(method)) {
            if (overload == method || overload.findDeepestSuperMethods().length != 0) continue;
            this.myElements.add(overload);
            this.suggestAllNames(overload.getName(), newName);
        }
    }

    public String getDialogTitle() {
        return JavaRefactoringBundle.message((String)"rename.overloads.dialog.title", (Object[])new Object[0]);
    }

    public String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"rename.overloads.to.dialog.description", (Object[])new Object[0]);
    }

    public String entityName() {
        return "Overload";
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    protected PsiMethod @NotNull [] getOverloads(@NotNull PsiMethod method) {
        PsiClass containingClass;
        if (method == null) {
            AutomaticOverloadsRenamer.$$$reportNull$$$0(1);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                AutomaticOverloadsRenamer.$$$reportNull$$$0(2);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = containingClass.findMethodsByName(method.getName(), false);
        if (psiMethodArray == null) {
            AutomaticOverloadsRenamer.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/naming/AutomaticOverloadsRenamer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

