/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.builder;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.Bottom;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.Util;
import com.intellij.refactoring.typeCook.deductive.builder.ReductionSystem;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Result {
    private static final Logger LOG = Logger.getInstance(Result.class);
    private final Set<PsiElement> myVictims;
    private final Map<PsiElement, PsiType> myTypes;
    private final Settings mySettings;
    private final Map<PsiTypeCastExpression, PsiType> myCastToOperandType;
    private int myCookedNumber = -1;
    private int myCastsRemoved = -1;
    private final int myCastsNumber;
    private Binding myBinding;

    public Result(ReductionSystem system) {
        this.myVictims = system.myElements;
        this.myTypes = system.myTypes;
        this.mySettings = system.mySettings;
        this.myCastToOperandType = system.myCastToOperandType;
        this.myCastsNumber = this.myCastToOperandType.size();
    }

    public void incorporateSolution(Binding binding) {
        if (this.myBinding == null) {
            this.myBinding = binding;
        } else {
            this.myBinding.merge(binding, this.mySettings.leaveObjectParameterizedTypesRaw());
        }
    }

    public PsiType getCookedType(PsiElement element) {
        PsiType originalType = Util.getType(element);
        if (this.myBinding != null) {
            PsiType type2 = this.myBinding.substitute(this.myTypes.get(element));
            String objectFQName = "java.lang.Object";
            if (originalType.getCanonicalText().equals("java.lang.Object")) {
                if (type2 == null) {
                    return originalType;
                }
                if (type2 instanceof PsiWildcardType) {
                    PsiType bound = ((PsiWildcardType)type2).getBound();
                    if (bound != null) {
                        return bound;
                    }
                    return originalType;
                }
            }
            return type2;
        }
        return originalType;
    }

    public Set<PsiElement> getCookedElements() {
        this.myCookedNumber = 0;
        HashSet<PsiElement> set = new HashSet<PsiElement>();
        for (PsiElement psiElement : this.myVictims) {
            PsiType originalType = Util.getType(psiElement);
            PsiType cookedType = this.getCookedType(psiElement);
            if (cookedType == null || originalType.equals(cookedType)) continue;
            set.add(psiElement);
            ++this.myCookedNumber;
        }
        if (this.mySettings.dropObsoleteCasts()) {
            this.myCastsRemoved = 0;
            if (this.myBinding != null) {
                for (Map.Entry entry : this.myCastToOperandType.entrySet()) {
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)entry.getKey();
                    PsiType operandType = this.myBinding.apply((PsiType)entry.getValue());
                    PsiType castType = cast.getType();
                    if (operandType instanceof PsiTypeVariable || castType == null || Result.isBottomArgument(operandType) || !castType.isAssignableFrom(operandType)) continue;
                    set.add((PsiElement)cast);
                }
            }
        }
        return set;
    }

    private static boolean isBottomArgument(PsiType type2) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass clazz = resolveResult.getElement();
        if (clazz != null) {
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)clazz)) {
                PsiType t = resolveResult.getSubstitutor().substitute(typeParameter);
                if (t != Bottom.BOTTOM) continue;
                return true;
            }
        }
        return false;
    }

    public void apply(Set<PsiElement> victims) {
        for (PsiElement element : victims) {
            if (element instanceof PsiTypeCastExpression && this.myCastToOperandType.containsKey(element)) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)element;
                try {
                    cast.replace((PsiElement)cast.getOperand());
                    ++this.myCastsRemoved;
                }
                catch (IncorrectOperationException e1) {
                    LOG.error((Throwable)e1);
                }
                continue;
            }
            Util.changeType(element, this.getCookedType(element));
        }
    }

    private String getRatio(int x, int y) {
        String ratio = JavaRefactoringBundle.message((String)"type.cook.ratio.generified", (Object[])new Object[]{x, y});
        return ratio + (y != 0 ? " (" + x * 100 / y + "%)" : "");
    }

    public String getReport() {
        return JavaRefactoringBundle.message((String)"type.cook.report", (Object[])new Object[]{this.getRatio(this.myCookedNumber, this.myVictims.size()), this.getRatio(this.myCastsRemoved, this.myCastsNumber)});
    }
}

