/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeConversionDescriptor
extends TypeConversionDescriptorBase {
    private String myStringToReplace = null;
    private String myReplaceByString = "$";
    private PsiExpression myExpression;
    private PsiType myConversionType;

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString) {
        this(stringToReplace, replaceByString, (PsiExpression)null);
    }

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiExpression expression2) {
        this.myStringToReplace = stringToReplace;
        this.myReplaceByString = replaceByString;
        this.myExpression = expression2;
    }

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiType conversionType) {
        this(stringToReplace, replaceByString);
        this.myConversionType = conversionType;
    }

    public TypeConversionDescriptor withConversionType(PsiType conversionType) {
        this.myConversionType = conversionType;
        return this;
    }

    public void setStringToReplace(String stringToReplace) {
        this.myStringToReplace = stringToReplace;
    }

    public void setReplaceByString(String replaceByString) {
        this.myReplaceByString = replaceByString;
    }

    public String getStringToReplace() {
        return this.myStringToReplace;
    }

    public String getReplaceByString() {
        return this.myReplaceByString;
    }

    public PsiExpression getExpression() {
        return this.myExpression;
    }

    public void setExpression(PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @Override
    @Nullable
    public PsiType conversionType() {
        return this.myConversionType;
    }

    @Override
    public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
        if (evaluator == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(0);
        }
        if (this.getExpression() != null) {
            expression2 = this.getExpression();
        }
        expression2 = this.adjustExpressionBeforeReplacement(expression2);
        return TypeConversionDescriptor.replaceExpression(expression2, this.getStringToReplace(), this.getReplaceByString());
    }

    @NotNull
    protected PsiExpression adjustExpressionBeforeReplacement(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(1);
        }
        PsiExpression psiExpression = expression2;
        if (psiExpression == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(2);
        }
        return psiExpression;
    }

    @NotNull
    public static PsiExpression replaceExpression(@NotNull PsiExpression expression2, String stringToReplace, String replaceByString) {
        if (expression2 == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(3);
        }
        Project project = expression2.getProject();
        ReplaceOptions options = new ReplaceOptions();
        MatchOptions matchOptions = options.getMatchOptions();
        matchOptions.setFileType((LanguageFileType)JavaFileType.INSTANCE);
        String replacement = Replacer.testReplace((String)expression2.getText(), (String)stringToReplace, (String)replaceByString, (ReplaceOptions)options, (Project)project);
        PsiExpression psiExpression = (PsiExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(expression2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(replacement, (PsiElement)expression2)));
        if (psiExpression == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(4);
        }
        return psiExpression;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.myReplaceByString != null) {
            buf.append(this.myReplaceByString);
        }
        if (this.myStringToReplace != null) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.myStringToReplace);
        }
        if (this.myExpression != null) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.myExpression.getText());
        }
        return buf.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeConversionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeConversionDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustExpressionBeforeReplacement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustExpressionBeforeReplacement";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

