/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.Nullable;

public enum GuavaLambda {
    PREDICATE("com.google.common.base.Predicate", "java.util.function.Predicate", "apply", "test", 1),
    FUNCTION("com.google.common.base.Function", "java.util.function.Function", "apply", "apply", 1),
    SUPPLIER("com.google.common.base.Supplier", "java.util.function.Supplier", "get", "get", 0);

    private final String myClassQName;
    private final String myJavaAnalogueClassQName;
    private final String mySamName;
    private final String myJavaAnalogueSamName;
    private final int myParametersCount;

    private GuavaLambda(String classQName, String javaAnalogueClassQName, String samName, String javaAnalogueSamName, int count) {
        this.myClassQName = classQName;
        this.myJavaAnalogueClassQName = javaAnalogueClassQName;
        this.mySamName = samName;
        this.myJavaAnalogueSamName = javaAnalogueSamName;
        this.myParametersCount = count;
    }

    public int getParametersCount() {
        return this.myParametersCount;
    }

    public String getClassQName() {
        return this.myClassQName;
    }

    public String getJavaAnalogueClassQName() {
        return this.myJavaAnalogueClassQName;
    }

    public String getSamName() {
        return this.mySamName;
    }

    public String getJavaAnalogueSamName() {
        return this.myJavaAnalogueSamName;
    }

    @Nullable
    static GuavaLambda findFor(@Nullable PsiType type2) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type2);
        if (aClass == null) {
            return null;
        }
        for (GuavaLambda lambda2 : GuavaLambda.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)lambda2.getClassQName())) continue;
            if (PREDICATE != lambda2 && InheritanceUtil.isInheritor((PsiClass)aClass, (String)lambda2.getJavaAnalogueClassQName())) {
                return null;
            }
            return lambda2;
        }
        return null;
    }

    @Nullable
    static GuavaLambda findJavaAnalogueFor(@Nullable PsiType type2) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type2);
        if (aClass == null) {
            return null;
        }
        for (GuavaLambda lambda2 : GuavaLambda.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)lambda2.getJavaAnalogueClassQName())) continue;
            return lambda2;
        }
        return null;
    }
}

