/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GuavaOptionalConversionUtil {
    static boolean isOptionalOrContext(@Nullable PsiExpression context) {
        if (context == null) {
            return false;
        }
        PsiElement parent = context.getParent();
        if (parent == null) {
            return false;
        }
        PsiElement maybeMethodCall = parent.getParent();
        if (!(maybeMethodCall instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)maybeMethodCall;
        int argumentLength = methodCall.getArgumentList().getExpressionCount();
        if (argumentLength != 1) {
            return false;
        }
        PsiMethod resolvedMethod = methodCall.resolveMethod();
        if (resolvedMethod == null || !"or".equals(resolvedMethod.getName())) {
            return false;
        }
        PsiClass aClass = resolvedMethod.getContainingClass();
        return aClass != null && "com.google.common.base.Optional".equals(aClass.getQualifiedName());
    }

    static String simplifyParameterPattern(PsiMethodCallExpression methodCall) {
        PsiExpressionList argumentList = methodCall.getArgumentList();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (expressions2.length == 1) {
            MatchResult result;
            PsiExpression expression2 = expressions2[0];
            MatchOptions options = new MatchOptions();
            options.setSearchPattern("Optional.fromNullable($o$.orElse(null))");
            options.setFileType((LanguageFileType)JavaFileType.INSTANCE);
            Matcher matcher = new Matcher(methodCall.getProject(), options);
            List results = matcher.testFindMatches(expression2.getText(), false, (LanguageFileType)JavaFileType.INSTANCE, false);
            if (!results.isEmpty() && (result = (MatchResult)results.get(0)).getStart() == 0 && result.getEnd() == -1) {
                return "Optional.fromNullable($o$.orElse(null))";
            }
        }
        return "$o$";
    }
}

