/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeSelector {
    private final PsiType myType;
    private final JComponent myComponent;
    private final MyComboBoxModel myComboBoxModel;
    private final Project myProject;

    public TypeSelector(PsiType type2, @NotNull Project project) {
        if (project == null) {
            TypeSelector.$$$reportNull$$$0(0);
        }
        this.myType = type2;
        this.myProject = project;
        this.myComponent = new JLabel(this.myType.getPresentableText());
        this.myComboBoxModel = null;
    }

    public TypeSelector(@NotNull Project project) {
        if (project == null) {
            TypeSelector.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myComboBoxModel = new MyComboBoxModel();
        this.myComponent = new ComboBox();
        ((ComboBox)this.myComponent).setModel((ComboBoxModel)this.myComboBoxModel);
        this.myType = null;
    }

    public void setTypes(PsiType[] types) {
        if (this.myComboBoxModel == null) {
            return;
        }
        PsiType oldType = this.myComboBoxModel.getSize() > 0 ? this.getSelectedType() : null;
        this.myComboBoxModel.setSuggestions(TypeSelector.wrapToItems(types, this.myProject));
        if (oldType != null) {
            for (int i = 0; i < types.length; ++i) {
                PsiType type2 = types[i];
                if (!type2.equals(oldType)) continue;
                ((JComboBox)this.myComponent).setSelectedIndex(i);
                return;
            }
        }
        if (types.length > 0) {
            ((JComboBox)this.myComponent).setSelectedIndex(0);
        }
    }

    public PsiType[] getTypes() {
        PsiType[] types = PsiType.createArray((int)this.myComboBoxModel.mySuggestions.length);
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.myComboBoxModel.mySuggestions[i].getType();
        }
        return types;
    }

    private static PsiTypeItem[] wrapToItems(PsiType @NotNull [] types, @NotNull Project project) {
        if (project == null) {
            TypeSelector.$$$reportNull$$$0(2);
        }
        if (types == null) {
            TypeSelector.$$$reportNull$$$0(3);
        }
        PsiTypeItem[] result = new PsiTypeItem[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PsiTypeItem(types[i], project);
        }
        return result;
    }

    public void addItemListener(ItemListener aListener) {
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).addItemListener(aListener);
        }
    }

    public void removeItemListener(ItemListener aListener) {
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).removeItemListener(aListener);
        }
    }

    public ItemListener[] getItemListeners() {
        if (this.myComponent instanceof JComboBox) {
            return ((JComboBox)this.myComponent).getItemListeners();
        }
        return new ItemListener[0];
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getFocusableComponent() {
        if (this.myComponent instanceof JComboBox) {
            return this.myComponent;
        }
        return null;
    }

    @Nullable
    public PsiType getSelectedType() {
        if (this.myComponent instanceof JLabel) {
            return this.myType;
        }
        PsiTypeItem selItem = (PsiTypeItem)((JComboBox)this.myComponent).getSelectedItem();
        return selItem == null ? null : selItem.getType();
    }

    public void selectType(@NotNull PsiType type2) {
        if (type2 == null) {
            TypeSelector.$$$reportNull$$$0(4);
        }
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).setSelectedItem(new PsiTypeItem(type2, this.myProject));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/ui/TypeSelector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapToItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PsiTypeItem {
        private final PsiType myType;
        private final SmartTypePointer myTypePointer;

        private PsiTypeItem(@NotNull PsiType type2, @NotNull Project project) {
            if (type2 == null) {
                PsiTypeItem.$$$reportNull$$$0(0);
            }
            if (project == null) {
                PsiTypeItem.$$$reportNull$$$0(1);
            }
            this.myType = type2;
            this.myTypePointer = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(type2);
        }

        @Nullable
        public PsiType getType() {
            return this.myTypePointer.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiTypeItem that = (PsiTypeItem)o;
            return Comparing.equal((Object)this.getType(), (Object)that.getType());
        }

        public int hashCode() {
            PsiType type2 = this.getType();
            return type2 != null ? type2.hashCode() : 0;
        }

        public String toString() {
            return this.myType.getPresentableText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/ui/TypeSelector$PsiTypeItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel {
        private PsiTypeItem[] mySuggestions = new PsiTypeItem[0];

        MyComboBoxModel() {
        }

        @Override
        public int getSize() {
            return this.mySuggestions.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.mySuggestions[index];
        }

        public void setSuggestions(PsiTypeItem[] suggestions) {
            this.fireIntervalRemoved(this, 0, this.mySuggestions.length);
            this.mySuggestions = suggestions;
            this.fireIntervalAdded(this, 0, this.mySuggestions.length);
        }
    }
}

