/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaRefactoringUtil {
    private static final Logger LOG = Logger.getInstance(LambdaRefactoringUtil.class);

    @Nullable
    public static PsiExpression convertToMethodCallInLambdaBody(PsiMethodReferenceExpression element) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(element, false, true);
        return lambdaExpression != null ? LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody()) : null;
    }

    @Nullable
    public static PsiLambdaExpression convertMethodReferenceToLambda(PsiMethodReferenceExpression referenceExpression, boolean ignoreCast, boolean simplifyToExpressionLambda) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.createLambda(referenceExpression, ignoreCast);
        if (lambdaExpression == null) {
            return null;
        }
        lambdaExpression = (PsiLambdaExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)referenceExpression, (PsiElement)lambdaExpression);
        if (simplifyToExpressionLambda) {
            LambdaRefactoringUtil.simplifyToExpressionLambda(lambdaExpression);
        }
        return lambdaExpression;
    }

    public static boolean canConvertToLambda(PsiMethodReferenceExpression referenceExpression) {
        return LambdaRefactoringUtil.createLambda(referenceExpression, false) != null;
    }

    public static PsiLambdaExpression createLambda(PsiMethodReferenceExpression referenceExpression, boolean doNotAddParameterTypes) {
        PsiParameterList typedParamList;
        boolean needToSpecifyFormalTypes;
        String lambda2 = LambdaRefactoringUtil.createLambdaWithoutFormalParameters(referenceExpression);
        if (lambda2 == null) {
            return null;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)referenceExpression.getProject());
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(lambda2, (PsiElement)referenceExpression);
        PsiType functionalInterfaceType = referenceExpression.getFunctionalInterfaceType();
        boolean bl = needToSpecifyFormalTypes = !doNotAddParameterTypes && !LambdaRefactoringUtil.isInferredSameTypeAfterConversion(lambdaExpression, referenceExpression);
        if (needToSpecifyFormalTypes && (typedParamList = LambdaUtil.specifyLambdaParameterTypes((PsiType)functionalInterfaceType, (PsiLambdaExpression)lambdaExpression)) == null) {
            return null;
        }
        return lambdaExpression;
    }

    private static String createLambdaWithoutFormalParameters(PsiMethodReferenceExpression referenceExpression) {
        boolean isReceiver;
        PsiType functionalInterfaceType = referenceExpression.getFunctionalInterfaceType();
        PsiElement resolve2 = referenceExpression.resolve();
        if (resolve2 == null) {
            return null;
        }
        PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (interfaceMethod == null) {
            return null;
        }
        PsiSubstitutor psiSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult);
        MethodSignature signature = interfaceMethod.getSignature(psiSubstitutor);
        if (resolve2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve2;
            isReceiver = PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)referenceExpression, (MethodSignature)signature, (boolean)method.isVarArgs(), (boolean)method.hasModifierProperty("static"), (int)method.getParameterList().getParametersCount());
        } else {
            isReceiver = false;
        }
        PsiParameter[] psiParameters = resolve2 instanceof PsiMethod ? ((PsiMethod)resolve2).getParameterList().getParameters() : null;
        PsiParameterList parameterList = interfaceMethod.getParameterList();
        Object[] parameters2 = parameterList.getParameters();
        HashMap map2 = new HashMap();
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)referenceExpression.getProject());
        Function paramPresentationFunction = parameter2 -> {
            String baseName;
            int parameterIndex = parameterList.getParameterIndex(parameter2);
            if (isReceiver && parameterIndex == 0) {
                SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, psiSubstitutor.substitute(parameter2.getType()));
                baseName = nameInfo.names.length > 0 ? nameInfo.names[0] : parameter2.getName();
            } else {
                String initialName;
                if (psiParameters != null) {
                    int idx = parameterIndex - (isReceiver ? 1 : 0);
                    initialName = psiParameters.length > 0 ? psiParameters[idx < psiParameters.length ? idx : psiParameters.length - 1].getName() : parameter2.getName();
                } else {
                    initialName = parameter2.getName();
                }
                if ("_".equals(initialName)) {
                    SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, psiSubstitutor.substitute(parameter2.getType()));
                    if (nameInfo.names.length > 0) {
                        initialName = nameInfo.names[0];
                    }
                }
                baseName = codeStyleManager.variableNameToPropertyName(initialName, VariableKind.PARAMETER);
            }
            String parameterName = nameGenerator.generateUniqueName(codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)referenceExpression, true));
            map2.put(parameter2, parameterName);
            return parameterName;
        };
        StringBuilder buf = new StringBuilder();
        if (parameters2.length == 1) {
            buf.append((String)paramPresentationFunction.fun((Object)parameters2[0]));
        } else {
            buf.append("(").append(StringUtil.join((Object[])parameters2, (Function)paramPresentationFunction, (String)", ")).append(")");
        }
        buf.append(" -> ");
        JavaResolveResult resolveResult = referenceExpression.advancedResolve(false);
        PsiElement resolveElement = resolveResult.getElement();
        if (resolveElement instanceof PsiMember) {
            buf.append("{");
            if (!PsiType.VOID.equals((Object)interfaceMethod.getReturnType())) {
                buf.append("return ");
            }
            PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)referenceExpression);
            PsiElement qualifier = referenceExpression.getQualifier();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            boolean onArrayRef = PsiUtil.isArrayClass((PsiElement)containingClass);
            PsiElement referenceNameElement2 = referenceExpression.getReferenceNameElement();
            if (isReceiver) {
                buf.append((String)map2.get(parameters2[0])).append(".");
            } else if (!(referenceNameElement2 instanceof PsiKeyword)) {
                if (qualifier instanceof PsiTypeElement) {
                    PsiJavaCodeReferenceElement referenceElement = ((PsiTypeElement)qualifier).getInnermostComponentReferenceElement();
                    LOG.assertTrue(referenceElement != null);
                    if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)referenceExpression, (boolean)false)) {
                        buf.append(referenceElement.getReferenceName()).append(".");
                    }
                } else if (qualifier != null && !LambdaRefactoringUtil.isQualifierUnnecessary(qualifier, containingClass)) {
                    buf.append(qualifier.getText()).append(".");
                }
            }
            buf.append(referenceExpression.getReferenceName());
            if (referenceNameElement2 instanceof PsiKeyword) {
                buf.append(" ");
                if (onArrayRef) {
                    if (qualifier instanceof PsiTypeElement) {
                        PsiType type2 = ((PsiTypeElement)qualifier).getType();
                        int dim = type2.getArrayDimensions();
                        buf.append(type2.getDeepComponentType().getCanonicalText());
                        buf.append("[");
                        buf.append((String)map2.get(parameters2[0]));
                        buf.append("]");
                        while (--dim > 0) {
                            buf.append("[]");
                        }
                    }
                } else {
                    buf.append(((PsiMember)resolveElement).getName());
                    PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                    LOG.assertTrue(containingClass != null);
                    if (containingClass.hasTypeParameters() && !PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)substitutor)) {
                        buf.append("<").append(StringUtil.join((Object[])containingClass.getTypeParameters(), parameter2 -> {
                            PsiType psiType = substitutor.substitute(parameter2);
                            LOG.assertTrue(psiType != null);
                            return psiType.getCanonicalText();
                        }, (String)", ")).append(">");
                    }
                }
            }
            if (!onArrayRef || isReceiver) {
                int i;
                buf.append("(");
                boolean first = true;
                int n = i = isReceiver ? 1 : 0;
                while (i < parameters2.length) {
                    Object parameter3 = parameters2[i];
                    if (!first) {
                        buf.append(", ");
                    } else {
                        first = false;
                    }
                    buf.append((String)map2.get(parameter3));
                    ++i;
                }
                buf.append(")");
            }
            buf.append(";}");
        }
        return buf.toString();
    }

    private static boolean isQualifierUnnecessary(PsiElement qualifier, PsiClass containingClass) {
        PsiReferenceExpression reference;
        if (qualifier instanceof PsiReferenceExpression && (reference = (PsiReferenceExpression)qualifier).resolve() instanceof PsiClass && reference.getQualifier() == null && PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)qualifier, (boolean)false)) {
            return true;
        }
        return qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null;
    }

    private static boolean isInferredSameTypeAfterConversion(PsiLambdaExpression lambdaExpression, PsiMethodReferenceExpression methodReferenceExpression) {
        PsiMethodReferenceExpression methodReferenceInCopy;
        PsiCall call = LambdaUtil.treeWalkUp((PsiElement)methodReferenceExpression);
        if (call == null) {
            return true;
        }
        Object marker = new Object();
        PsiTreeUtil.mark((PsiElement)methodReferenceExpression, (Object)marker);
        PsiCall copyTopLevelCall = LambdaUtil.copyTopLevelCall((PsiCall)call);
        if (copyTopLevelCall != null && (methodReferenceInCopy = (PsiMethodReferenceExpression)PsiTreeUtil.releaseMark((PsiElement)copyTopLevelCall, (Object)marker)) != null) {
            PsiClassType functionalInterfaceType = (PsiClassType)ObjectUtils.tryCast((Object)methodReferenceInCopy.getFunctionalInterfaceType(), PsiClassType.class);
            if (functionalInterfaceType == null) {
                return false;
            }
            PsiClassType.ClassResolveResult funcResult = functionalInterfaceType.resolveGenerics();
            PsiClass funcClass = funcResult.getElement();
            PsiSubstitutor funcSubstitutor = funcResult.getSubstitutor();
            PsiLambdaExpression lambdaCopy = (PsiLambdaExpression)methodReferenceInCopy.replace((PsiElement)lambdaExpression);
            PsiClassType lambdaCopyType = (PsiClassType)lambdaCopy.getFunctionalInterfaceType();
            if (lambdaCopyType == null) {
                return false;
            }
            PsiClassType.ClassResolveResult lambdaCopyResult = lambdaCopyType.resolveGenerics();
            PsiClass lambdaCopyClass = lambdaCopyResult.getElement();
            PsiSubstitutor lambdaCopySubstitutor = lambdaCopyResult.getSubstitutor();
            return lambdaExpression.getManager().areElementsEquivalent((PsiElement)funcClass, (PsiElement)lambdaCopyClass) && funcSubstitutor.equals(lambdaCopySubstitutor);
        }
        return false;
    }

    public static void simplifyToExpressionLambda(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body2;
        PsiExpression singleExpression;
        if (lambdaExpression == null) {
            LambdaRefactoringUtil.$$$reportNull$$$0(0);
        }
        if ((singleExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(body2 = lambdaExpression.getBody())) != null) {
            body2.replace((PsiElement)singleExpression);
        }
    }

    public static void removeSideEffectsFromLambdaBody(Editor editor, PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null && lambdaExpression.isValid()) {
            PsiElement body2 = lambdaExpression.getBody();
            PsiExpression methodCall = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2);
            PsiExpression qualifierExpression2 = null;
            if (methodCall instanceof PsiMethodCallExpression) {
                qualifierExpression2 = ((PsiMethodCallExpression)methodCall).getMethodExpression().getQualifierExpression();
            } else if (methodCall instanceof PsiNewExpression) {
                qualifierExpression2 = ((PsiNewExpression)methodCall).getQualifier();
            }
            if (qualifierExpression2 != null) {
                ArrayList<PsiExpression> sideEffects = new ArrayList<PsiExpression>();
                if (ExpressionUtils.isNewObject(qualifierExpression2)) {
                    sideEffects.add(qualifierExpression2);
                } else {
                    SideEffectChecker.checkSideEffects(qualifierExpression2, sideEffects);
                }
                if (!sideEffects.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)lambdaExpression.getProject(), (String)JavaRefactoringBundle.message((String)"lambda.to.reference.side.effect.warning.message", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"side.effects.detected.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0)) {
                    qualifierExpression2.putUserData(ElementToWorkOn.PARENT, (Object)lambdaExpression);
                    new IntroduceVariableHandler().invoke(qualifierExpression2.getProject(), editor, qualifierExpression2);
                }
            }
        }
    }

    public static boolean canConvertToLambdaWithoutSideEffects(PsiMethodReferenceExpression methodReferenceExpression) {
        if (!LambdaRefactoringUtil.canConvertToLambda(methodReferenceExpression)) {
            return false;
        }
        PsiExpression qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodReferenceExpression.getQualifierExpression());
        return qualifierExpression2 == null || !SideEffectChecker.mayHaveSideEffects(qualifierExpression2) && !ExpressionUtils.isNewObject(qualifierExpression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "com/intellij/refactoring/util/LambdaRefactoringUtil", "simplifyToExpressionLambda"));
    }
}

