/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class WrapReturnValue
extends FixableUsageInfo {
    private final PsiReturnStatement myStatement;
    private final String myType;

    public WrapReturnValue(@NotNull PsiReturnStatement statement, @NotNull String type2) {
        if (statement == null) {
            WrapReturnValue.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            WrapReturnValue.$$$reportNull$$$0(1);
        }
        super((PsiElement)statement);
        this.myStatement = statement;
        this.myType = type2;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiExpression returnValue = this.myStatement.getReturnValue();
        assert (returnValue != null);
        String newExpression = "new " + this.myType + '(' + returnValue.getText() + ')';
        MutationUtils.replaceExpression(newExpression, returnValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/wrapreturnvalue/usageInfo/WrapReturnValue";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

