/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.execution.filters.ArithmeticExceptionInfo;
import com.intellij.execution.filters.ArrayCopyIndexOutOfBoundsExceptionInfo;
import com.intellij.execution.filters.ArrayIndexOutOfBoundsExceptionInfo;
import com.intellij.execution.filters.AssertionErrorInfo;
import com.intellij.execution.filters.ClassCastExceptionInfo;
import com.intellij.execution.filters.ExceptionAnalysisProvider;
import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.JetBrainsNotNullInstrumentationExceptionInfo;
import com.intellij.execution.filters.NegativeArraySizeExceptionInfo;
import com.intellij.execution.filters.NullPointerExceptionInfo;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.slicer.AnalysisStartingPoint;
import com.intellij.slicer.DfaBasedFilter;
import com.intellij.slicer.JavaValueFilter;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.StackFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataflowExceptionAnalysisProvider
implements ExceptionAnalysisProvider {
    private final Project myProject;

    public DataflowExceptionAnalysisProvider(Project project) {
        this.myProject = project;
    }

    @Nullable
    public AnAction getAnalysisAction(@NotNull PsiElement anchor, @NotNull ExceptionInfo info, @NotNull Supplier<List<ExceptionAnalysisProvider.StackLine>> nextFrames) {
        if (anchor == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(0);
        }
        if (info == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(1);
        }
        if (nextFrames == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(2);
        }
        AnalysisStartingPoint analysis = this.getAnalysis(anchor, info);
        return this.createAction(analysis, nextFrames);
    }

    @Nullable
    public AnAction getIntermediateRowAnalysisAction(@NotNull PsiElement anchor, @NotNull Supplier<List<ExceptionAnalysisProvider.StackLine>> nextFrames) {
        if (anchor == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(3);
        }
        if (nextFrames == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(4);
        }
        AnalysisStartingPoint analysis = DataflowExceptionAnalysisProvider.getIntermediateRowAnalysis(anchor);
        return this.createAction(analysis, nextFrames);
    }

    @Nullable
    private static AnalysisStartingPoint getIntermediateRowAnalysis(@NotNull PsiElement anchor) {
        if (anchor == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(5);
        }
        if (anchor instanceof PsiExpression) {
            return new AnalysisStartingPoint(DfTypes.NULL, (PsiExpression)anchor);
        }
        if (!(anchor instanceof PsiIdentifier)) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)anchor.getParent(), PsiReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        if (!JavaMethodContractUtil.isPure(method)) {
            return null;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, (PsiCallExpression)call);
        if (contracts2.isEmpty() || contracts2.size() > 2) {
            return null;
        }
        MethodContract failContract = contracts2.get(0);
        if (failContract.getReturnValue() != ContractReturnValue.fail()) {
            return null;
        }
        if (contracts2.size() == 2 && !(contracts2.get(1).getReturnValue() instanceof ContractReturnValue.ParameterReturnValue)) {
            return null;
        }
        ContractValue condition2 = (ContractValue)ContainerUtil.getOnlyItem(failContract.getConditions());
        if (condition2 == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        PsiExpression arg = DataflowExceptionAnalysisProvider.getArgFromContract(args, condition2, ContractValue.nullValue(), true);
        if (arg != null) {
            return AnalysisStartingPoint.create(DfTypes.NULL, arg);
        }
        arg = DataflowExceptionAnalysisProvider.getArgFromContract(args, condition2, ContractValue.nullValue(), false);
        if (arg != null) {
            return AnalysisStartingPoint.create(DfTypes.NOT_NULL_OBJECT, arg);
        }
        arg = DataflowExceptionAnalysisProvider.getArgFromContract(args, condition2, ContractValue.booleanValue(true), true);
        if (arg != null) {
            return AnalysisStartingPoint.fromCondition(arg);
        }
        arg = DataflowExceptionAnalysisProvider.getArgFromContract(args, condition2, ContractValue.booleanValue(false), true);
        if (arg != null) {
            return AnalysisStartingPoint.tryNegate(AnalysisStartingPoint.fromCondition(arg));
        }
        return null;
    }

    @Nullable
    private static PsiExpression getArgFromContract(PsiExpression[] args, ContractValue condition2, ContractValue expectedValue, boolean equal) {
        int pos = condition2.getArgumentComparedTo(expectedValue, equal).orElse(-1);
        if (pos < 0 || pos >= args.length) {
            return null;
        }
        return args[pos];
    }

    @Nullable
    private AnalysisStartingPoint getAnalysis(@NotNull PsiElement anchor, @NotNull ExceptionInfo info) {
        PsiNewExpression exceptionConstructor;
        if (anchor == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(6);
        }
        if (info == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(7);
        }
        if (anchor instanceof PsiKeyword && anchor.textMatches((CharSequence)"new") && (exceptionConstructor = (PsiNewExpression)ObjectUtils.tryCast((Object)anchor.getParent(), PsiNewExpression.class)) != null && !exceptionConstructor.isArrayCreation()) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)ExpressionUtils.getTopLevelExpression((PsiExpression)exceptionConstructor).getParent(), PsiThrowStatement.class);
            if (throwStatement == null) {
                return null;
            }
            return DataflowExceptionAnalysisProvider.fromThrowStatement(throwStatement);
        }
        if (info instanceof AssertionErrorInfo) {
            return DataflowExceptionAnalysisProvider.fromAssertionError(anchor);
        }
        if (info instanceof ArrayIndexOutOfBoundsExceptionInfo) {
            Integer index = ((ArrayIndexOutOfBoundsExceptionInfo)info).getIndex();
            if (index != null && anchor instanceof PsiExpression) {
                return AnalysisStartingPoint.create(DfTypes.intValue(index), (PsiExpression)anchor);
            }
        } else {
            if (info instanceof ClassCastExceptionInfo) {
                return this.fromClassCastException(anchor, ((ClassCastExceptionInfo)info).getActualClass());
            }
            if (info instanceof NullPointerExceptionInfo || info instanceof JetBrainsNotNullInstrumentationExceptionInfo) {
                return AnalysisStartingPoint.create(DfTypes.NULL, (PsiExpression)ObjectUtils.tryCast((Object)anchor, PsiExpression.class));
            }
            if (info instanceof NegativeArraySizeExceptionInfo) {
                Integer size = ((NegativeArraySizeExceptionInfo)info).getSuppliedSize();
                if (size != null && size < 0 && anchor instanceof PsiExpression) {
                    return AnalysisStartingPoint.create(DfTypes.intValue(size), (PsiExpression)anchor);
                }
            } else {
                if (info instanceof ArithmeticExceptionInfo) {
                    return DataflowExceptionAnalysisProvider.fromArithmeticException(anchor);
                }
                if (info instanceof ArrayCopyIndexOutOfBoundsExceptionInfo && anchor instanceof PsiExpression) {
                    return AnalysisStartingPoint.create(DfTypes.intValue(((ArrayCopyIndexOutOfBoundsExceptionInfo)info).getValue()), (PsiExpression)anchor);
                }
            }
        }
        return null;
    }

    private static AnalysisStartingPoint fromArithmeticException(PsiElement anchor) {
        if (anchor instanceof PsiExpression) {
            PsiExpression divisor = (PsiExpression)anchor;
            PsiType type2 = divisor.getType();
            if (PsiType.LONG.equals((Object)type2)) {
                return AnalysisStartingPoint.create(DfTypes.longValue(0L), divisor);
            }
            if (TypeConversionUtil.isIntegralNumberType((PsiType)type2)) {
                return AnalysisStartingPoint.create(DfTypes.intValue(0), divisor);
            }
        }
        return null;
    }

    @Nullable
    private static AnalysisStartingPoint fromThrowStatement(PsiThrowStatement throwStatement) {
        PsiElement parent = throwStatement.getParent();
        if (parent instanceof PsiCodeBlock) {
            PsiElement statement = throwStatement.getPrevSibling();
            while (statement != null) {
                if ((statement = statement.getPrevSibling()) instanceof PsiIfStatement) {
                    boolean elseExits;
                    PsiIfStatement ifStatement = (PsiIfStatement)statement;
                    boolean thenExits = ifStatement.getThenBranch() != null && !ControlFlowUtils.statementMayCompleteNormally(ifStatement.getThenBranch());
                    boolean bl = elseExits = ifStatement.getElseBranch() != null && !ControlFlowUtils.statementMayCompleteNormally(ifStatement.getElseBranch());
                    if (thenExits != elseExits) {
                        AnalysisStartingPoint analysis = AnalysisStartingPoint.fromCondition(ifStatement.getCondition());
                        return thenExits ? AnalysisStartingPoint.tryNegate(analysis) : analysis;
                    }
                }
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                return DataflowExceptionAnalysisProvider.fromSwitchLabel((PsiSwitchLabelStatementBase)((PsiSwitchLabelStatement)statement));
            }
            if (parent.getParent() instanceof PsiBlockStatement) {
                parent = parent.getParent().getParent();
            } else {
                return null;
            }
        }
        if (parent instanceof PsiIfStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiIfStatement)parent).getThenBranch(), (PsiElement)throwStatement, (boolean)false)) {
            PsiExpression cond = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiIfStatement)parent).getCondition());
            return AnalysisStartingPoint.fromCondition(cond);
        }
        if (parent instanceof PsiSwitchLabeledRuleStatement) {
            return DataflowExceptionAnalysisProvider.fromSwitchLabel((PsiSwitchLabelStatementBase)((PsiSwitchLabeledRuleStatement)parent));
        }
        return null;
    }

    @Nullable
    private static AnalysisStartingPoint fromSwitchLabel(PsiSwitchLabelStatementBase label) {
        PsiSwitchBlock block = label.getEnclosingSwitchBlock();
        if (block == null) {
            return null;
        }
        boolean hasDefault = false;
        ArrayList<PsiExpression> labels2 = new ArrayList<PsiExpression>();
        if (label.isDefaultCase()) {
            hasDefault = true;
        } else {
            PsiExpressionList values = label.getCaseValues();
            if (values == null) {
                return null;
            }
            labels2.addAll(Arrays.asList(values.getExpressions()));
        }
        if (label instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatementBase prev = label;
            while (true) {
                if (!((prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class)) instanceof PsiSwitchLabelStatement)) {
                    if (prev == null || !ControlFlowUtils.statementMayCompleteNormally((PsiStatement)prev)) break;
                    return null;
                }
                if (((PsiSwitchLabelStatement)prev).isDefaultCase()) {
                    hasDefault = true;
                    continue;
                }
                PsiExpressionList prevValues = ((PsiSwitchLabelStatement)prev).getCaseValues();
                if (prevValues == null) {
                    return null;
                }
                labels2.addAll(Arrays.asList(prevValues.getExpressions()));
            }
        }
        if (hasDefault) {
            ArrayList<PsiExpression> allLabels = new ArrayList<PsiExpression>();
            for (PsiExpressionList statement : Objects.requireNonNull(block.getBody()).getStatements()) {
                PsiSwitchLabelStatementBase labelStatement;
                if (!(statement instanceof PsiSwitchLabelStatementBase) || (labelStatement = (PsiSwitchLabelStatementBase)statement).isDefaultCase()) continue;
                PsiExpressionList caseValues2 = labelStatement.getCaseValues();
                if (caseValues2 == null) {
                    return null;
                }
                allLabels.addAll(Arrays.asList(caseValues2.getExpressions()));
            }
            allLabels.removeAll(labels2);
            labels2 = allLabels;
        }
        PsiExpression selector2 = block.getExpression();
        AnalysisStartingPoint result = null;
        for (PsiExpression labelValue : labels2) {
            DfType type2 = AnalysisStartingPoint.fromConstant(labelValue);
            if (type2 == null) {
                return null;
            }
            AnalysisStartingPoint next = AnalysisStartingPoint.create(type2, selector2);
            if (hasDefault) {
                next = AnalysisStartingPoint.tryNegate(next);
            }
            if (next == null) {
                return null;
            }
            if (result == null) {
                result = next;
                continue;
            }
            result = hasDefault ? result.tryMeet(next) : result.tryJoin(next);
            if (result != null) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private AnalysisStartingPoint fromClassCastException(@NotNull PsiElement anchor, @Nullable String actualClass) {
        PsiType psiType;
        if (anchor == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(8);
        }
        if (!(anchor instanceof PsiTypeElement)) {
            return null;
        }
        PsiTypeCastExpression castExpression = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)anchor.getParent(), PsiTypeCastExpression.class);
        if (castExpression == null) {
            return null;
        }
        PsiExpression ref = AnalysisStartingPoint.extractAnchor(castExpression.getOperand());
        if (ref == null) {
            return null;
        }
        if (actualClass != null && (psiType = this.getPsiType(actualClass)) != null) {
            return new AnalysisStartingPoint(TypeConstraints.exact(psiType).asDfType().meet(DfTypes.NOT_NULL_OBJECT), ref);
        }
        PsiType castType = castExpression.getType();
        if (castType != null) {
            return AnalysisStartingPoint.tryNegate(new AnalysisStartingPoint(DfTypes.typedObject(castType, Nullability.NULLABLE), ref));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private PsiType getPsiType(String classCastExceptionType) {
        String className2;
        int dim;
        block10: {
            dim = 0;
            while (classCastExceptionType.startsWith("[", dim)) {
                ++dim;
            }
            if (dim > 0) {
                if (classCastExceptionType.startsWith("L", dim) && classCastExceptionType.endsWith(";")) {
                    className2 = classCastExceptionType.substring(dim + 1, classCastExceptionType.length() - 1);
                    break block10;
                } else {
                    PsiPrimitiveType type2;
                    if (classCastExceptionType.length() == dim + 1 && (type2 = PsiPrimitiveType.fromJvmTypeDescriptor((char)classCastExceptionType.charAt(dim))) != null) {
                        while (true) {
                            if (dim-- <= 0) {
                                return type2;
                            }
                            type2 = type2.createArrayType();
                        }
                    }
                    return null;
                }
            }
            className2 = classCastExceptionType;
        }
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)className2, null, (boolean)true);
        if (psiClass == null) {
            return null;
        }
        PsiClassType type3 = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(psiClass);
        while (dim-- > 0) {
            type3 = type3.createArrayType();
        }
        return type3;
    }

    @Nullable
    private static AnalysisStartingPoint fromAssertionError(@NotNull PsiElement anchor) {
        if (anchor == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(9);
        }
        if (anchor instanceof PsiAssertStatement) {
            return AnalysisStartingPoint.tryNegate(AnalysisStartingPoint.fromCondition(((PsiAssertStatement)anchor).getAssertCondition()));
        }
        return null;
    }

    @Nullable
    private AnAction createAction(@Nullable AnalysisStartingPoint analysis, @NotNull Supplier<List<ExceptionAnalysisProvider.StackLine>> nextFramesSupplier) {
        if (nextFramesSupplier == null) {
            DataflowExceptionAnalysisProvider.$$$reportNull$$$0(10);
        }
        if (analysis == null) {
            return null;
        }
        String text2 = DfaBasedFilter.getPresentationText(analysis.myDfType, analysis.myAnchor.getType());
        if (text2.isEmpty()) {
            return null;
        }
        return new DfaFromStacktraceAction(analysis, text2, nextFramesSupplier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextFrames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextFramesSupplier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/slicer/DataflowExceptionAnalysisProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnalysisAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntermediateRowAnalysisAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntermediateRowAnalysis";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnalysis";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fromClassCastException";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fromAssertionError";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class DfaFromStacktraceAction
    extends AnAction {
        @NotNull
        private final AnalysisStartingPoint myAnalysis;
        @NotNull
        private final Supplier<List<ExceptionAnalysisProvider.StackLine>> myNextFramesSupplier;

        private DfaFromStacktraceAction(AnalysisStartingPoint analysis, @NotNull String text2, Supplier<List<ExceptionAnalysisProvider.StackLine>> nextFramesSupplier) {
            if (analysis == null) {
                DfaFromStacktraceAction.$$$reportNull$$$0(0);
            }
            if (nextFramesSupplier == null) {
                DfaFromStacktraceAction.$$$reportNull$$$0(1);
            }
            super(null, JavaBundle.message((String)"action.dfa.from.stacktrace.text", (Object[])new Object[]{analysis.myAnchor.getText(), text2}), null);
            this.myAnalysis = analysis;
            this.myNextFramesSupplier = nextFramesSupplier;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DfaFromStacktraceAction.$$$reportNull$$$0(2);
            }
            List<ExceptionAnalysisProvider.StackLine> nextFrames = this.myNextFramesSupplier.get();
            StackFilter stackFilter = StackFilter.from(nextFrames);
            SliceAnalysisParams params = new SliceAnalysisParams();
            params.dataFlowToThis = true;
            params.scope = new AnalysisScope((SearchScope)GlobalSearchScope.allScope((Project)DataflowExceptionAnalysisProvider.this.myProject), DataflowExceptionAnalysisProvider.this.myProject);
            params.scope.setSearchInLibraries(true);
            params.valueFilter = new JavaValueFilter(new DfaBasedFilter(this.myAnalysis.myDfType), stackFilter);
            SliceManager.getInstance((Project)DataflowExceptionAnalysisProvider.this.myProject).createToolWindow((PsiElement)this.myAnalysis.myAnchor, params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analysis";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nextFramesSupplier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/slicer/DataflowExceptionAnalysisProvider$DfaFromStacktraceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

