/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.core.JavaPsiBundle;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JavaUsageViewDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            JavaUsageViewDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            JavaUsageViewDescriptionProvider.$$$reportNull$$$0(1);
        }
        if (location instanceof UsageViewShortNameLocation) {
            if (element instanceof PsiThrowStatement) {
                return JavaBundle.message((String)"usage.target.exception", (Object[])new Object[0]);
            }
            if (element instanceof PsiAnonymousClass) {
                String name2 = ((PsiAnonymousClass)element).getBaseClassReference().getReferenceName();
                return "anonymous " + StringUtil.notNullize((String)name2, (String)"class");
            }
            if (element instanceof PsiClassInitializer) {
                boolean isStatic = ((PsiClassInitializer)element).hasModifierProperty("static");
                return isStatic ? "<clinit>" : "<init>";
            }
        }
        if (location instanceof UsageViewLongNameLocation) {
            if (element instanceof PsiPackage) {
                return ((PsiPackage)element).getQualifiedName();
            }
            if (element instanceof PsiClass) {
                if (element instanceof PsiAnonymousClass) {
                    String name3 = ((PsiAnonymousClass)element).getBaseClassReference().getReferenceName();
                    return name3 != null ? JavaPsiBundle.message((String)"java.terms.anonymous.class.base.ref", (Object[])new Object[]{name3}) : JavaPsiBundle.message((String)"java.terms.anonymous.class", (Object[])new Object[0]);
                }
                String ret = ((PsiClass)element).getQualifiedName();
                if (ret == null) {
                    ret = ((PsiClass)element).getName();
                }
                return (String)ObjectUtils.notNull((Object)ret, (Object)"");
            }
            if (element instanceof PsiVariable) {
                return ((PsiVariable)element).getName();
            }
            if (element instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)element;
                return PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/usageView/JavaUsageViewDescriptionProvider";
        objectArray[2] = "getElementDescription";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

