/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ComparableImplementedButEqualsNotOverriddenInspection
extends BaseInspection {
    @VisibleForTesting
    static final String ADD_NOTE_FIX_NAME = "Add 'ordering inconsistent with equals' JavaDoc note";
    @VisibleForTesting
    static final String GENERATE_EQUALS_FIX_NAME = "Generate 'equals()' method";

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.problem.descriptor", new Object[0]);
        if (string == null) {
            ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        if (infos[0] instanceof PsiAnonymousClass) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new GenerateEqualsMethodFix()};
            if (inspectionGadgetsFixArray == null) {
                ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(1);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new GenerateEqualsMethodFix(), new AddNoteFix()};
        if (inspectionGadgetsFixArray == null) {
            ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareToAndEqualsNotPairedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CompareToAndEqualsNotPairedVisitor
    extends BaseInspectionVisitor {
        private CompareToAndEqualsNotPairedVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (aClass.isInterface()) {
                return;
            }
            PsiClass comparableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Comparable", aClass.getResolveScope());
            if (comparableClass == null || !aClass.isInheritor(comparableClass, true)) {
                return;
            }
            PsiMethod[] comparableMethods = comparableClass.findMethodsByName("compareTo", false);
            if (comparableMethods.length == 0) {
                return;
            }
            PsiMethod comparableMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)comparableMethods[0], (boolean)false);
            if (comparableMethod == null || comparableMethod.hasModifierProperty("abstract") || comparableMethod.getBody() == null) {
                return;
            }
            PsiClass objectClass = ClassUtils.findObjectClass((PsiElement)aClass);
            if (objectClass == null) {
                return;
            }
            PsiMethod[] equalsMethods = objectClass.findMethodsByName("equals", false);
            if (equalsMethods.length != 1) {
                return;
            }
            PsiMethod equalsMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)equalsMethods[0], (boolean)false);
            if (equalsMethod != null && !equalsMethod.hasModifierProperty("abstract")) {
                return;
            }
            String docCommentText = StringUtil.collapseWhiteSpace((CharSequence)CompareToAndEqualsNotPairedVisitor.getActualCommentText(aClass.getDocComment()));
            if (StringUtil.containsIgnoreCase((String)docCommentText, (String)"this class has a natural ordering that is inconsistent with equals")) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static String getActualCommentText(PsiDocComment comment) {
            if (comment == null) {
                return "";
            }
            return Arrays.stream(comment.getChildren()).filter(e -> e instanceof PsiDocToken && ((PsiDocToken)e).getTokenType() == JavaDocTokenType.DOC_COMMENT_DATA).map(PsiElement::getText).collect(Collectors.joining());
        }
    }

    private static class AddNoteFix
    extends InspectionGadgetsFix {
        private static final Pattern PARAM_PATTERN = Pattern.compile("\\*[ \t]+@");
        private static final String NOTE = " * Note: this class has a natural ordering that is inconsistent with equals.\n";

        private AddNoteFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return ComparableImplementedButEqualsNotOverriddenInspection.ADD_NOTE_FIX_NAME;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiClass aClass = (PsiClass)descriptor.getPsiElement().getParent();
            PsiDocComment comment = aClass.getDocComment();
            if (comment == null) {
                PsiDocComment newComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText("/**\n * Note: this class has a natural ordering that is inconsistent with equals.\n*/", (PsiElement)aClass);
                aClass.addBefore((PsiElement)newComment, aClass.getFirstChild());
            } else {
                String text2 = comment.getText();
                Matcher matcher = PARAM_PATTERN.matcher(text2);
                String newCommentText = matcher.find() ? text2.substring(0, matcher.start()) + NOTE + text2.substring(matcher.start()) : text2.substring(0, text2.length() - 2) + NOTE + "*/";
                PsiDocComment newComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText(newCommentText);
                comment.replace((PsiElement)newComment);
            }
        }
    }

    private static class GenerateEqualsMethodFix
    extends InspectionGadgetsFix {
        private GenerateEqualsMethodFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return ComparableImplementedButEqualsNotOverriddenInspection.GENERATE_EQUALS_FIX_NAME;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiClass aClass = (PsiClass)descriptor.getPsiElement().getParent();
            StringBuilder methodText = new StringBuilder();
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)aClass)) {
                methodText.append("@java.lang.Override ");
            }
            methodText.append("public ");
            methodText.append("boolean equals(Object o) {\n");
            methodText.append("if (!(o instanceof ").append(aClass.getName()).append("))").append("return false;");
            methodText.append("return compareTo((").append(aClass.getName()).append(")o)==0;\n");
            methodText.append("}");
            PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(methodText.toString(), (PsiElement)aClass, PsiUtil.getLanguageLevel((PsiElement)aClass));
            PsiElement newMethod = aClass.add((PsiElement)method);
            CodeStyleManager.getInstance((Project)project).reformat(newMethod);
        }
    }
}

