/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InnerClassReferencedViaSubclassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("inner.class.referenced.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
        if (string == null) {
            InnerClassReferencedViaSubclassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InnerClassReferencedViaSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassReferencedViaSubclassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/InnerClassReferencedViaSubclassInspection", "buildErrorString"));
    }

    private static class InnerClassReferencedViaSubclassVisitor
    extends BaseInspectionVisitor {
        private InnerClassReferencedViaSubclassVisitor() {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement qualifier = reference.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiJavaCodeReferenceElement qualifierReference = (PsiJavaCodeReferenceElement)qualifier;
            PsiElement qualifierTarget = qualifierReference.resolve();
            if (!(qualifierTarget instanceof PsiClass)) {
                return;
            }
            PsiClass qualifierClass = (PsiClass)qualifierTarget;
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!qualifierClass.isInheritor(containingClass, true)) {
                return;
            }
            PsiElement identifier = reference.getReferenceNameElement();
            if (identifier == null) {
                return;
            }
            this.registerError(identifier, containingClass, qualifierClass);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }
    }

    private static class InnerClassReferencedViaSubclassFix
    extends InspectionGadgetsFix {
        private InnerClassReferencedViaSubclassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inner.class.referenced.via.subclass.quickfix", new Object[0]);
            if (string == null) {
                InnerClassReferencedViaSubclassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIdentifier name2 = (PsiIdentifier)descriptor.getPsiElement();
            PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)name2.getParent();
            PsiClass aClass = (PsiClass)reference.resolve();
            if (aClass == null) {
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)reference.getProject());
            Object newReferenceElement = reference instanceof PsiReferenceExpression ? factory.createReferenceExpression(containingClass) : factory.createClassReferenceElement(containingClass);
            PsiElement qualifier = reference.getQualifier();
            if (qualifier == null) {
                return;
            }
            qualifier.replace((PsiElement)newReferenceElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/InnerClassReferencedViaSubclassInspection$InnerClassReferencedViaSubclassFix", "getFamilyName"));
        }
    }
}

