/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SuspiciousComparatorCompareInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getShortName() {
        return "ComparatorMethodParameterNotUsed";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousComparatorCompareVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection", "buildErrorString"));
    }

    private static class SuspiciousComparatorCompareVisitor
    extends BaseInspectionVisitor {
        private SuspiciousComparatorCompareVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!MethodUtils.isComparatorCompare(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.check((PsiParameterListOwner)method);
        }

        public void visitLambdaExpression(PsiLambdaExpression lambda2) {
            super.visitLambdaExpression(lambda2);
            PsiClass functionalInterface = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)lambda2);
            if (functionalInterface == null || !"java.util.Comparator".equals(functionalInterface.getQualifiedName()) || ControlFlowUtils.lambdaExpressionAlwaysThrowsException(lambda2)) {
                return;
            }
            this.check((PsiParameterListOwner)lambda2);
        }

        private void check(PsiParameterListOwner owner2) {
            MethodContract contract;
            PsiStatement statement;
            PsiParameterList parameterList = owner2.getParameterList();
            PsiElement body2 = owner2.getBody();
            if (body2 == null || parameterList.getParametersCount() != 2) {
                return;
            }
            if (body2 instanceof PsiExpression && ExpressionUtils.isZero((PsiExpression)body2)) {
                return;
            }
            if (body2 instanceof PsiCodeBlock && (statement = ControlFlowUtils.getOnlyStatementInBlock((PsiCodeBlock)body2)) instanceof PsiReturnStatement && ExpressionUtils.isZero(((PsiReturnStatement)statement).getReturnValue())) {
                return;
            }
            PsiMethodCallExpression soleCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2), PsiMethodCallExpression.class);
            if (soleCall != null && (contract = (MethodContract)ContainerUtil.getOnlyItem(JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)soleCall))) != null && contract.isTrivial() && contract.getReturnValue().isFail()) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.checkParameterList(parameters2, body2);
            this.checkReflexivity(owner2, parameters2, body2);
        }

        private void checkParameterList(PsiParameter[] parameters2, PsiElement context) {
            ParameterAccessVisitor visitor2 = new ParameterAccessVisitor(parameters2);
            context.accept((PsiElementVisitor)visitor2);
            for (PsiParameter unusedParameter : visitor2.getUnusedParameters()) {
                this.registerVariableError((PsiVariable)unusedParameter, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.parameter.not.used", new Object[0]));
            }
        }

        private void checkReflexivity(PsiParameterListOwner owner2, final PsiParameter[] parameters2, PsiElement body2) {
            ComparatorVisitor visitor2;
            DataFlowRunner runner = new DataFlowRunner(owner2.getProject(), body2){

                @Override
                @NotNull
                protected DfaMemoryState createMemoryState() {
                    DfaMemoryState state = super.createMemoryState();
                    DfaVariableValue var1 = this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameters2[0]);
                    DfaVariableValue var2 = this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameters2[1]);
                    state.applyCondition(var1.eq(var2));
                    DfaMemoryState dfaMemoryState = state;
                    if (dfaMemoryState == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return dfaMemoryState;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$1", "createMemoryState"));
                }
            };
            if (runner.analyzeMethod(body2, visitor2 = new ComparatorVisitor(owner2)) != RunnerResult.OK) {
                return;
            }
            if (visitor2.myRange.contains(0L) || visitor2.myContexts.isEmpty()) {
                return;
            }
            PsiElement context = null;
            if (visitor2.myContexts.size() == 1) {
                context = (PsiElement)visitor2.myContexts.iterator().next();
            } else {
                PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement[])visitor2.myContexts.toArray(PsiElement.EMPTY_ARRAY));
                if (commonParent instanceof PsiExpression) {
                    context = commonParent;
                } else {
                    PsiParameterListOwner parent = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)body2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                    if (parent instanceof PsiMethod) {
                        context = ((PsiMethod)parent).getNameIdentifier();
                    } else if (parent instanceof PsiLambdaExpression) {
                        context = parent.getParameterList();
                    }
                }
            }
            this.registerError(context != null ? context : body2, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.non.reflexive", new Object[0]));
        }

        private static class ParameterAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiParameter> parameters;

            private ParameterAccessVisitor(PsiParameter @NotNull [] parameters2) {
                if (parameters2 == null) {
                    ParameterAccessVisitor.$$$reportNull$$$0(0);
                }
                this.parameters = ContainerUtil.set((Object[])parameters2);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter2 = (PsiParameter)target;
                this.parameters.remove(parameter2);
                if (this.parameters.isEmpty()) {
                    this.stopWalking();
                }
            }

            private Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$ParameterAccessVisitor", "<init>"));
            }
        }

        private static class ComparatorVisitor
        extends StandardInstructionVisitor {
            private final PsiParameterListOwner myOwner;
            private final Set<PsiElement> myContexts = new HashSet<PsiElement>();
            LongRangeSet myRange = LongRangeSet.empty();

            private ComparatorVisitor(PsiParameterListOwner owner2) {
                this.myOwner = owner2;
            }

            @Override
            protected void checkReturnValue(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @NotNull PsiParameterListOwner owner2, @NotNull DfaMemoryState state) {
                if (value2 == null) {
                    ComparatorVisitor.$$$reportNull$$$0(0);
                }
                if (expression2 == null) {
                    ComparatorVisitor.$$$reportNull$$$0(1);
                }
                if (owner2 == null) {
                    ComparatorVisitor.$$$reportNull$$$0(2);
                }
                if (state == null) {
                    ComparatorVisitor.$$$reportNull$$$0(3);
                }
                if (owner2 != this.myOwner) {
                    return;
                }
                this.myContexts.add((PsiElement)expression2);
                this.myRange = this.myRange.unite(DfIntType.extractRange(state.getDfType(value2)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "owner";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$ComparatorVisitor";
                objectArray[2] = "checkReturnValue";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

