/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SuspiciousSystemArraycopyInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            SuspiciousSystemArraycopyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousSystemArraycopyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection", "buildErrorString"));
    }

    private static class SuspiciousSystemArraycopyVisitor
    extends BaseInspectionVisitor {
        private SuspiciousSystemArraycopyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiType destType;
            if (expression2 == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiClassType objectType = TypeUtils.getObjectType((PsiElement)expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, "java.lang.System", (PsiType)PsiType.VOID, "arraycopy", new PsiType[]{objectType, PsiType.INT, objectType, PsiType.INT, PsiType.INT})) {
                return;
            }
            PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
            if (arguments.length != 5) {
                return;
            }
            PsiExpression srcPos = arguments[1];
            PsiExpression destPos = arguments[3];
            PsiExpression length = arguments[4];
            PsiExpression src = arguments[0];
            PsiExpression dest = arguments[2];
            this.checkRanges(src, srcPos, dest, destPos, length, expression2);
            PsiType srcType = src.getType();
            if (srcType == null) {
                return;
            }
            boolean notArrayReported = false;
            if (!(srcType instanceof PsiArrayType)) {
                this.registerError((PsiElement)src, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor4", new Object[0]));
                notArrayReported = true;
            }
            if ((destType = dest.getType()) == null) {
                return;
            }
            if (!(destType instanceof PsiArrayType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor5", new Object[0]));
                notArrayReported = true;
            }
            if (notArrayReported) {
                return;
            }
            PsiArrayType srcArrayType = (PsiArrayType)srcType;
            PsiArrayType destArrayType = (PsiArrayType)destType;
            PsiType srcComponentType = srcArrayType.getComponentType();
            PsiType destComponentType = destArrayType.getComponentType();
            if (!(srcComponentType instanceof PsiPrimitiveType)) {
                if (!destComponentType.isAssignableFrom(srcComponentType)) {
                    this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
                }
            } else if (!destComponentType.equals(srcComponentType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
            }
        }

        private void checkRanges(@NotNull PsiExpression src, @NotNull PsiExpression srcPos, @NotNull PsiExpression dest, @NotNull PsiExpression destPos, @NotNull PsiExpression length, @NotNull PsiMethodCallExpression call) {
            LongRangeSet destRange;
            CommonDataflow.DataflowResult result;
            if (src == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(1);
            }
            if (srcPos == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(2);
            }
            if (dest == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(3);
            }
            if (destPos == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(4);
            }
            if (length == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(5);
            }
            if (call == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(6);
            }
            if ((result = CommonDataflow.getDataflowResult(src)) == null) {
                return;
            }
            LongRangeSet srcLengthSet = DfIntType.extractRange(SpecialField.ARRAY_LENGTH.getFromQualifier(result.getDfType(src)));
            LongRangeSet destLengthSet = DfIntType.extractRange(SpecialField.ARRAY_LENGTH.getFromQualifier(result.getDfType(dest)));
            LongRangeSet srcPosSet = DfIntType.extractRange(result.getDfType(srcPos));
            LongRangeSet destPosSet = DfIntType.extractRange(result.getDfType(destPos));
            LongRangeSet lengthSet = DfIntType.extractRange(result.getDfType(length));
            LongRangeSet srcPossibleLengthToCopy = srcLengthSet.minus(srcPosSet, false);
            LongRangeSet destPossibleLengthToCopy = destLengthSet.minus(destPosSet, false);
            long lengthMin = lengthSet.min();
            if (lengthMin > destPossibleLengthToCopy.max()) {
                this.registerError((PsiElement)length, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor.length.bigger.dest", lengthSet.toString()));
                return;
            }
            if (lengthMin > srcPossibleLengthToCopy.max()) {
                this.registerError((PsiElement)length, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor.length.bigger.src", lengthSet.toString()));
                return;
            }
            if (!SuspiciousSystemArraycopyVisitor.isTheSameArray(src, dest)) {
                return;
            }
            LongRangeSet srcRange = SuspiciousSystemArraycopyVisitor.getDefiniteRange(srcPosSet, lengthSet);
            if (srcRange.intersects(destRange = SuspiciousSystemArraycopyVisitor.getDefiniteRange(destPosSet, lengthSet))) {
                PsiElement name2 = call.getMethodExpression().getReferenceNameElement();
                PsiMethodCallExpression elementToHighlight = name2 == null ? call : name2;
                this.registerError((PsiElement)elementToHighlight, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor.ranges.intersect", new Object[0]));
            }
        }

        @NotNull
        private static LongRangeSet getDefiniteRange(@NotNull LongRangeSet startSet, @NotNull LongRangeSet lengthSet) {
            LongRangeSet lengthMinusOne;
            long minRightBorder;
            long maxLeftBorder;
            if (startSet == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(7);
            }
            if (lengthSet == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(8);
            }
            if ((maxLeftBorder = startSet.max()) > (minRightBorder = startSet.plus(lengthMinusOne = lengthSet.minus(LongRangeSet.point(1L), false), false).min())) {
                LongRangeSet longRangeSet = LongRangeSet.empty();
                if (longRangeSet == null) {
                    SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(9);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = LongRangeSet.range(maxLeftBorder, minRightBorder);
            if (longRangeSet == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(10);
            }
            return longRangeSet;
        }

        private static boolean isTheSameArray(@NotNull PsiExpression src, @NotNull PsiExpression dest) {
            if (src == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(11);
            }
            if (dest == null) {
                SuspiciousSystemArraycopyVisitor.$$$reportNull$$$0(12);
            }
            PsiReferenceExpression srcReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)src), PsiReferenceExpression.class);
            PsiReferenceExpression destReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)dest), PsiReferenceExpression.class);
            if (srcReference == null || destReference == null) {
                return false;
            }
            PsiElement srcVariable = srcReference.resolve();
            PsiElement destVariable = destReference.resolve();
            return srcVariable != null && srcVariable == destVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "src";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "srcPos";
                    break;
                }
                case 3: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dest";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destPos";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "length";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startSet";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lengthSet";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection$SuspiciousSystemArraycopyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousSystemArraycopyInspection$SuspiciousSystemArraycopyVisitor";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefiniteRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "checkRanges";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefiniteRange";
                    break;
                }
                case 9: 
                case 10: {
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isTheSameArray";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

