/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMayBeInterfaceInspection
extends BaseInspection {
    public boolean reportClassesWithNonAbstractMethods = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.may.be.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassMayBeInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.may.be.interface.java8.option", new Object[0]), (InspectionProfileEntry)this, "reportClassesWithNonAbstractMethods");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ClassMayBeInterfaceInspection.$$$reportNull$$$0(1);
        }
        if (this.reportClassesWithNonAbstractMethods) {
            node.addContent(new Element("option").setAttribute("name", "reportClassesWithNonAbstractMethods").setAttribute("value", "true"));
        }
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ClassMayBeInterfaceFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassMayBeInterfaceVisitor();
    }

    static boolean isEmptyConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            ClassMayBeInterfaceInspection.$$$reportNull$$$0(2);
        }
        return method.isConstructor() && MethodUtils.isTrivial(method, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ClassMayBeInterfaceVisitor
    extends BaseInspectionVisitor {
        private ClassMayBeInterfaceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ClassMayBeInterfaceVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (PsiUtil.isLocalClass((PsiClass)aClass) && !HighlightingFeature.LOCAL_INTERFACES.isAvailable((PsiElement)aClass)) {
                return;
            }
            if (!this.mayBeInterface(aClass)) {
                return;
            }
            if (ClassUtils.isInnerClass(aClass)) {
                InnerClassReferenceVisitor visitor2 = new InnerClassReferenceVisitor(aClass);
                aClass.accept((PsiElementVisitor)visitor2);
                if (!visitor2.canInnerClassBeStatic()) {
                    return;
                }
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public boolean mayBeInterface(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] extendsElements;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && (extendsElements = extendsList.getReferenceElements()).length > 0) {
                return false;
            }
            PsiClassInitializer[] initializers = aClass.getInitializers();
            if (initializers.length > 0) {
                return false;
            }
            return this.allMethodsPublicAbstract(aClass) && this.allFieldsPublicStaticFinal(aClass) && this.allInnerClassesPublic(aClass);
        }

        private boolean allFieldsPublicStaticFinal(PsiClass aClass) {
            PsiField[] fields;
            boolean allFieldsStaticFinal = true;
            for (PsiField field : fields = aClass.getFields()) {
                if (field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasModifierProperty("public")) continue;
                allFieldsStaticFinal = false;
            }
            return allFieldsStaticFinal;
        }

        private boolean allMethodsPublicAbstract(PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (ClassMayBeInterfaceInspection.isEmptyConstructor(method)) continue;
                if (!method.hasModifierProperty("abstract")) {
                    if (MethodUtils.isToString(method) || MethodUtils.isHashCode(method) || MethodUtils.isEquals(method)) {
                        return false;
                    }
                    if (!ClassMayBeInterfaceInspection.this.reportClassesWithNonAbstractMethods || !PsiUtil.isLanguageLevel8OrHigher((PsiElement)aClass)) {
                        return false;
                    }
                }
                if (method.hasModifierProperty("public") && !method.hasModifierProperty("final")) continue;
                return false;
            }
            return true;
        }

        private boolean allInnerClassesPublic(PsiClass aClass) {
            PsiClass[] innerClasses;
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (innerClass.hasModifierProperty("public")) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceVisitor", "visitClass"));
        }
    }

    private static class ClassMayBeInterfaceFix
    extends InspectionGadgetsFix {
        private ClassMayBeInterfaceFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("class.may.be.interface.convert.quickfix", new Object[0]);
            if (string == null) {
                ClassMayBeInterfaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIdentifier classNameIdentifier = (PsiIdentifier)descriptor.getPsiElement();
            PsiClass interfaceClass = (PsiClass)classNameIdentifier.getParent();
            SearchScope searchScope = interfaceClass.getUseScope();
            ArrayList<PsiClass> elements = new ArrayList<PsiClass>();
            elements.add(interfaceClass);
            for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)interfaceClass, (SearchScope)searchScope, (boolean)false)) {
                elements.add(inheritor);
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                return;
            }
            WriteAction.run(() -> {
                ClassMayBeInterfaceFix.moveSubClassExtendsToImplements(elements);
                ClassMayBeInterfaceFix.changeClassToInterface(interfaceClass);
                ClassMayBeInterfaceFix.moveImplementsToExtends(interfaceClass);
            });
        }

        private static void changeClassToInterface(PsiClass aClass) {
            for (PsiMethod psiMethod : aClass.getMethods()) {
                if (ClassMayBeInterfaceInspection.isEmptyConstructor(psiMethod)) {
                    psiMethod.delete();
                    continue;
                }
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"public", (boolean)false);
                if (psiMethod.hasModifierProperty("static")) continue;
                if (psiMethod.hasModifierProperty("abstract")) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"abstract", (boolean)false);
                    continue;
                }
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"default", (boolean)true);
            }
            for (PsiMethod psiMethod : aClass.getFields()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"public", (boolean)false);
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"static", (boolean)false);
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"final", (boolean)false);
            }
            for (PsiMethod psiMethod : aClass.getInnerClasses()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)psiMethod, (String)"public", (boolean)false);
            }
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            PsiKeyword classKeyword = (PsiKeyword)PsiTreeUtil.getPrevSiblingOfType((PsiElement)nameIdentifier, PsiKeyword.class);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
            PsiKeyword psiKeyword = factory.createKeyword("interface");
            if (classKeyword == null) {
                return;
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"abstract", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"final", (boolean)false);
            classKeyword.replace((PsiElement)psiKeyword);
        }

        private static void moveImplementsToExtends(PsiClass anInterface) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiReferenceList extendsList = anInterface.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiReferenceList implementsList = anInterface.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = implementsList.getReferenceElements()) {
                extendsList.add((PsiElement)referenceElement);
                referenceElement.delete();
            }
        }

        private static void moveSubClassExtendsToImplements(List<PsiClass> inheritors) {
            PsiClass oldClass = inheritors.get(0);
            for (int i = 1; i < inheritors.size(); ++i) {
                PsiClass inheritor = inheritors.get(i);
                PsiReferenceList extendsList = inheritor.getExtendsList();
                if (extendsList == null) continue;
                PsiReferenceList implementsList = inheritor.getImplementsList();
                ClassMayBeInterfaceFix.moveReference(extendsList, implementsList, oldClass);
            }
        }

        private static void moveReference(@NotNull PsiReferenceList source, @Nullable PsiReferenceList target, @NotNull PsiClass oldClass) {
            PsiJavaCodeReferenceElement[] sourceReferences;
            if (source == null) {
                ClassMayBeInterfaceFix.$$$reportNull$$$0(1);
            }
            if (oldClass == null) {
                ClassMayBeInterfaceFix.$$$reportNull$$$0(2);
            }
            for (PsiJavaCodeReferenceElement sourceReference : sourceReferences = source.getReferenceElements()) {
                if (!sourceReference.isReferenceTo((PsiElement)oldClass)) continue;
                if (target != null) {
                    target.add((PsiElement)sourceReference);
                }
                sourceReference.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "moveReference";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

