/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.fixes.MoveAnonymousToInnerClassFix;
import org.jetbrains.annotations.NotNull;

public class AnonymousClassMethodCountInspection
extends ClassMetricInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 1;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveAnonymousToInnerClassFix();
    }

    @NotNull
    public String getID() {
        return "AnonymousInnerClassWithTooManyMethods";
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("anonymous.inner.class.with.too.many.methods.problem.descriptor", count);
        if (string == null) {
            AnonymousClassMethodCountInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousClassMethodCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspection", "buildErrorString"));
    }

    private class AnonymousClassMethodCountVisitor
    extends BaseInspectionVisitor {
        private AnonymousClassMethodCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                AnonymousClassMethodCountVisitor.$$$reportNull$$$0(0);
            }
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            if (aClass == null) {
                AnonymousClassMethodCountVisitor.$$$reportNull$$$0(1);
            }
            if (aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            int totalMethodCount = this.calculateTotalMethodCount((PsiClass)aClass);
            if (totalMethodCount <= AnonymousClassMethodCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError((PsiClass)aClass, totalMethodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass) {
            return aClass.getMethods().length - aClass.getConstructors().length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspection$AnonymousClassMethodCountVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnonymousClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

