/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class FieldCountInspection
extends ClassMetricInspection {
    private static final int FIELD_COUNT_LIMIT = 10;
    public boolean m_countConstantFields = false;
    public boolean m_considerStaticFinalFieldsConstant = false;
    public boolean myCountEnumConstants = false;

    @NotNull
    public String getID() {
        return "ClassWithTooManyFields";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("too.many.fields.problem.descriptor", infos[0]);
        if (string == null) {
            FieldCountInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("too.many.fields.count.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        String configurationLabel = this.getConfigurationLabel();
        JLabel label = new JLabel(configurationLabel);
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        CheckBox includeCheckBox = new CheckBox(InspectionGadgetsBundle.message("field.count.inspection.include.constant.fields.in.count.checkbox", new Object[0]), (InspectionProfileEntry)this, "m_countConstantFields");
        CheckBox considerCheckBox = new CheckBox(InspectionGadgetsBundle.message("field.count.inspection.static.final.fields.count.as.constant.checkbox", new Object[0]), (InspectionProfileEntry)this, "m_considerStaticFinalFieldsConstant");
        CheckBox enumConstantCheckBox = new CheckBox(InspectionGadgetsBundle.message("field.count.inspection.include.enum.constants.in.count", new Object[0]), (InspectionProfileEntry)this, "myCountEnumConstants");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets.right = 10;
        constraints.anchor = 17;
        constraints.fill = 0;
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        constraints.anchor = 18;
        panel2.add((Component)valueField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        panel2.add((Component)includeCheckBox, constraints);
        constraints.gridy = 2;
        panel2.add((Component)considerCheckBox, constraints);
        constraints.gridy = 3;
        constraints.weighty = 1.0;
        panel2.add((Component)enumConstantCheckBox, constraints);
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classmetrics/FieldCountInspection", "buildErrorString"));
    }

    private class FieldCountVisitor
    extends BaseInspectionVisitor {
        private FieldCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int totalFields;
            if (aClass == null) {
                FieldCountVisitor.$$$reportNull$$$0(0);
            }
            if ((totalFields = this.countFields(aClass)) <= FieldCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, totalFields);
        }

        private int countFields(PsiClass aClass) {
            PsiField[] fields;
            int totalFields = 0;
            for (PsiField field : fields = aClass.getFields()) {
                if (field instanceof PsiEnumConstant) {
                    if (!FieldCountInspection.this.myCountEnumConstants) continue;
                    ++totalFields;
                    continue;
                }
                if (!FieldCountInspection.this.m_countConstantFields && this.fieldIsConstant(field)) continue;
                ++totalFields;
            }
            return totalFields;
        }

        private boolean fieldIsConstant(PsiField field) {
            if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
                return false;
            }
            if (FieldCountInspection.this.m_considerStaticFinalFieldsConstant) {
                return true;
            }
            return ClassUtils.isImmutable(field.getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/FieldCountInspection$FieldCountVisitor", "visitClass"));
        }
    }
}

