/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class IfStatementWithIdenticalBranchesInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean myHighlightWhenLastStatementIsCall = true;
    private static final List<IfStatementInspector> ourInspectors = new ArrayList<IfStatementInspector>(Arrays.asList(ImplicitElse::inspect, ThenElse::inspect, ElseIf::inspect));

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"inspection.common.if.parts.settings.highlight.when.tail.call", (Object[])new Object[0]), (InspectionProfileEntry)this, "myHighlightWhenLastStatementIsCall");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitIfStatement(PsiIfStatement ifStatement) {
                PsiStatement[] thenStatements = IfStatementWithIdenticalBranchesInspection.unwrap(ifStatement.getThenBranch());
                PsiStatement[] elseStatements = IfStatementWithIdenticalBranchesInspection.unwrap(ifStatement.getElseBranch());
                for (IfStatementInspector inspector : ourInspectors) {
                    ProblemHighlightType highlightType;
                    IfInspectionResult result = inspector.inspect(ifStatement, thenStatements, elseStatements, isOnTheFly, IfStatementWithIdenticalBranchesInspection.this.myHighlightWhenLastStatementIsCall);
                    if (result == null) continue;
                    if (result.myIsWarning) {
                        highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    } else {
                        if (!isOnTheFly) {
                            return;
                        }
                        highlightType = ProblemHighlightType.INFORMATION;
                    }
                    LocalQuickFix[] fixes = IfStatementWithIdenticalBranchesInspection.this.myHighlightWhenLastStatementIsCall ? new LocalQuickFix[]{new SetInspectionOptionFix((LocalInspectionTool)IfStatementWithIdenticalBranchesInspection.this, "myHighlightWhenLastStatementIsCall", JavaAnalysisBundle.message((String)"inspection.common.if.parts.disable.highlight.tail.call", (Object[])new Object[0]), false), result.myFix} : new LocalQuickFix[]{result.myFix};
                    holder.registerProblem(result.myElementToHighlight, result.myMessage, highlightType, fixes);
                }
            }
        };
    }

    @Nullable
    private static ExtractionUnit extractHeadCommonStatement(@NotNull PsiStatement thenStmt, @NotNull PsiStatement elseStmt, @NotNull List<PsiLocalVariable> conditionVariables, @NotNull LocalEquivalenceChecker equivalence) {
        if (thenStmt == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(1);
        }
        if (elseStmt == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(2);
        }
        if (conditionVariables == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(3);
        }
        if (equivalence == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(4);
        }
        if (thenStmt instanceof PsiDeclarationStatement) {
            return IfStatementWithIdenticalBranchesInspection.extractDeclarationUnit(thenStmt, elseStmt, conditionVariables, equivalence);
        }
        if (!equivalence.statementsAreEquivalent(thenStmt, elseStmt)) {
            return null;
        }
        boolean statementMayChangeSemantics = SideEffectChecker.mayHaveSideEffects((PsiElement)thenStmt, e -> false);
        boolean mayInfluenceCondition = IfStatementWithIdenticalBranchesInspection.mayInfluenceCondition((PsiElement)thenStmt, conditionVariables);
        return new ExtractionUnit(thenStmt, elseStmt, statementMayChangeSemantics, mayInfluenceCondition, true);
    }

    @Nullable
    private static ExtractionUnit extractDeclarationUnit(@NotNull PsiStatement thenStmt, @NotNull PsiStatement elseStmt, @NotNull List<PsiLocalVariable> conditionVariables, @NotNull LocalEquivalenceChecker equivalence) {
        if (thenStmt == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(5);
        }
        if (elseStmt == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(6);
        }
        if (conditionVariables == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(7);
        }
        if (equivalence == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(8);
        }
        if (!equivalence.topLevelVarsAreEqualNotConsideringInitializers(thenStmt, elseStmt)) {
            return null;
        }
        PsiLocalVariable thenVariable = IfStatementWithIdenticalBranchesInspection.extractVariable(thenStmt);
        PsiLocalVariable elseVariable = IfStatementWithIdenticalBranchesInspection.extractVariable(elseStmt);
        if (thenVariable == null || elseVariable == null) {
            return null;
        }
        PsiExpression thenInitializer = thenVariable.getInitializer();
        if (thenInitializer == null) {
            return null;
        }
        boolean statementMayChangeSemantics = SideEffectChecker.mayHaveSideEffects((PsiElement)thenInitializer, e -> false);
        boolean mayInfluenceCondition = IfStatementWithIdenticalBranchesInspection.mayInfluenceCondition((PsiElement)thenInitializer, conditionVariables);
        boolean equivalent = equivalence.expressionsAreEquivalent(thenInitializer, elseVariable.getInitializer());
        return new VariableDeclarationUnit(thenStmt, elseStmt, statementMayChangeSemantics, mayInfluenceCondition, equivalent, thenVariable, elseVariable);
    }

    private static boolean mayInfluenceCondition(@NotNull PsiElement element, @NotNull List<PsiLocalVariable> conditionVariables) {
        if (element == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(9);
        }
        if (conditionVariables == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(10);
        }
        return StreamEx.ofTree((Object)element, e -> StreamEx.of((Object[])e.getChildren())).select(PsiReferenceExpression.class).map(expression2 -> expression2.resolve()).nonNull().select(PsiLocalVariable.class).anyMatch(el -> conditionVariables.contains(el));
    }

    @Nullable
    @Contract(pure=true)
    private static PsiLocalVariable extractVariable(@Nullable PsiStatement statement) {
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)statement, PsiDeclarationStatement.class);
        if (declarationStatement == null) {
            return null;
        }
        PsiElement[] elements = declarationStatement.getDeclaredElements();
        if (elements.length != 1) {
            return null;
        }
        return (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
    }

    @Nullable
    private static PsiIfStatement getEnclosingIfStmt(@NotNull PsiIfStatement ifStatement) {
        PsiElement parent;
        if (ifStatement == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(11);
        }
        if ((parent = ifStatement.getParent()) instanceof PsiIfStatement) {
            return (PsiIfStatement)parent;
        }
        if (parent instanceof PsiCodeBlock) {
            if (((PsiCodeBlock)parent).getStatements()[0] != ifStatement) {
                return null;
            }
            return (PsiIfStatement)ObjectUtils.tryCast((Object)parent.getParent().getParent(), PsiIfStatement.class);
        }
        return null;
    }

    private static boolean isMeaningful(@NotNull PsiStatement statement) {
        if (statement == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(12);
        }
        if (statement instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement instanceof PsiBlockStatement) {
            return !((PsiBlockStatement)statement).getCodeBlock().isEmpty();
        }
        return true;
    }

    @Nullable
    private static ImplicitElseData getIfWithImplicitElse(@NotNull PsiIfStatement ifStatement, PsiStatement @NotNull [] thenStatements, boolean returnsNothing) {
        int statementsLength;
        if (ifStatement == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(13);
        }
        if (thenStatements == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(14);
        }
        if ((statementsLength = thenStatements.length) == 0) {
            return null;
        }
        PsiIfStatement currentIf = ifStatement;
        ArrayList<PsiIfStatement> statements = new ArrayList<PsiIfStatement>();
        int count = 0;
        boolean conditionHasSideEffects = false;
        while (true) {
            PsiIfStatement enclosingIf;
            if (currentIf.getElseBranch() != null) {
                return null;
            }
            if (currentIf != ifStatement && ControlFlowUtils.unwrapBlock(currentIf.getThenBranch()).length != 1) break;
            if (currentIf.getCondition() != null && SideEffectChecker.mayHaveSideEffects(currentIf.getCondition())) {
                conditionHasSideEffects = true;
            }
            PsiIfStatement sibling = currentIf;
            while ((sibling = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)sibling, PsiStatement.class)) != null) {
                if (IfStatementWithIdenticalBranchesInspection.isMeaningful((PsiStatement)sibling)) {
                    ++count;
                    statements.add(sibling);
                }
                if (count <= statementsLength) continue;
            }
            if (!statements.isEmpty() || (enclosingIf = IfStatementWithIdenticalBranchesInspection.getEnclosingIfStmt(currentIf)) == null) break;
            currentIf = enclosingIf;
        }
        if (conditionHasSideEffects && ifStatement != currentIf) {
            return null;
        }
        PsiElement parent = currentIf.getParent();
        if (!(parent instanceof PsiCodeBlock)) {
            return null;
        }
        if (!(parent.getParent() instanceof PsiMethod)) {
            return null;
        }
        if (!statements.isEmpty() && PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)statements.get(statements.size() - 1)), PsiStatement.class) != null) {
            return null;
        }
        if (returnsNothing ? count == statementsLength || count == statementsLength - 1 : count == statementsLength) {
            return new ImplicitElseData(statements, currentIf);
        }
        return null;
    }

    private static void addLocalVariables(Set<? super PsiLocalVariable> variables, List<? extends PsiStatement> statements) {
        for (PsiStatement psiStatement : statements) {
            IfStatementWithIdenticalBranchesInspection.addVariables(variables, psiStatement);
        }
    }

    private static void addVariables(Set<? super PsiLocalVariable> variables, PsiStatement statement) {
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)statement, PsiDeclarationStatement.class);
        if (declarationStatement == null) {
            return;
        }
        for (PsiElement element : declarationStatement.getDeclaredElements()) {
            if (!(element instanceof PsiLocalVariable)) continue;
            variables.add((PsiLocalVariable)((PsiLocalVariable)element));
        }
    }

    private static PsiStatement @NotNull [] unwrap(@Nullable PsiStatement statement) {
        PsiStatement[] psiStatementArray;
        PsiBlockStatement block = (PsiBlockStatement)ObjectUtils.tryCast((Object)statement, PsiBlockStatement.class);
        if (block != null) {
            PsiStatement[] psiStatementArray2 = Arrays.stream(block.getCodeBlock().getStatements()).filter(IfStatementWithIdenticalBranchesInspection::isMeaningful).collect(Collectors.toList()).toArray(PsiStatement.EMPTY_ARRAY);
            if (psiStatementArray2 == null) {
                IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(15);
            }
            return psiStatementArray2;
        }
        if (statement == null) {
            psiStatementArray = PsiStatement.EMPTY_ARRAY;
        } else {
            PsiStatement[] psiStatementArray3 = new PsiStatement[1];
            psiStatementArray = psiStatementArray3;
            psiStatementArray3[0] = statement;
        }
        if (psiStatementArray == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(16);
        }
        return psiStatementArray;
    }

    private static boolean branchesAreEquivalent(PsiStatement @NotNull [] thenBranch, @NotNull List<? extends PsiStatement> statements, @NotNull EquivalenceChecker equivalence) {
        if (statements == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(17);
        }
        if (equivalence == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(18);
        }
        if (thenBranch == null) {
            IfStatementWithIdenticalBranchesInspection.$$$reportNull$$$0(19);
        }
        int length = statements.size();
        for (int i = 0; i < length; ++i) {
            PsiStatement thenStmt = thenBranch[i];
            PsiStatement elseStmt = statements.get(i);
            if (equivalence.statementsAreEquivalent(thenStmt, elseStmt)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStmt";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseStmt";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionVariables";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalence";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStatements";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractHeadCommonStatement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractDeclarationUnit";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mayInfluenceCondition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingIfStmt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMeaningful";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIfWithImplicitElse";
                break;
            }
            case 15: 
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "branchesAreEquivalent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalEquivalenceChecker
    extends EquivalenceChecker {
        final Set<PsiLocalVariable> myLocalVariables;
        final Map<PsiLocalVariable, String> mySubstitutionTable = new HashMap<PsiLocalVariable, String>(0);

        private LocalEquivalenceChecker(Set<PsiLocalVariable> variables) {
            this.myLocalVariables = variables;
        }

        public boolean topLevelVarsAreEqualNotConsideringInitializers(@NotNull PsiStatement first, @NotNull PsiStatement second) {
            if (first == null) {
                LocalEquivalenceChecker.$$$reportNull$$$0(0);
            }
            if (second == null) {
                LocalEquivalenceChecker.$$$reportNull$$$0(1);
            }
            PsiLocalVariable localVariable1 = IfStatementWithIdenticalBranchesInspection.extractVariable(first);
            PsiLocalVariable localVariable2 = IfStatementWithIdenticalBranchesInspection.extractVariable(second);
            if (localVariable1 == null || localVariable2 == null) {
                return false;
            }
            if (!this.myLocalVariables.contains(localVariable1) || !this.myLocalVariables.contains(localVariable2)) {
                return false;
            }
            return this.equalNotConsideringInitializer(localVariable1, localVariable2);
        }

        private boolean equalNotConsideringInitializer(@NotNull PsiLocalVariable localVariable1, @NotNull PsiLocalVariable localVariable2) {
            String secondName;
            PsiType firstType;
            if (localVariable1 == null) {
                LocalEquivalenceChecker.$$$reportNull$$$0(2);
            }
            if (localVariable2 == null) {
                LocalEquivalenceChecker.$$$reportNull$$$0(3);
            }
            PsiModifierList firstModifierList = localVariable1.getModifierList();
            PsiModifierList secondModifierList = localVariable2.getModifierList();
            if (firstModifierList != null || secondModifierList != null) {
                if (firstModifierList == null || secondModifierList == null) {
                    return false;
                }
                String firstModifierListText = firstModifierList.getText();
                String secondModifierListText = secondModifierList.getText();
                if (firstModifierListText != null && !firstModifierListText.equals(secondModifierListText)) {
                    return false;
                }
            }
            if (!(firstType = localVariable1.getType()).equals(localVariable2.getType())) {
                return false;
            }
            String firstName = localVariable1.getName();
            if (!firstName.equals(secondName = localVariable2.getName())) {
                this.mySubstitutionTable.put(localVariable2, firstName);
            }
            return true;
        }

        @Override
        protected EquivalenceChecker.Match localVariablesAreEquivalent(@NotNull PsiLocalVariable localVariable1, @NotNull PsiLocalVariable localVariable2) {
            if (localVariable1 == null) {
                LocalEquivalenceChecker.$$$reportNull$$$0(4);
            }
            if (localVariable2 == null) {
                LocalEquivalenceChecker.$$$reportNull$$$0(5);
            }
            if (!this.myLocalVariables.contains(localVariable1) || !this.myLocalVariables.contains(localVariable2)) {
                return super.localVariablesAreEquivalent(localVariable1, localVariable2);
            }
            if (!this.equalNotConsideringInitializer(localVariable1, localVariable2)) {
                return EXACT_MISMATCH;
            }
            PsiExpression firstInitializer = localVariable1.getInitializer();
            PsiExpression secondInitializer = localVariable2.getInitializer();
            return this.expressionsMatch(firstInitializer, secondInitializer);
        }

        @Override
        protected EquivalenceChecker.Match referenceExpressionsMatch(PsiReferenceExpression first, PsiReferenceExpression second) {
            PsiElement firstElement = first.resolve();
            PsiElement secondElement = second.resolve();
            if (firstElement instanceof PsiLocalVariable && secondElement instanceof PsiLocalVariable && this.myLocalVariables.contains(firstElement) && this.myLocalVariables.contains(secondElement)) {
                PsiLocalVariable secondVar = (PsiLocalVariable)secondElement;
                PsiLocalVariable firstVar = (PsiLocalVariable)firstElement;
                if (firstVar.getType().equals(secondVar.getType())) {
                    String firstVarName = firstVar.getName();
                    String secondVarName = secondVar.getName();
                    String substitutedName = this.mySubstitutionTable.get(secondVar);
                    if (substitutedName == null) {
                        return firstVarName.equals(secondVarName) ? EXACT_MATCH : EXACT_MISMATCH;
                    }
                    return firstVarName.equals(substitutedName) ? EXACT_MATCH : EXACT_MISMATCH;
                }
            }
            return super.referenceExpressionsMatch(first, second);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "second";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localVariable1";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localVariable2";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$LocalEquivalenceChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "topLevelVarsAreEqualNotConsideringInitializers";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "equalNotConsideringInitializer";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "localVariablesAreEquivalent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ElseIf {
        @NotNull
        final PsiStatement myElseBranch;
        @NotNull
        final PsiStatement myElseIfElseStatement;
        @NotNull
        final PsiElement myElseIfThen;
        @NotNull
        final PsiExpression myElseIfCondition;
        @NotNull
        final Map<PsiLocalVariable, String> mySubstitutionTable;

        private ElseIf(@NotNull PsiStatement elseBranch, @NotNull PsiStatement elseIfElseStatement, @NotNull PsiElement then, @NotNull PsiExpression elseIfCondition, @NotNull Map<PsiLocalVariable, String> table) {
            if (elseBranch == null) {
                ElseIf.$$$reportNull$$$0(0);
            }
            if (elseIfElseStatement == null) {
                ElseIf.$$$reportNull$$$0(1);
            }
            if (then == null) {
                ElseIf.$$$reportNull$$$0(2);
            }
            if (elseIfCondition == null) {
                ElseIf.$$$reportNull$$$0(3);
            }
            if (table == null) {
                ElseIf.$$$reportNull$$$0(4);
            }
            this.myElseBranch = elseBranch;
            this.myElseIfElseStatement = elseIfElseStatement;
            this.myElseIfThen = then;
            this.myElseIfCondition = elseIfCondition;
            this.mySubstitutionTable = table;
        }

        @Nullable
        static ElseIf from(@NotNull PsiIfStatement ifStatement, PsiStatement @NotNull [] thenStatements) {
            if (ifStatement == null) {
                ElseIf.$$$reportNull$$$0(5);
            }
            if (thenStatements == null) {
                ElseIf.$$$reportNull$$$0(6);
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (ifStatement.getCondition() == null) {
                return null;
            }
            PsiIfStatement elseIf = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(elseBranch), PsiIfStatement.class);
            if (elseIf == null) {
                return null;
            }
            PsiExpression elseIfCondition = elseIf.getCondition();
            if (elseIfCondition == null) {
                return null;
            }
            PsiStatement elseIfThenBranch = elseIf.getThenBranch();
            if (elseIfThenBranch == null) {
                return null;
            }
            PsiStatement[] elseIfThen = ControlFlowUtils.unwrapBlock(elseIfThenBranch);
            PsiStatement elseIfElseBranch = elseIf.getElseBranch();
            if (elseIfElseBranch == null) {
                return null;
            }
            if (elseIfThen.length != thenStatements.length) {
                return null;
            }
            HashSet variables = new HashSet();
            IfStatementWithIdenticalBranchesInspection.addLocalVariables(variables, Arrays.asList(thenStatements));
            IfStatementWithIdenticalBranchesInspection.addLocalVariables(variables, Arrays.asList(elseIfThen));
            LocalEquivalenceChecker equivalence = new LocalEquivalenceChecker(variables);
            if (!IfStatementWithIdenticalBranchesInspection.branchesAreEquivalent(thenStatements, Arrays.asList(elseIfThen), equivalence)) {
                return null;
            }
            return new ElseIf(elseBranch, elseIfElseBranch, (PsiElement)elseIfThenBranch, elseIfCondition, equivalence.mySubstitutionTable);
        }

        @Nullable
        static IfInspectionResult inspect(@NotNull PsiIfStatement ifStatement, PsiStatement @NotNull [] thenBranch, PsiStatement @NotNull [] elseBranch, boolean isOnTheFly, boolean highlightWhenLastStatementIsCall) {
            ElseIf elseIf;
            if (ifStatement == null) {
                ElseIf.$$$reportNull$$$0(7);
            }
            if (thenBranch == null) {
                ElseIf.$$$reportNull$$$0(8);
            }
            if (elseBranch == null) {
                ElseIf.$$$reportNull$$$0(9);
            }
            if ((elseIf = ElseIf.from(ifStatement, thenBranch)) == null) {
                return null;
            }
            String message2 = JavaAnalysisBundle.message((String)"inspection.common.if.parts.family.else.if.description", (Object[])new Object[0]);
            return new IfInspectionResult(ifStatement.getFirstChild(), false, new MergeElseIfsFix(), message2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseBranch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseIfElseStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "then";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseIfCondition";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenStatements";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenBranch";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ElseIf";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inspect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThenElse {
        public static final int SIMILAR_STATEMENTS_COUNT = 2;
        final List<ExtractionUnit> myHeadUnitsOfThen;
        final List<PsiStatement> myTailStatementsOfThen;
        final boolean myMayChangeSemantics;
        final CommonPartType myCommonPartType;
        final Map<PsiLocalVariable, String> mySubstitutionTable;

        private ThenElse(List<ExtractionUnit> headUnitsOfThen, List<PsiStatement> tailUnitsOfThen, boolean mayChangeSemantics, CommonPartType commonPartType, Map<PsiLocalVariable, String> substitutionTable) {
            this.myHeadUnitsOfThen = headUnitsOfThen;
            this.myTailStatementsOfThen = tailUnitsOfThen;
            this.myMayChangeSemantics = mayChangeSemantics;
            this.myCommonPartType = commonPartType;
            this.mySubstitutionTable = substitutionTable;
        }

        boolean variableRenameRequired() {
            return StreamEx.of(this.myHeadUnitsOfThen).anyMatch(unit -> {
                if (unit instanceof VariableDeclarationUnit) {
                    VariableDeclarationUnit declarationUnit = (VariableDeclarationUnit)unit;
                    if (!Objects.equals(declarationUnit.myThenVariable.getName(), declarationUnit.myElseVariable.getName())) {
                        return true;
                    }
                }
                return false;
            });
        }

        private static boolean mayChangeSemantics(boolean conditionHasSideEffects, boolean conditionVariablesCantBeChangedTransitively, List<? extends ExtractionUnit> headCommonParts) {
            if (headCommonParts.isEmpty()) {
                return false;
            }
            if (conditionHasSideEffects) {
                return true;
            }
            if (conditionVariablesCantBeChangedTransitively) {
                return StreamEx.of(headCommonParts).anyMatch(unit -> unit.mayInfluenceCondition() && !(unit.getThenStatement() instanceof PsiDeclarationStatement));
            }
            return StreamEx.of(headCommonParts).anyMatch(unit -> unit.haveSideEffects() && !(unit.getThenStatement() instanceof PsiDeclarationStatement));
        }

        @NotNull
        private static LocalEquivalenceChecker getChecker(PsiStatement[] thenBranch, PsiStatement[] elseBranch) {
            HashSet localVariables = new HashSet();
            IfStatementWithIdenticalBranchesInspection.addLocalVariables(localVariables, Arrays.asList(thenBranch));
            IfStatementWithIdenticalBranchesInspection.addLocalVariables(localVariables, Arrays.asList(elseBranch));
            return new LocalEquivalenceChecker(localVariables);
        }

        @NotNull
        private static CommonPartType getType(@NotNull List<? extends ExtractionUnit> headStatements, List<? extends PsiStatement> tailStatements, boolean declarationsAreEquivalent, int thenLen, int elseLen, @NotNull PsiStatement thenBranch, @NotNull PsiStatement elseBranch) {
            if (headStatements == null) {
                ThenElse.$$$reportNull$$$0(0);
            }
            if (thenBranch == null) {
                ThenElse.$$$reportNull$$$0(1);
            }
            if (elseBranch == null) {
                ThenElse.$$$reportNull$$$0(2);
            }
            if (declarationsAreEquivalent) {
                int duplicatedStatements = headStatements.size() + tailStatements.size();
                if (thenLen == duplicatedStatements && elseLen == duplicatedStatements) {
                    CommonPartType commonPartType = CommonPartType.COMPLETE_DUPLICATE;
                    if (commonPartType == null) {
                        ThenElse.$$$reportNull$$$0(3);
                    }
                    return commonPartType;
                }
                if (ThenElse.canRemoveBranch(thenLen, thenBranch, duplicatedStatements)) {
                    CommonPartType commonPartType = CommonPartType.WHOLE_BRANCH;
                    if (commonPartType == null) {
                        ThenElse.$$$reportNull$$$0(4);
                    }
                    return commonPartType;
                }
                if (ThenElse.canRemoveBranch(elseLen, elseBranch, duplicatedStatements)) {
                    CommonPartType commonPartType = CommonPartType.WHOLE_BRANCH;
                    if (commonPartType == null) {
                        ThenElse.$$$reportNull$$$0(5);
                    }
                    return commonPartType;
                }
            }
            boolean hasVariables = false;
            boolean hasNonVariables = false;
            for (ExtractionUnit extractionUnit : headStatements) {
                if (extractionUnit.getThenStatement() instanceof PsiDeclarationStatement) {
                    hasVariables = true;
                } else {
                    hasNonVariables = true;
                }
                if (!hasVariables || !hasNonVariables) continue;
                break;
            }
            if (!hasVariables || !hasNonVariables) {
                for (PsiStatement psiStatement : tailStatements) {
                    if (psiStatement instanceof PsiDeclarationStatement) {
                        hasVariables = true;
                    } else {
                        hasNonVariables = true;
                    }
                    if (!hasVariables || !hasNonVariables) continue;
                    break;
                }
            }
            if (hasVariables && hasNonVariables) {
                CommonPartType commonPartType = CommonPartType.WITH_VARIABLES_EXTRACT;
                if (commonPartType == null) {
                    ThenElse.$$$reportNull$$$0(6);
                }
                return commonPartType;
            }
            if (hasVariables) {
                CommonPartType commonPartType = CommonPartType.VARIABLES_ONLY;
                if (commonPartType == null) {
                    ThenElse.$$$reportNull$$$0(7);
                }
                return commonPartType;
            }
            CommonPartType commonPartType = CommonPartType.WITHOUT_VARIABLES_EXTRACT;
            if (commonPartType == null) {
                ThenElse.$$$reportNull$$$0(8);
            }
            return commonPartType;
        }

        private static boolean canRemoveBranch(int len, PsiStatement branch, int duplicatedStatementsLen) {
            PsiBlockStatement blockStatement;
            return len == duplicatedStatementsLen && (blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)branch, PsiBlockStatement.class)) != null && PsiTreeUtil.getChildOfType((PsiElement)blockStatement.getCodeBlock(), PsiComment.class) == null;
        }

        @Nullable
        static ThenElse from(@NotNull PsiIfStatement ifStatement, PsiStatement @NotNull [] thenBranch, PsiStatement @NotNull [] elseBranch, boolean isOnTheFly) {
            if (ifStatement == null) {
                ThenElse.$$$reportNull$$$0(9);
            }
            if (thenBranch == null) {
                ThenElse.$$$reportNull$$$0(10);
            }
            if (elseBranch == null) {
                ThenElse.$$$reportNull$$$0(11);
            }
            LocalEquivalenceChecker equivalence = ThenElse.getChecker(thenBranch, elseBranch);
            int thenLen = thenBranch.length;
            int elseLen = elseBranch.length;
            int minStmtCount = Math.min(thenLen, elseLen);
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            boolean conditionHasSideEffects = SideEffectChecker.mayHaveSideEffects(condition2);
            if (!isOnTheFly && conditionHasSideEffects) {
                return null;
            }
            ArrayList<PsiLocalVariable> conditionVariables = new ArrayList<PsiLocalVariable>();
            boolean conditionVariablesCantBeChangedTransitively = StreamEx.ofTree((Object)condition2, el -> StreamEx.of((Object[])el.getChildren())).allMatch(element -> {
                if (!(element instanceof PsiReferenceExpression)) {
                    return !(element instanceof PsiMethodCallExpression);
                }
                PsiLocalVariable localVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)element).resolve(), PsiLocalVariable.class);
                if (localVariable == null) {
                    return false;
                }
                conditionVariables.add(localVariable);
                return true;
            });
            ArrayList<ExtractionUnit> headCommonParts = new ArrayList<ExtractionUnit>();
            HashSet<PsiVariable> extractedVariables = new HashSet<PsiVariable>();
            HashSet notEquivalentVariableDeclarations = new HashSet(0);
            ThenElse.extractHeadCommonParts(thenBranch, elseBranch, isOnTheFly, equivalence, minStmtCount, conditionVariables, headCommonParts, extractedVariables, notEquivalentVariableDeclarations);
            if (headCommonParts.isEmpty()) {
                equivalence.mySubstitutionTable.clear();
            }
            int extractedFromStart = headCommonParts.size();
            int canBeExtractedFromThenTail = thenLen - extractedFromStart;
            int canBeExtractedFromElseTail = elseLen - extractedFromStart;
            int canBeExtractedFromTail = Math.min(canBeExtractedFromThenTail, canBeExtractedFromElseTail);
            ArrayList<PsiStatement> tailCommonParts = new ArrayList<PsiStatement>();
            ThenElse.extractTailCommonParts(ifStatement, thenBranch, elseBranch, equivalence, thenLen, elseLen, extractedVariables, canBeExtractedFromTail, tailCommonParts);
            ThenElse.tryAppendHeadPartsToTail(headCommonParts, canBeExtractedFromThenTail, canBeExtractedFromElseTail, canBeExtractedFromTail, tailCommonParts);
            Map<PsiLocalVariable, String> substitutionTable = equivalence.mySubstitutionTable;
            if (ThenElse.uncommonElseStatementsContainsThenNames(elseBranch, elseLen, headCommonParts, tailCommonParts, substitutionTable)) {
                return null;
            }
            if (headCommonParts.isEmpty() && tailCommonParts.isEmpty()) {
                return null;
            }
            PsiStatement thenStatement = ifStatement.getThenBranch();
            PsiStatement elseStatement = ifStatement.getElseBranch();
            if (thenStatement == null || elseStatement == null) {
                return null;
            }
            CommonPartType type2 = ThenElse.getType(headCommonParts, tailCommonParts, notEquivalentVariableDeclarations.isEmpty(), thenLen, elseLen, thenStatement, elseStatement);
            if (type2 == CommonPartType.VARIABLES_ONLY && !notEquivalentVariableDeclarations.isEmpty()) {
                return null;
            }
            boolean mayChangeSemantics = ThenElse.mayChangeSemantics(conditionHasSideEffects, conditionVariablesCantBeChangedTransitively, headCommonParts);
            return new ThenElse(headCommonParts, tailCommonParts, mayChangeSemantics, type2, substitutionTable);
        }

        private static boolean isSingleCallTail(List<PsiStatement> tail) {
            if (tail.size() != 1) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)tail.get(0), PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
            return call != null;
        }

        @Nullable
        static IfInspectionResult inspect(@NotNull PsiIfStatement ifStatement, PsiStatement @NotNull [] thenBranch, PsiStatement @NotNull [] elseBranch, boolean isOnTheFly, boolean highlightWhenLastStatementIsCall) {
            PsiIfStatement elementToHighlight;
            ThenElse thenElse;
            if (ifStatement == null) {
                ThenElse.$$$reportNull$$$0(12);
            }
            if (thenBranch == null) {
                ThenElse.$$$reportNull$$$0(13);
            }
            if (elseBranch == null) {
                ThenElse.$$$reportNull$$$0(14);
            }
            if ((thenElse = ThenElse.from(ifStatement, thenBranch, elseBranch, isOnTheFly)) == null) {
                return null;
            }
            boolean isNotInCodeBlock = !(ifStatement.getParent() instanceof PsiCodeBlock);
            boolean mayChangeSemantics = thenElse.myMayChangeSemantics;
            CommonPartType type2 = thenElse.myCommonPartType;
            ExtractCommonIfPartsFix fix = new ExtractCommonIfPartsFix(type2, mayChangeSemantics, isOnTheFly);
            boolean tailStatementIsSingleCall = !highlightWhenLastStatementIsCall && ThenElse.isSingleCallTail(thenElse.myTailStatementsOfThen) && thenElse.myHeadUnitsOfThen.isEmpty();
            boolean isInfoLevel = mayChangeSemantics || isNotInCodeBlock || ThenElse.isVariableTypeWithRename(thenElse, type2) || tailStatementIsSingleCall;
            Object object = elementToHighlight = isInfoLevel ? ifStatement : ifStatement.getFirstChild();
            if (type2 == CommonPartType.VARIABLES_ONLY && !isOnTheFly) {
                return null;
            }
            return new IfInspectionResult((PsiElement)elementToHighlight, !isInfoLevel, fix, type2.getDescriptionMessage(mayChangeSemantics));
        }

        private static boolean isVariableTypeWithRename(ThenElse thenElse, CommonPartType type2) {
            return (type2 == CommonPartType.WITH_VARIABLES_EXTRACT || type2 == CommonPartType.VARIABLES_ONLY) && thenElse.variableRenameRequired();
        }

        private static void tryAppendHeadPartsToTail(List<? extends ExtractionUnit> headCommonParts, int canBeExtractedFromThenTail, int canBeExtractedFromElseTail, int canBeExtractedFromTail, List<? super PsiStatement> tailCommonParts) {
            if (canBeExtractedFromTail == tailCommonParts.size() && canBeExtractedFromElseTail == canBeExtractedFromThenTail) {
                for (int i = headCommonParts.size() - 1; i >= 0; --i) {
                    ExtractionUnit unit = headCommonParts.get(i);
                    PsiStatement thenStatement = unit.getThenStatement();
                    if (!unit.haveSideEffects() || !unit.isEquivalent()) break;
                    headCommonParts.remove(i);
                    tailCommonParts.add((PsiStatement)thenStatement);
                }
            }
        }

        private static void extractTailCommonParts(@NotNull PsiIfStatement ifStatement, PsiStatement @NotNull [] thenBranch, PsiStatement @NotNull [] elseBranch, LocalEquivalenceChecker equivalence, int thenLen, int elseLen, Set<PsiVariable> extractedVariables, int canBeExtractedFromTail, List<? super PsiStatement> tailCommonParts) {
            if (ifStatement == null) {
                ThenElse.$$$reportNull$$$0(15);
            }
            if (thenBranch == null) {
                ThenElse.$$$reportNull$$$0(16);
            }
            if (elseBranch == null) {
                ThenElse.$$$reportNull$$$0(17);
            }
            if (!ThenElse.isSimilarTailStatements(thenBranch)) {
                boolean canBeExtractedOutOfIf;
                PsiStatement elseStmt;
                PsiStatement thenStmt;
                for (int i = 0; i < canBeExtractedFromTail && equivalence.statementsAreEquivalent(thenStmt = thenBranch[thenLen - i - 1], elseStmt = elseBranch[elseLen - i - 1]) && (canBeExtractedOutOfIf = VariableAccessUtils.collectUsedVariables((PsiElement)thenStmt).stream().filter(var -> var instanceof PsiLocalVariable).filter(var -> PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)var, (boolean)false)).allMatch(var -> extractedVariables.contains(var))); ++i) {
                    tailCommonParts.add((PsiStatement)thenStmt);
                }
            }
        }

        private static void extractHeadCommonParts(PsiStatement @NotNull [] thenBranch, PsiStatement @NotNull [] elseBranch, boolean isOnTheFly, LocalEquivalenceChecker equivalence, int minStmtCount, List<PsiLocalVariable> conditionVariables, List<? super ExtractionUnit> headCommonParts, Set<? super PsiVariable> extractedVariables, Set<? super PsiVariable> notEquivalentVariableDeclarations) {
            if (thenBranch == null) {
                ThenElse.$$$reportNull$$$0(18);
            }
            if (elseBranch == null) {
                ThenElse.$$$reportNull$$$0(19);
            }
            if (!ThenElse.isSimilarHeadStatements(thenBranch)) {
                boolean dependsOnVariableWithNonEquivalentInitializer;
                PsiStatement elseStmt;
                PsiStatement thenStmt;
                ExtractionUnit unit;
                for (int i = 0; !(i >= minStmtCount || (unit = IfStatementWithIdenticalBranchesInspection.extractHeadCommonStatement(thenStmt = thenBranch[i], elseStmt = elseBranch[i], conditionVariables, equivalence)) == null || !isOnTheFly && unit.haveSideEffects() || (dependsOnVariableWithNonEquivalentInitializer = VariableAccessUtils.collectUsedVariables((PsiElement)thenStmt).stream().filter(var -> var instanceof PsiLocalVariable).anyMatch(var -> notEquivalentVariableDeclarations.contains(var)))); ++i) {
                    PsiLocalVariable variable = IfStatementWithIdenticalBranchesInspection.extractVariable(unit.getThenStatement());
                    if (variable != null) {
                        extractedVariables.add((PsiVariable)variable);
                        if (!unit.isEquivalent()) {
                            notEquivalentVariableDeclarations.add((PsiVariable)variable);
                        }
                    }
                    headCommonParts.add(unit);
                }
            }
        }

        private static boolean isSimilarHeadStatements(PsiStatement @NotNull [] thenBranch) {
            if (thenBranch == null) {
                ThenElse.$$$reportNull$$$0(20);
            }
            if (thenBranch.length <= 2) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenBranch[0], PsiExpressionStatement.class);
            return ThenElse.isSimilarStatements(thenBranch, expressionStatement);
        }

        private static boolean isSimilarStatements(PsiStatement @NotNull [] branch, PsiExpressionStatement expressionStatement) {
            if (branch == null) {
                ThenElse.$$$reportNull$$$0(21);
            }
            if (expressionStatement == null) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
            if (call == null) {
                return false;
            }
            for (int i = branch.length - 1; i >= 0; --i) {
                if (ThenElse.isSimilarCall(branch[i], call)) continue;
                return false;
            }
            return true;
        }

        private static boolean isSimilarTailStatements(PsiStatement @NotNull [] thenBranch) {
            if (thenBranch == null) {
                ThenElse.$$$reportNull$$$0(22);
            }
            if (thenBranch.length <= 2) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenBranch[thenBranch.length - 1], PsiExpressionStatement.class);
            return ThenElse.isSimilarStatements(thenBranch, expressionStatement);
        }

        private static boolean isSimilarCall(PsiStatement statement, PsiMethodCallExpression call) {
            PsiExpressionStatement currentStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statement, PsiExpressionStatement.class);
            if (currentStatement == null) {
                return false;
            }
            PsiMethodCallExpression otherCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)currentStatement.getExpression(), PsiMethodCallExpression.class);
            if (otherCall == null) {
                return false;
            }
            return ThenElse.isEqualChain((PsiExpression)call, (PsiExpression)otherCall);
        }

        private static boolean isEqualChain(@Nullable PsiExpression first, @Nullable PsiExpression second) {
            if (first == null && second == null) {
                return true;
            }
            if (first == null || second == null) {
                return false;
            }
            PsiMethodCallExpression firstCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)first, PsiMethodCallExpression.class);
            PsiMethodCallExpression secondCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)second, PsiMethodCallExpression.class);
            PsiExpression firstCurrent = first;
            PsiExpression secondCurrent = second;
            while (firstCall != null && secondCall != null) {
                String firstName = firstCall.getMethodExpression().getReferenceName();
                String secondName = secondCall.getMethodExpression().getReferenceName();
                if (firstName == null || !firstName.equals(secondName)) {
                    return false;
                }
                firstCurrent = firstCall.getMethodExpression().getQualifierExpression();
                secondCurrent = secondCall.getMethodExpression().getQualifierExpression();
                firstCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)firstCurrent, PsiMethodCallExpression.class);
                secondCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)secondCurrent, PsiMethodCallExpression.class);
            }
            return firstCurrent == null && secondCurrent == null || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(firstCurrent, secondCurrent);
        }

        private static boolean uncommonElseStatementsContainsThenNames(PsiStatement @NotNull [] elseBranch, int elseLen, List<ExtractionUnit> headCommonParts, List<PsiStatement> tailCommonParts, Map<PsiLocalVariable, String> substitutionTable) {
            if (elseBranch == null) {
                ThenElse.$$$reportNull$$$0(23);
            }
            if (!substitutionTable.isEmpty()) {
                int firstTailCommonStatementIndex = elseLen - tailCommonParts.size();
                HashSet<String> names2 = new HashSet<String>(substitutionTable.values());
                for (int i = headCommonParts.size(); i < firstTailCommonStatementIndex; ++i) {
                    if (!((StreamEx)StreamEx.ofTree((Object)elseBranch[i], e -> StreamEx.of((Object[])e.getChildren())).select(PsiVariable.class).filter(var -> var instanceof PsiLocalVariable || var instanceof PsiParameter)).anyMatch(var -> names2.contains(var.getName()))) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headStatements";
                    break;
                }
                case 1: 
                case 10: 
                case 13: 
                case 16: 
                case 18: 
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenBranch";
                    break;
                }
                case 2: 
                case 11: 
                case 14: 
                case 17: 
                case 19: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseBranch";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ThenElse";
                    break;
                }
                case 9: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ThenElse";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "inspect";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "extractTailCommonParts";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "extractHeadCommonParts";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "isSimilarHeadStatements";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "isSimilarStatements";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "isSimilarTailStatements";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "uncommonElseStatementsContainsThenNames";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImplicitElse {
        @NotNull
        final PsiIfStatement myIfToDelete;

        private ImplicitElse(@NotNull PsiIfStatement ifToDelete) {
            if (ifToDelete == null) {
                ImplicitElse.$$$reportNull$$$0(0);
            }
            this.myIfToDelete = ifToDelete;
        }

        @Nullable
        static ImplicitElse from(PsiStatement @NotNull [] thenBranch, PsiStatement @NotNull [] elseBranch, @NotNull PsiIfStatement ifStatement) {
            PsiStatement statement;
            if (ifStatement == null) {
                ImplicitElse.$$$reportNull$$$0(1);
            }
            if (thenBranch == null) {
                ImplicitElse.$$$reportNull$$$0(2);
            }
            if (elseBranch == null) {
                ImplicitElse.$$$reportNull$$$0(3);
            }
            if (elseBranch.length != 0 || thenBranch.length == 0) {
                return null;
            }
            PsiStatement lastThenStatement = thenBranch[thenBranch.length - 1];
            if (!(lastThenStatement instanceof PsiReturnStatement)) {
                return null;
            }
            boolean returnsNothing = ((PsiReturnStatement)lastThenStatement).getReturnValue() == null;
            ImplicitElseData implicitElse = IfStatementWithIdenticalBranchesInspection.getIfWithImplicitElse(ifStatement, thenBranch, returnsNothing);
            if (implicitElse == null) {
                return null;
            }
            if (implicitElse.myImplicitElseStatements.isEmpty()) {
                return null;
            }
            if (implicitElse.myImplicitElseStatements.size() == 1 && (statement = implicitElse.myImplicitElseStatements.get(0)) instanceof PsiReturnStatement && ((PsiReturnStatement)statement).getReturnValue() == null) {
                return null;
            }
            List<PsiStatement> elseStatements = implicitElse.myImplicitElseStatements;
            HashSet variables = new HashSet();
            ArrayList<PsiStatement> thenStatements = new ArrayList<PsiStatement>(Arrays.asList(thenBranch));
            IfStatementWithIdenticalBranchesInspection.addLocalVariables(variables, thenStatements);
            IfStatementWithIdenticalBranchesInspection.addLocalVariables(variables, implicitElse.myImplicitElseStatements);
            if (!IfStatementWithIdenticalBranchesInspection.branchesAreEquivalent(thenBranch, elseStatements, new LocalEquivalenceChecker(variables))) {
                return null;
            }
            return new ImplicitElse(implicitElse.myIfWithImplicitElse);
        }

        CommonPartType getType() {
            PsiExpression condition2 = this.myIfToDelete.getCondition();
            if (condition2 != null && SideEffectChecker.mayHaveSideEffects(condition2)) {
                return CommonPartType.EXTRACT_SIDE_EFFECTS;
            }
            return CommonPartType.COMPLETE_DUPLICATE;
        }

        @Nullable
        static IfInspectionResult inspect(@NotNull PsiIfStatement ifStatement, PsiStatement @NotNull [] thenBranch, PsiStatement @NotNull [] elseBranch, boolean isOnTheFly, boolean highlightWhenLastStatementIsCall) {
            ImplicitElse implicitElse;
            if (ifStatement == null) {
                ImplicitElse.$$$reportNull$$$0(4);
            }
            if (thenBranch == null) {
                ImplicitElse.$$$reportNull$$$0(5);
            }
            if (elseBranch == null) {
                ImplicitElse.$$$reportNull$$$0(6);
            }
            if ((implicitElse = ImplicitElse.from(thenBranch, elseBranch, ifStatement)) == null) {
                return null;
            }
            CommonPartType type2 = implicitElse.getType();
            ExtractCommonIfPartsFix fix = new ExtractCommonIfPartsFix(type2, false, isOnTheFly);
            return new IfInspectionResult(ifStatement.getFirstChild(), true, fix, type2.getDescriptionMessage(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifToDelete";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenBranch";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseBranch";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ImplicitElse";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inspect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ImplicitElseData {
        @NotNull
        final List<PsiStatement> myImplicitElseStatements;
        @NotNull
        final PsiIfStatement myIfWithImplicitElse;

        private ImplicitElseData(@NotNull List<PsiStatement> implicitElseStatements, @NotNull PsiIfStatement ifWithImplicitElse) {
            if (implicitElseStatements == null) {
                ImplicitElseData.$$$reportNull$$$0(0);
            }
            if (ifWithImplicitElse == null) {
                ImplicitElseData.$$$reportNull$$$0(1);
            }
            this.myImplicitElseStatements = implicitElseStatements;
            this.myIfWithImplicitElse = ifWithImplicitElse;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "implicitElseStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ifWithImplicitElse";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ImplicitElseData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum CommonPartType {
        VARIABLES_ONLY("inspection.common.if.parts.message.variables.only", "inspection.common.if.parts.description.variables.only"),
        WITH_VARIABLES_EXTRACT("inspection.common.if.parts.message.with.variables.extract", "inspection.common.if.parts.description.with.variables.extract"),
        WITHOUT_VARIABLES_EXTRACT("inspection.common.if.parts.message.without.variables.extract", "inspection.common.if.parts.description.without.variables.extract"),
        WHOLE_BRANCH("inspection.common.if.parts.message.whole.branch", "inspection.common.if.parts.description.whole.branch"),
        COMPLETE_DUPLICATE("inspection.common.if.parts.message.complete.duplicate", "inspection.common.if.parts.description.complete.duplicate"),
        EXTRACT_SIDE_EFFECTS("inspection.common.if.parts.message.complete.duplicate.side.effect", "inspection.common.if.parts.description.complete.duplicate.side.effect");

        @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle")
        @NotNull
        private final String myBundleFixKey;
        @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle")
        @NotNull
        private final String myBundleDescriptionKey;

        @NotNull
        private String getFixMessage(boolean mayChangeSemantics) {
            String string = InspectionGadgetsBundle.message(this.myBundleFixKey, CommonPartType.getMayChangeSemanticsText(mayChangeSemantics));
            if (string == null) {
                CommonPartType.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        private static String getMayChangeSemanticsText(boolean mayChangeSemantics) {
            return mayChangeSemantics ? " (" + InspectionGadgetsBundle.message("inspection.note.may.change.semantics", new Object[0]) + ")" : "";
        }

        @NotNull
        private String getDescriptionMessage(boolean mayChangeSemantics) {
            String string = InspectionGadgetsBundle.message(this.myBundleDescriptionKey, CommonPartType.getMayChangeSemanticsText(mayChangeSemantics));
            if (string == null) {
                CommonPartType.$$$reportNull$$$0(1);
            }
            return string;
        }

        private CommonPartType(String key2, String bundleDescriptionKey) {
            if (key2 == null) {
                CommonPartType.$$$reportNull$$$0(2);
            }
            if (bundleDescriptionKey == null) {
                CommonPartType.$$$reportNull$$$0(3);
            }
            this.myBundleFixKey = key2;
            this.myBundleDescriptionKey = bundleDescriptionKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CommonPartType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bundleDescriptionKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptionMessage";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$CommonPartType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class VariableDeclarationUnit
    extends ExtractionUnit {
        @NotNull
        final PsiLocalVariable myThenVariable;
        @NotNull
        final PsiLocalVariable myElseVariable;
        String myNewVariableName;

        private VariableDeclarationUnit(@NotNull PsiStatement thenStatement, @NotNull PsiStatement elseStatement, boolean mayChangeSemantics, boolean mayInfluenceCondition, boolean isEquivalent, @NotNull PsiLocalVariable thenVariable, @NotNull PsiLocalVariable elseVariable) {
            if (thenStatement == null) {
                VariableDeclarationUnit.$$$reportNull$$$0(0);
            }
            if (elseStatement == null) {
                VariableDeclarationUnit.$$$reportNull$$$0(1);
            }
            if (thenVariable == null) {
                VariableDeclarationUnit.$$$reportNull$$$0(2);
            }
            if (elseVariable == null) {
                VariableDeclarationUnit.$$$reportNull$$$0(3);
            }
            super(thenStatement, elseStatement, mayChangeSemantics, mayInfluenceCondition, isEquivalent);
            this.myThenVariable = thenVariable;
            this.myElseVariable = elseVariable;
        }

        @Override
        void cleanup(@NotNull CommentTracker ct, PsiElementFactory factory, PsiIfStatement ifStatement) {
            PsiExpression elseInitializer;
            PsiStatement elseAssignment;
            if (ct == null) {
                VariableDeclarationUnit.$$$reportNull$$$0(4);
            }
            if (this.isEquivalent()) {
                super.cleanup(ct, factory, ifStatement);
                return;
            }
            String type2 = this.myThenVariable.getType().getCanonicalText();
            PsiExpression thenInitializer = this.myThenVariable.getInitializer();
            PsiStatement thenAssignment = VariableDeclarationUnit.createAssignment(thenInitializer, type2, this.myNewVariableName, ifStatement, factory);
            if (thenAssignment != null) {
                this.getThenStatement().replace((PsiElement)thenAssignment);
            }
            if ((elseAssignment = VariableDeclarationUnit.createAssignment(elseInitializer = this.myElseVariable.getInitializer(), type2, this.myNewVariableName, ifStatement, factory)) != null) {
                ct.replace((PsiElement)this.getElseStatement(), (PsiElement)elseAssignment);
            }
        }

        private static PsiStatement createAssignment(PsiExpression initializer, String type2, String varName, PsiIfStatement ifStatement, PsiElementFactory factory) {
            if (initializer == null) {
                return null;
            }
            String initializerText = initializer instanceof PsiArrayInitializerExpression ? "new " + type2 + initializer.getText() : initializer.getText();
            return factory.createStatementFromText(varName + "=" + initializerText + ";", (PsiElement)ifStatement);
        }

        @Override
        @NotNull
        PsiStatement getStatementToPutBeforeIf(PsiElementFactory factory, @NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                VariableDeclarationUnit.$$$reportNull$$$0(5);
            }
            if (this.isEquivalent()) {
                PsiStatement psiStatement = this.getThenStatement();
                if (psiStatement == null) {
                    VariableDeclarationUnit.$$$reportNull$$$0(6);
                }
                return psiStatement;
            }
            String thenVariableTypeText = this.myThenVariable.getType().getCanonicalText();
            PsiModifierList thenModifierList = this.myThenVariable.getModifierList();
            String modifiers = thenModifierList == null || thenModifierList.getText().isEmpty() ? "" : thenModifierList.getText() + " ";
            PsiStatement psiStatement = factory.createStatementFromText(modifiers + thenVariableTypeText + " " + this.myNewVariableName + ";", ifStatement.getParent());
            if (psiStatement == null) {
                VariableDeclarationUnit.$$$reportNull$$$0(7);
            }
            return psiStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenVariable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseVariable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$VariableDeclarationUnit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$VariableDeclarationUnit";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatementToPutBeforeIf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanup";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatementToPutBeforeIf";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExtractionUnit {
        private final boolean myMayChangeSemantics;
        private final boolean myMayInfluenceCondition;
        @NotNull
        private final PsiStatement myThenStatement;
        @NotNull
        private final PsiStatement myElseStatement;
        private final boolean myIsEquivalent;

        private ExtractionUnit(@NotNull PsiStatement thenStatement, @NotNull PsiStatement elseStatement, boolean mayChangeSemantics, boolean mayInfluenceCondition, boolean isEquivalent) {
            if (thenStatement == null) {
                ExtractionUnit.$$$reportNull$$$0(0);
            }
            if (elseStatement == null) {
                ExtractionUnit.$$$reportNull$$$0(1);
            }
            this.myMayChangeSemantics = mayChangeSemantics;
            this.myThenStatement = thenStatement;
            this.myElseStatement = elseStatement;
            this.myMayInfluenceCondition = mayInfluenceCondition;
            this.myIsEquivalent = isEquivalent;
        }

        boolean haveSideEffects() {
            return this.myMayChangeSemantics;
        }

        @NotNull
        PsiStatement getThenStatement() {
            PsiStatement psiStatement = this.myThenStatement;
            if (psiStatement == null) {
                ExtractionUnit.$$$reportNull$$$0(2);
            }
            return psiStatement;
        }

        @NotNull
        PsiStatement getElseStatement() {
            PsiStatement psiStatement = this.myElseStatement;
            if (psiStatement == null) {
                ExtractionUnit.$$$reportNull$$$0(3);
            }
            return psiStatement;
        }

        boolean isEquivalent() {
            return this.myIsEquivalent;
        }

        boolean mayInfluenceCondition() {
            return this.myMayInfluenceCondition;
        }

        @NotNull
        PsiStatement getStatementToPutBeforeIf(PsiElementFactory factory, @NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                ExtractionUnit.$$$reportNull$$$0(4);
            }
            PsiStatement psiStatement = (PsiStatement)this.myThenStatement.copy();
            if (psiStatement == null) {
                ExtractionUnit.$$$reportNull$$$0(5);
            }
            return psiStatement;
        }

        void cleanup(@NotNull CommentTracker ct, PsiElementFactory factory, PsiIfStatement ifStatement) {
            if (ct == null) {
                ExtractionUnit.$$$reportNull$$$0(6);
            }
            this.myThenStatement.delete();
            ct.delete((PsiElement)this.myElseStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseStatement";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ExtractionUnit";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ExtractionUnit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThenStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElseStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatementToPutBeforeIf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatementToPutBeforeIf";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExtractCommonIfPartsFix
    implements LocalQuickFix {
        private final CommonPartType myType;
        private final boolean myMayChangeSemantics;
        private final boolean myIsOnTheFly;

        private ExtractCommonIfPartsFix(CommonPartType type2, boolean mayChangeSemantics, boolean isOnTheFly) {
            this.myType = type2;
            this.myMayChangeSemantics = mayChangeSemantics;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.common.if.parts.family", (Object[])new Object[0]);
            if (string == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myType.getFixMessage(this.myMayChangeSemantics);
            if (string == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiStatement[] elseStatements;
            PsiStatement[] thenStatements;
            PsiIfStatement ifStatement;
            if (project == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(3);
            }
            if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiIfStatement.class, (boolean)false)) == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (!(ifStatement.getParent() instanceof PsiCodeBlock)) {
                ifStatement = BlockUtils.expandSingleStatementToBlockStatement(ifStatement);
            }
            if (this.tryApplyThenElseFix(ifStatement, factory, thenStatements = IfStatementWithIdenticalBranchesInspection.unwrap(ifStatement.getThenBranch()), elseStatements = IfStatementWithIdenticalBranchesInspection.unwrap(ifStatement.getElseBranch()))) {
                return;
            }
            ExtractCommonIfPartsFix.applyImplicitElseFix(ifStatement, thenStatements, elseStatements);
        }

        private static void applyImplicitElseFix(PsiIfStatement ifStatement, PsiStatement[] thenStatements, PsiStatement[] elseStatements) {
            ImplicitElse implicitElse = ImplicitElse.from(thenStatements, elseStatements, ifStatement);
            if (implicitElse == null) {
                return;
            }
            PsiIfStatement ifToDelete = implicitElse.myIfToDelete;
            CommentTracker ct = new CommentTracker();
            PsiElement parent = ifToDelete.getParent();
            if (ifToDelete == ifStatement) {
                PsiExpression condition2 = ifToDelete.getCondition();
                if (condition2 == null) {
                    return;
                }
                ct.markUnchanged(condition2);
                List<PsiExpression> sideEffectExpressions = SideEffectChecker.extractSideEffectExpressions(condition2);
                PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements(sideEffectExpressions, condition2);
                for (int statementIndex = sideEffectStatements.length - 1; statementIndex >= 0; --statementIndex) {
                    PsiStatement statement = sideEffectStatements[statementIndex];
                    parent.addAfter((PsiElement)statement, (PsiElement)ifToDelete);
                }
            }
            ct.deleteAndRestoreComments((PsiElement)ifToDelete);
        }

        private boolean tryApplyThenElseFix(PsiIfStatement ifStatement, PsiElementFactory factory, PsiStatement[] thenStatements, PsiStatement[] elseStatements) {
            ThenElse thenElse = ThenElse.from(ifStatement, thenStatements, elseStatements, this.myIsOnTheFly);
            if (thenElse == null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return false;
            }
            CommentTracker ct = new CommentTracker();
            if (!ExtractCommonIfPartsFix.tryCleanUpHead(ifStatement, thenElse.myHeadUnitsOfThen, factory, thenElse.mySubstitutionTable, ct)) {
                return true;
            }
            ExtractCommonIfPartsFix.cleanUpTail(ifStatement, thenElse.myTailStatementsOfThen, ct);
            boolean elseToDelete = ControlFlowUtils.unwrapBlock(ifStatement.getElseBranch()).length == 0;
            boolean thenToDelete = ControlFlowUtils.unwrapBlock(ifStatement.getThenBranch()).length == 0;
            ct.insertCommentsBefore((PsiElement)ifStatement);
            if (thenToDelete && elseToDelete) {
                ifStatement.delete();
            } else {
                if (thenElse.myCommonPartType != CommonPartType.WHOLE_BRANCH) {
                    return true;
                }
                if (elseToDelete) {
                    elseBranch.delete();
                } else if (thenToDelete) {
                    PsiExpression condition2 = ifStatement.getCondition();
                    if (condition2 == null) {
                        return true;
                    }
                    String negatedCondition = BoolUtils.getNegatedExpressionText(condition2);
                    String newThenBranch = elseBranch.getText();
                    ifStatement.replace((PsiElement)factory.createStatementFromText("if(" + negatedCondition + ")" + newThenBranch, (PsiElement)ifStatement));
                }
            }
            return true;
        }

        private static boolean tryCleanUpHead(@NotNull PsiIfStatement ifStatement, @NotNull List<? extends ExtractionUnit> units, @NotNull PsiElementFactory factory, @NotNull Map<PsiLocalVariable, String> substitutionTable, @NotNull CommentTracker ct) {
            if (ifStatement == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(4);
            }
            if (units == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(5);
            }
            if (factory == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(6);
            }
            if (substitutionTable == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(7);
            }
            if (ct == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(8);
            }
            HashMap<PsiReferenceExpression, String> referenceToNewName = new HashMap<PsiReferenceExpression, String>();
            HashMap<PsiLocalVariable, String> variableToNewName = new HashMap<PsiLocalVariable, String>();
            for (ExtractionUnit extractionUnit : units) {
                if (!(extractionUnit instanceof VariableDeclarationUnit)) continue;
                VariableDeclarationUnit variableDeclarationUnit = (VariableDeclarationUnit)extractionUnit;
                PsiLocalVariable thenVariable = variableDeclarationUnit.myThenVariable;
                PsiLocalVariable elseVariable = variableDeclarationUnit.myElseVariable;
                String baseName = substitutionTable.get(elseVariable);
                JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)ifStatement.getProject());
                if (baseName != null) {
                    Predicate<PsiVariable> canReuseVariable = var -> PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)var, (boolean)false);
                    String nameToBeReplacedWith = manager.suggestUniqueVariableName(baseName, (PsiElement)ifStatement, canReuseVariable);
                    for (PsiReference reference2 : ReferencesSearch.search((PsiElement)thenVariable, (SearchScope)new LocalSearchScope((PsiElement)ifStatement))) {
                        PsiReferenceExpression expression2 = (PsiReferenceExpression)reference2.getElement();
                        referenceToNewName.put(expression2, nameToBeReplacedWith);
                    }
                    for (PsiReference reference2 : ReferencesSearch.search((PsiElement)elseVariable, (SearchScope)new LocalSearchScope((PsiElement)ifStatement))) {
                        PsiReferenceExpression expression2 = (PsiReferenceExpression)reference2.getElement();
                        referenceToNewName.put(expression2, nameToBeReplacedWith);
                    }
                    variableToNewName.put(thenVariable, nameToBeReplacedWith);
                    variableToNewName.put(elseVariable, nameToBeReplacedWith);
                    variableDeclarationUnit.myNewVariableName = nameToBeReplacedWith;
                    continue;
                }
                variableDeclarationUnit.myNewVariableName = thenVariable.getName();
            }
            referenceToNewName.forEach((reference, newName) -> ExpressionUtils.bindReferenceTo(reference, newName));
            variableToNewName.forEach((variable, newName) -> variable.setName(newName));
            PsiElement parent = ifStatement.getParent();
            for (ExtractionUnit extractionUnit : units) {
                PsiStatement statement = extractionUnit.getStatementToPutBeforeIf(factory, ifStatement);
                parent.addBefore((PsiElement)statement, (PsiElement)ifStatement);
                extractionUnit.cleanup(ct, factory, ifStatement);
            }
            return true;
        }

        private static void cleanUpTail(@NotNull PsiIfStatement ifStatement, @NotNull List<? extends PsiStatement> tailStatements, CommentTracker ct) {
            if (ifStatement == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(9);
            }
            if (tailStatements == null) {
                ExtractCommonIfPartsFix.$$$reportNull$$$0(10);
            }
            if (!tailStatements.isEmpty()) {
                for (PsiStatement psiStatement : tailStatements) {
                    ifStatement.getParent().addAfter(psiStatement.copy(), (PsiElement)ifStatement);
                }
                PsiStatement[] thenStatements = ControlFlowUtils.unwrapBlock(ifStatement.getThenBranch());
                PsiStatement[] psiStatementArray = ControlFlowUtils.unwrapBlock(ifStatement.getElseBranch());
                int thenLength = thenStatements.length;
                int elseLength = psiStatementArray.length;
                for (int i = 0; i < tailStatements.size(); ++i) {
                    PsiStatement thenStatement = thenStatements[thenLength - 1 - i];
                    if (thenStatements.length == 1 && thenStatement.getParent() == ifStatement) {
                        thenStatement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)thenStatement.getProject()).createCodeBlock());
                    } else {
                        thenStatement.delete();
                    }
                    ct.delete((PsiElement)psiStatementArray[elseLength - 1 - i]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ExtractCommonIfPartsFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "units";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutionTable";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tailStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$ExtractCommonIfPartsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "tryCleanUpHead";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanUpTail";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeElseIfsFix
    implements LocalQuickFix {
        private MergeElseIfsFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaAnalysisBundle.message((String)"inspection.common.if.parts.family.else.if", (Object[])new Object[0]);
            if (string == null) {
                MergeElseIfsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.common.if.parts.family.else.if", (Object[])new Object[0]);
            if (string == null) {
                MergeElseIfsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiIfStatement ifStatement;
            if (project == null) {
                MergeElseIfsFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MergeElseIfsFix.$$$reportNull$$$0(3);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)descriptor.getStartElement().getParent(), PsiIfStatement.class)) == null) {
                return;
            }
            ElseIf elseIf = ElseIf.from(ifStatement, IfStatementWithIdenticalBranchesInspection.unwrap(ifStatement.getThenBranch()));
            if (elseIf == null) {
                return;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.markUnchanged(elseIf.myElseIfThen);
            ct.markUnchanged(condition2);
            ct.markUnchanged(elseIf.myElseIfCondition);
            ct.replace((PsiElement)elseIf.myElseBranch, (PsiElement)elseIf.myElseIfElseStatement);
            String firstCondition = ParenthesesUtils.getText(condition2, 14);
            String secondCondition = ParenthesesUtils.getText(elseIf.myElseIfCondition, 14);
            String newCondition = firstCondition + "||" + secondCondition;
            ct.replaceAndRestoreComments((PsiElement)condition2, newCondition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$MergeElseIfsFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$MergeElseIfsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IfInspectionResult {
        @NotNull
        private final PsiElement myElementToHighlight;
        private final boolean myIsWarning;
        @NotNull
        private final LocalQuickFix myFix;
        @NotNull
        private final String myMessage;

        IfInspectionResult(@NotNull PsiElement elementToHighlight, boolean isWarning, @NotNull LocalQuickFix fix, @NotNull String message2) {
            if (elementToHighlight == null) {
                IfInspectionResult.$$$reportNull$$$0(0);
            }
            if (fix == null) {
                IfInspectionResult.$$$reportNull$$$0(1);
            }
            if (message2 == null) {
                IfInspectionResult.$$$reportNull$$$0(2);
            }
            this.myElementToHighlight = elementToHighlight;
            this.myIsWarning = isWarning;
            this.myFix = fix;
            this.myMessage = message2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elementToHighlight";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/controlflow/IfStatementWithIdenticalBranchesInspection$IfInspectionResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    private static interface IfStatementInspector {
        @Nullable
        public IfInspectionResult inspect(@NotNull PsiIfStatement var1, PsiStatement @NotNull [] var2, PsiStatement @NotNull [] var3, boolean var4, boolean var5);
    }
}

